/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.Query;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SaveTest
extends AbstractJCRTest {
    private String statement;

    protected void setUp() throws Exception {
        super.setUp();
        this.statement = "//*[@jcr:primaryType='" + this.ntBase + "']";
    }

    public void testSave() throws RepositoryException, NotExecutableException {
        this.checkNtQuery();
        Query query = this.superuser.getWorkspace().getQueryManager().createQuery(this.statement, "xpath");
        query.storeAsNode(this.testRoot + "/" + this.nodeName1);
        SaveTest.assertTrue((String)"Node has not been stored", (boolean)this.testRootNode.hasNode(this.nodeName1));
        Node queryNode = this.testRootNode.getNode(this.nodeName1);
        SaveTest.assertTrue((String)"Query node is not of type nt:query", (boolean)queryNode.isNodeType(this.ntQuery));
        Query query2 = this.superuser.getWorkspace().getQueryManager().getQuery(queryNode);
        SaveTest.assertEquals((String)"Persisted query does not match initial query.", (String)query.getStatement(), (String)query2.getStatement());
    }

    public void testItemExistsException() throws RepositoryException, NotExecutableException {
        block3: {
            this.checkNtQuery();
            Query query = this.superuser.getWorkspace().getQueryManager().createQuery(this.statement, "xpath");
            Node qNode = query.storeAsNode(this.testRoot + "/" + this.nodeName1);
            query = this.superuser.getWorkspace().getQueryManager().createQuery(this.statement, "xpath");
            try {
                query.storeAsNode(this.testRoot + "/" + this.nodeName1);
                if (!qNode.getDefinition().allowsSameNameSiblings()) {
                    SaveTest.fail((String)"Query.storeAsNode() did not throw ItemExistsException");
                }
            }
            catch (ItemExistsException e) {
                if (!qNode.getDefinition().allowsSameNameSiblings()) break block3;
                SaveTest.fail((String)"Query.storeAsNode() must not throw ItemExistsException when same name siblings are allowed");
            }
        }
    }

    public void testPathNotFoundException() throws RepositoryException, NotExecutableException {
        this.checkNtQuery();
        Query query = this.superuser.getWorkspace().getQueryManager().createQuery(this.statement, "xpath");
        try {
            query.storeAsNode(this.testRoot + "/" + this.nodeName1 + "/" + this.nodeName1);
            SaveTest.fail((String)"Query.storeAsNode() must throw PathNotFoundException on invalid path");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testVersionException() throws RepositoryException, NotExecutableException {
        this.checkNtQuery();
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException();
        }
        Query query = this.superuser.getWorkspace().getQueryManager().createQuery(this.statement, "xpath");
        Node versionable = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!versionable.isNodeType(this.mixVersionable)) {
            if (versionable.canAddMixin(this.mixVersionable)) {
                versionable.addMixin(this.mixVersionable);
            } else {
                SaveTest.fail((String)("Node " + this.nodeName1 + " is not versionable and does not allow to add mix:versionable"));
            }
        }
        this.testRootNode.save();
        versionable.checkin();
        try {
            query.storeAsNode(this.testRoot + "/" + this.nodeName1 + "/" + this.nodeName2);
            SaveTest.fail((String)"Query.storeAsNode() must throw VersionException, parent node is checked in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testConstraintViolationException() throws RepositoryException, NotExecutableException {
        this.checkNtQuery();
        Query query = this.superuser.getWorkspace().getQueryManager().createQuery(this.statement, "xpath");
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            query.storeAsNode(this.testRoot + "/" + this.nodeName1 + "/" + this.nodeName2);
            SaveTest.fail((String)"Query.storeAsNode() must throw ConstraintViolationException, parent node does not allow child nodes.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockException() throws RepositoryException, NotExecutableException {
        this.checkNtQuery();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException();
        }
        Node lockable = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!lockable.isNodeType(this.mixLockable)) {
            if (lockable.canAddMixin(this.mixLockable)) {
                lockable.addMixin(this.mixLockable);
            } else {
                SaveTest.fail((String)("Node " + this.nodeName1 + " is not lockable and does not allow to add mix:lockable"));
            }
        }
        this.testRootNode.save();
        lockable.lock(false, true);
        Session readWrite = helper.getReadWriteSession();
        try {
            Query query = readWrite.getWorkspace().getQueryManager().createQuery(this.statement, "xpath");
            query.storeAsNode(this.testRoot + "/" + this.nodeName1 + "/" + this.nodeName2);
            SaveTest.fail((String)"Query.storeAsNode() must throw LockException, parent node is locked.");
        }
        catch (LockException lockException) {
        }
        finally {
            readWrite.logout();
            lockable.unlock();
        }
    }

    public void testRepositoryException() throws RepositoryException, NotExecutableException {
        this.checkNtQuery();
        Query query = this.superuser.getWorkspace().getQueryManager().createQuery(this.statement, "xpath");
        try {
            query.storeAsNode(this.testRoot + "/invalid[path");
            SaveTest.fail((String)"Query.storeAsNode() must throw RepositoryException on malformed path.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    private void checkNtQuery() throws RepositoryException, NotExecutableException {
        try {
            this.superuser.getWorkspace().getNodeTypeManager().getNodeType(this.ntQuery);
        }
        catch (NoSuchNodeTypeException e) {
            throw new NotExecutableException("repository does not support nt:query");
        }
    }
}

