/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeCancelMergeTest
extends AbstractMergeTest {
    Node nodeToMerge;

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
        this.nodeToMerge.checkout();
    }

    protected void tearDown() throws Exception {
        this.nodeToMerge = null;
        super.tearDown();
    }

    public void testMergeNodeCancelMerge() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), true);
        Version[] predecessors = this.nodeToMerge.getBaseVersion().getPredecessors();
        Property mergeFailedProperty = this.nodeToMerge.getProperty(this.jcrMergeFailed);
        Value[] mergeFailedReferences = mergeFailedProperty.getValues();
        for (int i = 0; i < mergeFailedReferences.length; ++i) {
            String uuid = mergeFailedReferences[i].getString();
            this.nodeToMerge.cancelMerge((Version)this.superuser.getNodeByUUID(uuid));
        }
        Version[] predecessorsAfterCancel = this.nodeToMerge.getBaseVersion().getPredecessors();
        MergeCancelMergeTest.assertTrue((predecessors.length == predecessorsAfterCancel.length ? 1 : 0) != 0);
        if (this.nodeToMerge.hasProperty(this.jcrMergeFailed)) {
            Property mergeFailedPropertyAfterCancelMerge = this.nodeToMerge.getProperty(this.jcrMergeFailed);
            Value[] mergeFailedReferencesAfterCancelMerge = mergeFailedPropertyAfterCancelMerge.getValues();
            MergeCancelMergeTest.assertTrue((mergeFailedReferences.length > mergeFailedReferencesAfterCancelMerge.length ? 1 : 0) != 0);
        }
    }

    protected void initNodes() throws RepositoryException {
        Node topVNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        topVNode.setProperty(this.propertyName1, topVNode.getName());
        this.testRootNode.save();
        topVNode.checkin();
        topVNode.checkout();
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), topVNode.getPath(), topVNode.getPath(), true);
        this.log.println(topVNode.getPath() + " cloned on " + this.superuserW2.getWorkspace().getName() + " at " + topVNode.getPath());
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
    }
}

