/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.MergeException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeCheckedoutSubNodeTest
extends AbstractMergeTest {
    Node nodeToMerge;

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
        this.nodeToMerge.checkout();
    }

    protected void tearDown() throws Exception {
        this.nodeToMerge = null;
        super.tearDown();
    }

    public void testFailIfCorrespondingNodeIsSuccessor() throws RepositoryException {
        Node n = this.testRootNode.getNode(this.nodeName1 + "/" + this.nodeName2);
        n.checkout();
        n.checkin();
        n.checkout();
        try {
            this.nodeToMerge.merge(this.workspace.getName(), false);
            MergeCheckedoutSubNodeTest.fail((String)"Merging a checkedout node if the version V' of the corresponding node is a successor of this node's base version must fail.");
        }
        catch (MergeException mergeException) {
            // empty catch block
        }
    }

    public void testLeaveIfCorrespondingNodeIsPredeccessor() throws RepositoryException {
        Node n = this.testRootNodeW2.getNode(this.nodeName1 + "/" + this.nodeName2);
        n.checkout();
        n.setProperty(this.propertyName1, "changed");
        this.testRootNodeW2.save();
        n.checkin();
        n.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), false);
        MergeCheckedoutSubNodeTest.assertTrue((boolean)n.getProperty(this.propertyName1).getString().equals("changed"));
    }

    protected void initNodes() throws RepositoryException {
        Node topVNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        topVNode.setProperty(this.propertyName1, topVNode.getName());
        Node subNvNode = topVNode.addNode(this.nodeName2, this.versionableNodeType);
        subNvNode.setProperty(this.propertyName1, subNvNode.getName());
        this.testRootNode.save();
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), topVNode.getPath(), topVNode.getPath(), true);
        this.log.println(topVNode.getPath() + " cloned on " + this.superuserW2.getWorkspace().getName() + " at " + topVNode.getPath());
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
    }
}

