/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class VersionStorageTest
extends AbstractVersionTest {
    protected String versionStoragePath;

    protected void setUp() throws Exception {
        super.setUp();
        this.versionStoragePath = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":system/" + this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":versionStorage";
    }

    public void testVersionStorageProtected() throws RepositoryException {
        try {
            this.versionableNode.getBaseVersion().setProperty(this.jcrCreated, GregorianCalendar.getInstance());
            VersionStorageTest.fail((String)"It should not be possible to modify a subnode/version in version storage.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionStorageIdenticalAcrossAllWorkspaces() throws RepositoryException {
        Session superuserW2 = helper.getSuperuserSession(this.workspaceName);
        try {
            VersionStorageTest.assertTrue((String)("Version strorage must be reflected as a subtree below the node '" + this.versionStoragePath + "'"), (boolean)superuserW2.getRootNode().hasNode(this.versionStoragePath));
            try {
                Node versionStorageNodeW2 = superuserW2.getRootNode().getNode(this.versionStoragePath);
                versionStorageNodeW2.addNode(this.nodeName1, this.ntVersion);
                VersionStorageTest.fail((String)"It should not be possible to add a subnode/version in version storage.");
            }
            catch (ConstraintViolationException constraintViolationException) {
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            superuserW2.logout();
            throw throwable;
        }
        superuserW2.logout();
    }
}

