/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class BooleanPropertyTest
extends AbstractPropertyTest {
    protected int getPropertyType() {
        return 6;
    }

    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    public void testValue() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getBoolean();
                BooleanPropertyTest.fail((String)"Property.getBoolean() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            boolean otherBool;
            boolean bool = this.prop.getValue().getBoolean();
            BooleanPropertyTest.assertTrue((String)"Value.getBoolean() and Property.getBoolean() return different values.", (bool == (otherBool = this.prop.getBoolean()) ? 1 : 0) != 0);
        }
    }

    public void testGetDate() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDate();
            BooleanPropertyTest.fail((String)"Conversion from a Boolean value to a Date value should throw a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDouble() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDouble();
            BooleanPropertyTest.fail((String)"Conversion from a Boolean value to a Double value should throw a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLong() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getLong();
            BooleanPropertyTest.fail((String)"Conversion from a Boolean value to a Long value should throw a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetStream() throws RepositoryException, IOException {
        InputStream ins;
        block10: {
            Value val = PropertyUtil.getValue(this.prop);
            BufferedInputStream in = new BufferedInputStream(val.getStream());
            Value otherVal = PropertyUtil.getValue(this.prop);
            ins = null;
            byte[] utf8bytes = otherVal.getString().getBytes(UTF8);
            int i = 0;
            byte[] b = new byte[1];
            while (in.read(b) != -1) {
                BooleanPropertyTest.assertTrue((String)"Boolean as a Stream is not utf-8 encoded", (b[0] == utf8bytes[i] ? 1 : 0) != 0);
                ++i;
            }
            try {
                val.getBoolean();
                BooleanPropertyTest.fail((String)"Non stream method call after stream method call should throw an IllegalStateException");
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            try {
                try {
                    ins = otherVal.getStream();
                    BooleanPropertyTest.fail((String)"Stream method call after a non stream method call should throw an IllegalStateException");
                }
                catch (IllegalStateException ise) {
                    Object var10_11 = null;
                    if (in != null) {
                        in.close();
                    }
                    if (ins == null) return;
                    ins.close();
                    return;
                }
                Object var10_10 = null;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (in != null) {
                    in.close();
                }
                if (ins == null) throw throwable;
                ins.close();
                throw throwable;
            }
            in.close();
        }
        if (ins == null) return;
        ins.close();
    }

    public void testGetString() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        String otherStr = new Boolean(val.getBoolean()).toString();
        BooleanPropertyTest.assertEquals((String)"Conversion from a Boolean value to a String value failed.", (String)str, (String)otherStr);
    }

    public void testGetType() throws RepositoryException {
        BooleanPropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 6));
    }

    public void testAsReference() throws RepositoryException {
        if (!this.multiple) {
            try {
                this.prop.getNode();
                BooleanPropertyTest.fail((String)"Conversion from a Boolean value to a Reference value should throw a ValueFormatException");
            }
            catch (ValueFormatException vfe) {}
        } else {
            try {
                this.prop.getNode();
                BooleanPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetLength() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getLength();
                BooleanPropertyTest.fail((String)"Property.getLength() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            long length = this.prop.getLength();
            if (length > -1L) {
                BooleanPropertyTest.assertEquals((String)"Property.getLength() returns wrong number of bytes.", (long)length, (long)this.prop.getString().length());
            }
        }
    }

    public void testGetLengths() throws RepositoryException {
        if (this.multiple) {
            Value[] values = this.prop.getValues();
            long[] lengths = this.prop.getLengths();
            for (int i = 0; i < lengths.length; ++i) {
                if (lengths[i] <= -1L) continue;
                BooleanPropertyTest.assertEquals((String)"Property.getLengths() returns wrong array of the lengths of a multivalue property.", (long)values[i].getString().length(), (long)lengths[i]);
            }
        } else {
            try {
                this.prop.getLengths();
                BooleanPropertyTest.fail((String)"Property.getLengths() called on a sinlge value property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }
}

