/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.security.AccessControlException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class CheckPermissionTest
extends AbstractJCRTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckPermission() throws Exception {
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        Session readOnly = helper.getReadOnlySession();
        try {
            this.permissionCheckReadOnly(readOnly);
            this.permissionCheckReadWrite(this.superuser);
        }
        finally {
            readOnly.logout();
        }
    }

    private void permissionCheckReadOnly(Session readOnly) throws Exception {
        String pathPrefix = this.testRoot.length() == 1 ? this.testRoot : this.testRoot + "/";
        readOnly.checkPermission(this.testRoot, "read");
        try {
            readOnly.checkPermission(pathPrefix + this.nodeName1, "add_node");
            CheckPermissionTest.fail((String)"add_node permission granted to read-only Session");
        }
        catch (AccessControlException success) {
            // empty catch block
        }
        try {
            readOnly.checkPermission(pathPrefix + this.nodeName1, "set_property");
            CheckPermissionTest.fail((String)"set_property permission granted to read-only Session");
        }
        catch (AccessControlException success) {
            // empty catch block
        }
        try {
            readOnly.checkPermission(pathPrefix + this.nodeName2, "remove");
            CheckPermissionTest.fail((String)"remove permission granted to read-only Session");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private void permissionCheckReadWrite(Session readWrite) throws Exception {
        String pathPrefix = this.testRoot.length() == 1 ? this.testRoot : this.testRoot + "/";
        readWrite.checkPermission(this.testRoot, "read");
        readWrite.checkPermission(pathPrefix + this.nodeName1, "add_node");
        readWrite.checkPermission(pathPrefix + this.propertyName1, "set_property");
        readWrite.checkPermission(pathPrefix + this.nodeName2, "remove");
    }
}

