/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class DoublePropertyTest
extends AbstractPropertyTest {
    protected int getPropertyType() {
        return 4;
    }

    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    public void testValue() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getDouble();
                DoublePropertyTest.fail((String)"Property.getDouble() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            double dd;
            double d = this.prop.getValue().getDouble();
            DoublePropertyTest.assertTrue((String)"Value.getDouble() and Property.getDouble() return different values.", (d == (dd = this.prop.getDouble()) ? 1 : 0) != 0);
        }
    }

    public void testGetBoolean() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getBoolean();
            DoublePropertyTest.fail((String)"Conversion from a Double value to a Boolean value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDate() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        Calendar calendar = val.getDate();
        DoublePropertyTest.assertEquals((String)"Conversion from Double value to Date value is not correct.", (long)calendar.getTimeInMillis(), (long)new Double(val.getDouble()).longValue());
    }

    public void testGetLong() throws RepositoryException {
        long ll;
        Value val = PropertyUtil.getValue(this.prop);
        long l = val.getLong();
        DoublePropertyTest.assertTrue((String)"Conversion from Double value to Long value is not correct.", (l == (ll = new Double(val.getDouble()).longValue()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStream() throws RepositoryException, IOException {
        Value val = PropertyUtil.getValue(this.prop);
        BufferedInputStream in = new BufferedInputStream(val.getStream());
        Value otherVal = PropertyUtil.getValue(this.prop);
        InputStream ins = null;
        byte[] utf8bytes = otherVal.getString().getBytes();
        int i = 0;
        byte b = (byte)in.read();
        while (b != -1) {
            DoublePropertyTest.assertTrue((String)"Double as a Stream is not utf-8 encoded.", (b == utf8bytes[i] ? 1 : 0) != 0);
            b = (byte)in.read();
            ++i;
        }
        try {
            val.getDouble();
            DoublePropertyTest.fail((String)"Non stream method call after stream method call should throw an IllegalStateException.");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            ins = otherVal.getStream();
            DoublePropertyTest.fail((String)"Stream method call after a non stream method call should throw an IllegalStateException.");
        }
        catch (IllegalStateException ise) {
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (ins != null) {
                ins.close();
            }
        }
    }

    public void testGetString() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        String otherStr = Double.toString(val.getDouble());
        DoublePropertyTest.assertEquals((String)"Conversion from Double value to String value is not correct.", (String)str, (String)otherStr);
    }

    public void testGetType() throws RepositoryException {
        DoublePropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 4));
    }

    public void testAsReference() throws RepositoryException {
        if (!this.multiple) {
            try {
                this.prop.getNode();
                DoublePropertyTest.fail((String)"Conversion from a Double value to a Reference value should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            try {
                this.prop.getNode();
                DoublePropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetLength() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getLength();
                DoublePropertyTest.fail((String)"Property.getLength() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            long length = this.prop.getLength();
            if (length > -1L) {
                DoublePropertyTest.assertEquals((String)"Property.getLength() returns wrong number of bytes.", (long)length, (long)this.prop.getString().length());
            }
        }
    }

    public void testGetLengths() throws RepositoryException {
        if (this.multiple) {
            Value[] values = this.prop.getValues();
            long[] lengths = this.prop.getLengths();
            for (int i = 0; i < lengths.length; ++i) {
                if (lengths[i] <= -1L) continue;
                DoublePropertyTest.assertEquals((String)"Property.getLengths() returns wrong array of the lengths of a multivalue property.", (long)values[i].getString().length(), (long)lengths[i]);
            }
        } else {
            try {
                this.prop.getLengths();
                DoublePropertyTest.fail((String)"Property.getLengths() called on a sinlge value property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }
}

