/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class LongPropertyTest
extends AbstractPropertyTest {
    protected int getPropertyType() {
        return 3;
    }

    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    public void testValue() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getLong();
                LongPropertyTest.fail((String)"Property.getLong() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            long l = this.prop.getValue().getLong();
            long ll = this.prop.getLong();
            LongPropertyTest.assertEquals((String)"Value.getLong() and Property.getLong() return different values.", (long)l, (long)ll);
        }
    }

    public void testGetBoolean() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getBoolean();
            LongPropertyTest.fail((String)"Conversion from a Long value to a Boolean value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDate() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        Calendar calendar = val.getDate();
        LongPropertyTest.assertEquals((String)"Conversion from Long value to Date value is not correct.", (long)val.getLong(), (long)calendar.getTimeInMillis());
    }

    public void testGetDouble() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        double d = val.getDouble();
        LongPropertyTest.assertEquals((String)"Conversion from Long value to Double value is not correct.", (double)new Long(val.getLong()).doubleValue(), (double)d, (double)0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetStream() throws RepositoryException, IOException {
        InputStream ins;
        block10: {
            Value val = PropertyUtil.getValue(this.prop);
            BufferedInputStream in = new BufferedInputStream(val.getStream());
            Value otherVal = PropertyUtil.getValue(this.prop);
            ins = null;
            byte[] utf8bytes = otherVal.getString().getBytes(UTF8);
            int i = 0;
            byte[] b = new byte[1];
            while (in.read(b) != -1) {
                LongPropertyTest.assertEquals((String)"Long as a Stream is not utf-8 encoded.", (byte)utf8bytes[i], (byte)b[0]);
                ++i;
            }
            try {
                val.getLong();
                LongPropertyTest.fail((String)"Non stream method call after stream method call should throw an IllegalStateException.");
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            try {
                try {
                    ins = otherVal.getStream();
                    LongPropertyTest.fail((String)"Stream method call after a non stream method call should throw an IllegalStateException.");
                }
                catch (IllegalStateException ise) {
                    Object var10_11 = null;
                    if (in != null) {
                        in.close();
                    }
                    if (ins == null) return;
                    ins.close();
                    return;
                }
                Object var10_10 = null;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (in != null) {
                    in.close();
                }
                if (ins == null) throw throwable;
                ins.close();
                throw throwable;
            }
            in.close();
        }
        if (ins == null) return;
        ins.close();
    }

    public void testGetString() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        String otherStr = new Long(val.getLong()).toString();
        LongPropertyTest.assertEquals((String)"Conversion from a Long value to a String value is not correct", (String)str, (String)otherStr);
    }

    public void testGetType() throws RepositoryException {
        LongPropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 3));
    }

    public void testAsReference() throws RepositoryException {
        if (!this.multiple) {
            try {
                this.prop.getNode();
                LongPropertyTest.fail((String)"Conversion from a Double value to a Reference value should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            try {
                this.prop.getNode();
                LongPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetLength() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getLength();
                LongPropertyTest.fail((String)"Property.getLength() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            long length = this.prop.getLength();
            if (length > -1L) {
                LongPropertyTest.assertEquals((String)"Property.getLength() returns wrong number of bytes.", (long)length, (long)this.prop.getString().length());
            }
        }
    }

    public void testGetLengths() throws RepositoryException {
        if (this.multiple) {
            Value[] values = this.prop.getValues();
            long[] lengths = this.prop.getLengths();
            for (int i = 0; i < lengths.length; ++i) {
                if (lengths[i] <= -1L) continue;
                LongPropertyTest.assertEquals((String)"Property.getLengths() returns wrong array of the lengths of a multivalue property.", (long)values[i].getString().length(), (long)lengths[i]);
            }
        } else {
            try {
                this.prop.getLengths();
                LongPropertyTest.fail((String)"Property.getLengths() called on a sinlge value property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }
}

