/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeOrderableChildNodesTest
extends AbstractJCRTest {
    private Node initialFirstNode;
    private Node initialSecondNode;
    private Node parentNode;

    protected void tearDown() throws Exception {
        this.initialFirstNode = null;
        this.initialSecondNode = null;
        this.parentNode = null;
        super.tearDown();
    }

    public void testOrderBeforeInvalidDest() throws RepositoryException, NotExecutableException {
        this.checkOrderableNodeType(this.getProperty("nodetype2"));
        this.prepareTest();
        try {
            this.parentNode.orderBefore(this.initialSecondNode.getName(), "invalid");
            NodeOrderableChildNodesTest.fail((String)"Trying to reorder child nodes using Node.orderBefore() where destination is invalid should throw ItemNotFoundException!");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testOrderBeforeInvalidSrc() throws RepositoryException, NotExecutableException {
        this.checkOrderableNodeType(this.getProperty("nodetype2"));
        this.prepareTest();
        try {
            this.parentNode.orderBefore("invalid", this.initialFirstNode.getName());
            NodeOrderableChildNodesTest.fail((String)"Trying to reorder child nodes using Node.orderBefore() where source is invalid should throw ItemNotFoundException!");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testOrderBeforeUnsupportedRepositoryOperationException() throws RepositoryException, NotExecutableException {
        this.parentNode = this.testRootNode.addNode(this.nodeName1, this.getProperty("nodetype2"));
        Node firstNode = this.parentNode.addNode(this.nodeName2, this.getProperty("nodetype3"));
        Node secondNode = this.parentNode.addNode(this.nodeName3, this.getProperty("nodetype3"));
        this.superuser.save();
        try {
            this.parentNode.orderBefore(secondNode.getName(), firstNode.getName());
            NodeOrderableChildNodesTest.fail((String)"Trying to reorder child nodes using Node.orderBefore() on node that does not support ordering should throw UnsupportedRepositoryException!");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testOrderBeforePlaceAtEndParentSave() throws RepositoryException, NotExecutableException {
        this.checkOrderableNodeType(this.getProperty("nodetype2"));
        this.prepareTest();
        this.parentNode.orderBefore(this.initialFirstNode.getName(), null);
        this.parentNode.save();
        NodeIterator it = this.parentNode.getNodes();
        Node firstNode = it.nextNode();
        Node secondNode = it.nextNode();
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order after Node.orderBefore()!", (boolean)firstNode.isSame((Item)this.initialSecondNode));
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order after Node.orderBefore()!", (boolean)secondNode.isSame((Item)this.initialFirstNode));
    }

    public void testOrderBeforePlaceAtEndSessionSave() throws RepositoryException, NotExecutableException {
        this.checkOrderableNodeType(this.getProperty("nodetype2"));
        this.prepareTest();
        this.parentNode.orderBefore(this.initialFirstNode.getName(), null);
        this.superuser.save();
        NodeIterator it = this.parentNode.getNodes();
        Node firstNode = it.nextNode();
        Node secondNode = it.nextNode();
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order after Node.orderBefore()!", (boolean)firstNode.isSame((Item)this.initialSecondNode));
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order after Node.orderBefore()!", (boolean)secondNode.isSame((Item)this.initialFirstNode));
    }

    public void testOrderBeforeSecondToFirstParentSave() throws RepositoryException, NotExecutableException {
        this.checkOrderableNodeType(this.getProperty("nodetype2"));
        this.prepareTest();
        this.parentNode.orderBefore(this.initialSecondNode.getName(), this.initialFirstNode.getName());
        this.parentNode.save();
        NodeIterator it = this.parentNode.getNodes();
        Node firstNode = it.nextNode();
        Node secondNode = it.nextNode();
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order after Node.orderBefore()!", (boolean)firstNode.isSame((Item)this.initialSecondNode));
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order after Node.orderBefore()!", (boolean)secondNode.isSame((Item)this.initialFirstNode));
    }

    public void testOrderBeforeSecondToFirstSessionSave() throws RepositoryException, NotExecutableException {
        this.checkOrderableNodeType(this.getProperty("nodetype2"));
        this.prepareTest();
        this.parentNode.orderBefore(this.initialSecondNode.getName(), this.initialFirstNode.getName());
        this.superuser.save();
        NodeIterator it = this.parentNode.getNodes();
        Node firstNode = it.nextNode();
        Node secondNode = it.nextNode();
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order after Node.orderBefore()!", (boolean)firstNode.isSame((Item)this.initialSecondNode));
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order after Node.orderBefore()!", (boolean)secondNode.isSame((Item)this.initialFirstNode));
    }

    private void prepareTest() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        this.parentNode = defaultRootNode.addNode(this.nodeName1, this.getProperty("nodetype2"));
        Node firstNode = this.parentNode.addNode(this.nodeName2, this.getProperty("nodetype3"));
        Node secondNode = this.parentNode.addNode(this.nodeName3, this.getProperty("nodetype3"));
        this.superuser.save();
        NodeIterator it = this.parentNode.getNodes();
        this.initialFirstNode = it.nextNode();
        this.initialSecondNode = it.nextNode();
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order ", (boolean)firstNode.isSame((Item)this.initialFirstNode));
        NodeOrderableChildNodesTest.assertTrue((String)"Child nodes are not added in proper order ", (boolean)secondNode.isSame((Item)this.initialSecondNode));
    }

    private void checkOrderableNodeType(String ntName) throws RepositoryException, NotExecutableException {
        NodeType nt = this.superuser.getWorkspace().getNodeTypeManager().getNodeType(ntName);
        if (!nt.hasOrderableChildNodes()) {
            throw new NotExecutableException("NodeType: " + ntName + " does not support orderable child nodes.");
        }
    }
}

