/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class PropertyItemIsNewTest
extends AbstractJCRTest {
    protected Node testNode;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            PropertyItemIsNewTest.fail((String)("Failed to create test node." + e.getMessage()));
        }
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    public void testTransientPropertyItemIsNew() throws RepositoryException {
        Property testProperty = this.testNode.setProperty(this.propertyName1, "test");
        Item testPropertyItem = this.superuser.getItem(testProperty.getPath());
        PropertyItemIsNewTest.assertTrue((String)"Item.isNew() must return true directly after a new Property is set (before current node is saved)", (boolean)testPropertyItem.isNew());
    }

    public void testPersistentPropertyItemIsNew() throws RepositoryException {
        Property testProperty = this.testNode.setProperty(this.propertyName1, "test");
        this.testNode.save();
        Item testPropertyItem = this.superuser.getItem(testProperty.getPath());
        PropertyItemIsNewTest.assertFalse((String)"Item.isNew() must return false after a new PropertyItem is set and the current Node is saved", (boolean)testPropertyItem.isNew());
    }
}

