/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.SerializationContext;
import org.apache.jackrabbit.test.api.TreeComparator;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SerializationTest
extends AbstractJCRTest {
    protected Workspace workspace;
    protected File file;
    protected TreeComparator treeComparator;
    protected final boolean CONTENTHANDLER = true;
    protected final boolean STREAM = false;
    protected final boolean WORKSPACE = true;
    protected final boolean SESSION = false;
    protected final boolean SKIPBINARY = true;
    protected final boolean SAVEBINARY = false;
    protected final boolean NORECURSE = true;
    protected final boolean RECURSE = false;
    protected Session session;

    public void setUp() throws RepositoryException, Exception {
        super.setUp();
        try {
            this.session = this.superuser;
            this.workspace = this.session.getWorkspace();
            this.file = File.createTempFile("serializationTest", ".xml");
            this.log.print("Tempfile: " + this.file.getAbsolutePath());
            SerializationContext sc = new SerializationContext(this);
            this.treeComparator = new TreeComparator(sc, this.session);
            ((Object)((Object)this.treeComparator)).getClass();
            this.treeComparator.createComplexTree(true);
        }
        catch (Exception ex) {
            if (this.file != null) {
                this.file.delete();
                this.file = null;
            }
            throw ex;
        }
    }

    public void tearDown() throws Exception {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
            this.session = null;
        }
        if (this.treeComparator != null) {
            this.treeComparator.tearDown();
        }
        this.workspace = null;
        super.tearDown();
    }

    protected Node initVersioningException(boolean returnParent) throws RepositoryException, NotExecutableException, IOException {
        Node vNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!vNode.isNodeType(this.mixVersionable)) {
            if (vNode.canAddMixin(this.mixVersionable)) {
                vNode.addMixin(this.mixVersionable);
            } else {
                throw new NotExecutableException("NodeType: " + this.testNodeType + " is not versionable");
            }
        }
        Node vChild = vNode.addNode(this.nodeName2, this.testNodeType);
        this.session.save();
        vNode.checkin();
        this.exportRepository(true, false);
        if (returnParent) {
            return vNode;
        }
        return vChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTestVersioningExceptionFileParent(boolean useWorkspace, boolean useHandler) throws Exception {
        Node n = this.initVersioningException(true);
        FileInputStream in = new FileInputStream(this.file);
        try {
            try {
                this.doImport(n.getPath(), in, useWorkspace, useHandler);
                SerializationTest.fail((String)"Importing to a checked-in node must throw a ConstraintViolationException.");
            }
            catch (VersionException e) {
                Object var7_6 = null;
                in.close();
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTestVersioningExceptionFileChild(boolean useWorkspace, boolean useHandler) throws Exception {
        Node n = this.initVersioningException(false);
        FileInputStream in = new FileInputStream(this.file);
        try {
            try {
                this.doImport(n.getPath(), in, useWorkspace, useHandler);
                SerializationTest.fail((String)"Importing to a child of a checked-in node must throw a ConstraintViolationException.");
            }
            catch (VersionException e) {
                Object var7_6 = null;
                in.close();
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public void testVersioningExceptionFileParentWorkspaceContentHandler() throws Exception {
        this.doTestVersioningExceptionFileParent(true, true);
    }

    public void testVersioningExceptionFileParentSessionContentHandler() throws Exception {
        this.doTestVersioningExceptionFileParent(false, true);
    }

    public void testVersioningExceptionFileParentWorkspace() throws Exception {
        this.doTestVersioningExceptionFileParent(true, false);
    }

    public void testVersioningExceptionFileParentSession() throws Exception {
        this.doTestVersioningExceptionFileParent(false, false);
    }

    public void testVersioningExceptionFileChildWorkspaceContentHandler() throws Exception {
        this.doTestVersioningExceptionFileChild(true, true);
    }

    public void testVersioningExceptionFileChildSessionContentHandler() throws Exception {
        this.doTestVersioningExceptionFileChild(false, true);
    }

    public void testVersioningExceptionFileChildWorkspace() throws Exception {
        this.doTestVersioningExceptionFileChild(true, false);
    }

    public void testVersioningExceptionFileChildSession() throws Exception {
        this.doTestVersioningExceptionFileChild(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTestLockException(boolean useWorkspace, boolean useHandler) throws Exception {
        this.exportRepository(true, false);
        if (!this.isSupported("option.locking.supported")) {
            this.log.println("Locking not supported.");
            return;
        }
        Node lNode = this.testRootNode.addNode(this.nodeName1);
        lNode.addMixin(this.mixLockable);
        this.testRootNode.save();
        Lock lock = lNode.lock(true, true);
        this.session.removeLockToken(lock.getLockToken());
        FileInputStream in = new FileInputStream(this.file);
        try {
            try {
                this.doImport(lNode.getPath(), in, useWorkspace, useHandler);
            }
            catch (LockException e) {
                Object var8_7 = null;
                in.close();
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public void testLockExceptionWorkspaceWithHandler() throws Exception {
        this.doTestVersioningExceptionFileChild(true, true);
    }

    public void testLockExceptionSessionWithHandler() throws Exception {
        this.doTestVersioningExceptionFileChild(false, true);
    }

    public void testLockExceptionWorkspace() throws Exception {
        this.doTestVersioningExceptionFileChild(true, false);
    }

    public void testLockExceptionSession() throws Exception {
        this.doTestVersioningExceptionFileChild(false, false);
    }

    public void testInvalidXmlThrowsSaxException() throws IOException, ParserConfigurationException {
        StringReader in = new StringReader("<this is not a <valid> <xml> file/>");
        ContentHandler ih = null;
        try {
            ih = this.session.getImportContentHandler(this.treeComparator.targetFolder, 0);
        }
        catch (RepositoryException e) {
            SerializationTest.fail((String)("ImportHandler not created: " + (Object)((Object)e)));
        }
        this.helpTestSaxException(ih, in, "session");
        in = new StringReader("<this is not a <valid> <xml> file/>");
        try {
            ih = this.workspace.getImportContentHandler(this.treeComparator.targetFolder, 0);
        }
        catch (RepositoryException e) {
            SerializationTest.fail((String)("ImportHandler not created: " + (Object)((Object)e)));
        }
        this.helpTestSaxException(ih, in, "workspace");
    }

    private void helpTestSaxException(ContentHandler ih, Reader in, String mode) throws IOException {
        try {
            this.createXMLReader(ih).parse(new InputSource(in));
            SerializationTest.fail((String)("Parsing an invalid XML file with via " + mode + " ContentHandler did not throw a SAXException."));
        }
        catch (SAXException e) {
            // empty catch block
        }
    }

    public void testInvalidXmlThrowsInvalidSerializedDataException() throws RepositoryException, IOException {
        String data = "<this is not a <valid> <xml> file/>";
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes());
        try {
            this.session.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
            SerializationTest.fail((String)"Importing a invalid XML file should throw a InvalidSerializedDataException.");
        }
        catch (InvalidSerializedDataException e) {
            // empty catch block
        }
        in = new ByteArrayInputStream(data.getBytes());
        try {
            this.workspace.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
            SerializationTest.fail((String)"Importing a invalid XML file should throw a InvalidSerializedDataException.");
        }
        catch (InvalidSerializedDataException invalidSerializedDataException) {
            // empty catch block
        }
    }

    public void testWorkspaceGetImportContentHandlerExceptions() throws RepositoryException {
        try {
            this.workspace.getImportContentHandler(this.treeComparator.targetFolder + "/thisIsNotAnExistingNode", 0);
            SerializationTest.fail((String)"Specifying a non-existing path must throw a PathNotFoudException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testSessionGetImportContentHandlerExceptions() throws RepositoryException {
        try {
            this.session.getImportContentHandler(this.treeComparator.targetFolder + "/thisIsNotAnExistingNode", 0);
            SerializationTest.fail((String)"Specifying a non-existing path must throw a PathNotFoudException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSessionImportXmlExceptions() throws RepositoryException, IOException {
        this.exportRepository(true, false);
        FileInputStream in = new FileInputStream(this.file);
        try {
            try {
                this.session.importXML(this.treeComparator.targetFolder + "/thisNodeDoesNotExist", (InputStream)in, 0);
                SerializationTest.fail((String)"Importing to a non-existing node does not throw a PathNotFoundException.");
            }
            catch (PathNotFoundException pathNotFoundException) {
                Object var4_3 = null;
                in.close();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testWorkspaceImportXmlExceptions() throws RepositoryException, IOException {
        this.exportRepository(true, false);
        FileInputStream in = new FileInputStream(this.file);
        try {
            try {
                this.workspace.importXML(this.treeComparator.targetFolder + "/thisNodeDoesNotExist", (InputStream)in, 0);
                SerializationTest.fail((String)"Importing to a non-existing node does not throw a PathNotFoundException.");
            }
            catch (PathNotFoundException pathNotFoundException) {
                Object var4_3 = null;
                in.close();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestOverwriteException(boolean useWorkspace, boolean useHandler) throws Exception {
        Node folder = this.testRootNode.addNode("myFolder", this.treeComparator.sc.sameNameSibsFalseChildNodeDefinition);
        Node subfolder = folder.addNode("subfolder");
        this.session.save();
        FileOutputStream out = new FileOutputStream(this.file);
        try {
            this.session.exportSystemView(subfolder.getPath(), (OutputStream)out, true, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            out.close();
            throw throwable;
        }
        out.close();
        FileInputStream in = new FileInputStream(this.file);
        try {
            if (useHandler) {
                try {
                    this.doImport(folder.getPath(), in, useWorkspace, useHandler);
                    SerializationTest.fail((String)"Overwriting an existing node during import must throw a SAXException");
                }
                catch (SAXException e) {}
            } else {
                try {
                    this.doImport(folder.getPath(), in, useWorkspace, useHandler);
                    SerializationTest.fail((String)"Overwriting an existing node during import must throw an ItemExistsException");
                }
                catch (ItemExistsException e) {
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public void testOverwriteExceptionWorkspaceWithHandler() throws Exception {
        this.doTestOverwriteException(true, true);
    }

    public void testOverwriteExceptionSessionWithHandler() throws Exception {
        this.doTestOverwriteException(false, true);
    }

    public void testOverwriteExceptionWorkspace() throws Exception {
        this.doTestOverwriteException(true, false);
    }

    public void testOverwriteExceptionSession() throws Exception {
        this.doTestOverwriteException(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestNodeTypeConstraintViolation(boolean useWorkspace, boolean useHandler) throws Exception {
        this.treeComparator.createExampleTree();
        Node node = this.testRootNode.addNode("ntBase", this.ntBase);
        this.session.save();
        FileInputStream in = new FileInputStream(this.file);
        try {
            if (useHandler) {
                try {
                    this.doImport(node.getPath(), in, useWorkspace, useHandler);
                    SerializationTest.fail((String)"Node type constraint violation should throw a SAXException during xml import using a Contenthandler.");
                }
                catch (SAXException se) {}
            } else {
                try {
                    this.doImport(node.getPath(), in, useWorkspace, useHandler);
                    SerializationTest.fail((String)"Node type constraint violation should throw a   InvalidSerializedDataException during xml import using a Contenthandler.");
                }
                catch (InvalidSerializedDataException isde) {
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    public void testNodeTypeConstraintViolationWorkspaceWithHandler() throws Exception {
        this.doTestNodeTypeConstraintViolation(true, true);
    }

    public void testNodeTypeConstraintViolationSessionWithHandler() throws Exception {
        this.doTestNodeTypeConstraintViolation(false, true);
    }

    public void testNodeTypeConstraintViolationWorkspace() throws Exception {
        this.doTestNodeTypeConstraintViolation(true, false);
    }

    public void testNodeTypeConstraintViolationSession() throws Exception {
        this.doTestNodeTypeConstraintViolation(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionImportXml() throws RepositoryException, IOException {
        FileInputStream in = new FileInputStream(this.file);
        try {
            this.exportRepository(false, false);
            this.session.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            in.close();
            throw throwable;
        }
        in.close();
        this.session.logout();
        this.superuser = null;
        this.session = helper.getReadWriteSession();
        this.treeComparator.setSession(this.session);
        this.treeComparator.compare(this.treeComparator.CHECK_EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSessionGetContentHandler() throws Exception {
        FileInputStream in = new FileInputStream(this.file);
        try {
            this.exportRepository(false, false);
            this.doImportNoSave(this.treeComparator.targetFolder, in, true);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            in.close();
            throw throwable;
        }
        in.close();
        this.session.logout();
        this.superuser = null;
        this.session = helper.getReadWriteSession();
        this.treeComparator.setSession(this.session);
        this.treeComparator.compare(this.treeComparator.CHECK_EMPTY);
    }

    public void doImport(String absPath, FileInputStream in, boolean useWorkspace, boolean useHandler) throws Exception {
        if (useHandler) {
            if (useWorkspace) {
                ContentHandler ih = this.workspace.getImportContentHandler(absPath, 0);
                this.createXMLReader(ih).parse(new InputSource(in));
            } else {
                ContentHandler ih = this.session.getImportContentHandler(absPath, 0);
                this.createXMLReader(ih).parse(new InputSource(in));
                this.session.save();
            }
        } else if (useWorkspace) {
            this.workspace.importXML(absPath, (InputStream)in, 0);
        } else {
            this.session.importXML(absPath, (InputStream)in, 0);
            this.session.save();
        }
    }

    public void doImportNoSave(String absPath, FileInputStream in, boolean useHandler) throws Exception {
        if (useHandler) {
            ContentHandler ih = this.session.getImportContentHandler(absPath, 0);
            this.createXMLReader(ih).parse(new InputSource(in));
        } else {
            this.session.importXML(absPath, (InputStream)in, 0);
        }
    }

    public void testExportSysView_stream_workspace_skipBinary_noRecurse() throws Exception {
        this.doTest(false, true, true, true);
    }

    public void testExportSysView_stream_workspace_skipBinary_recurse() throws Exception {
        this.doTest(false, true, true, false);
    }

    public void testExportSysView_stream_workspace_saveBinary_noRecurse() throws Exception {
        this.doTest(false, true, false, true);
    }

    public void testExportSysView_stream_workspace_saveBinary_recurse() throws Exception {
        this.doTest(false, true, false, false);
    }

    public void testExportSysView_stream_session_skipBinary_noRecurse() throws Exception {
        this.doTest(false, false, true, true);
    }

    public void testExportSysView_stream_session_skipBinary_recurse() throws Exception {
        this.doTest(false, false, true, false);
    }

    public void testExportSysView_stream_session_saveBinary_noRecurse() throws Exception {
        this.doTest(false, false, false, true);
    }

    public void testExportSysView_stream_session_saveBinary_recurse() throws Exception {
        this.doTest(false, false, false, false);
    }

    public void testExportSysView_handler_workspace_skipBinary_noRecurse() throws Exception {
        this.doTest(true, true, true, true);
    }

    public void testExportSysView_handler_workspace_skipBinary_recurse() throws Exception {
        this.doTest(true, true, true, false);
    }

    public void testExportSysView_handler_workspace_saveBinary_noRecurse() throws Exception {
        this.doTest(true, true, false, true);
    }

    public void testExportSysView_handler_workspace_saveBinary_recurse() throws Exception {
        this.doTest(true, true, false, false);
    }

    public void testExportSysView_handler_session_skipBinary_noRecurse() throws Exception {
        this.doTest(true, false, true, true);
    }

    public void testExportSysView_handler_session_skipBinary_recurse() throws Exception {
        this.doTest(true, false, true, false);
    }

    public void testExportSysView_handler_session_saveBinary_noRecurse() throws Exception {
        this.doTest(true, false, false, true);
    }

    public void testExportSysView_handler_session_saveBinary_recurse() throws Exception {
        this.doTest(true, false, false, false);
    }

    private void doTest(boolean handler, boolean workspace, boolean skipBinary, boolean noRecurse) throws Exception {
        this.exportRepository(skipBinary, noRecurse);
        this.importRepository(handler, workspace);
        this.treeComparator.showTree();
        this.treeComparator.compare(skipBinary, noRecurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportRepository(boolean skipBinary, boolean noRecurse) throws IOException {
        FileOutputStream out = new FileOutputStream(this.file);
        try {
            try {
                this.session.refresh(false);
                this.session.exportSystemView(this.treeComparator.getSourceRootPath(), (OutputStream)out, skipBinary, noRecurse);
            }
            catch (RepositoryException e) {
                SerializationTest.fail((String)("Could not export the repository: " + (Object)((Object)e)));
                Object var6_5 = null;
                out.close();
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importRepository(boolean useHandler, boolean workspace) throws Exception {
        FileInputStream in = new FileInputStream(this.file);
        try {
            try {
                if (useHandler) {
                    if (workspace) {
                        ContentHandler ih = this.workspace.getImportContentHandler(this.treeComparator.targetFolder, 0);
                        this.createXMLReader(ih).parse(new InputSource(in));
                    }
                    ContentHandler ih = this.session.getImportContentHandler(this.treeComparator.targetFolder, 0);
                    this.createXMLReader(ih).parse(new InputSource(in));
                    this.session.save();
                }
                if (workspace) {
                    this.workspace.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
                }
                this.session.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
                this.session.save();
            }
            catch (SAXException e) {
                SerializationTest.fail((String)("Error while parsing the imported repository: " + e));
                Object var6_8 = null;
                in.close();
                return;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    private XMLReader createXMLReader(ContentHandler handler) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        reader.setContentHandler(handler);
        reader.setErrorHandler(new DefaultHandler());
        return reader;
    }
}

