/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SessionUUIDTest
extends AbstractJCRTest {
    public void testSaveReferentialIntegrityException() throws RepositoryException, NotExecutableException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node referencingNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node refTargetNode = defaultRootNode.addNode(this.nodeName2, this.getProperty("nodetype2"));
        defaultRootNode.save();
        if (!refTargetNode.isNodeType(this.mixReferenceable)) {
            throw new NotExecutableException("Cannot test referential integrity. Node is not referenceable.");
        }
        this.ensureCanSetProperty(referencingNode, this.propertyName1, referencingNode.getSession().getValueFactory().createValue(refTargetNode));
        referencingNode.setProperty(this.propertyName1, refTargetNode);
        this.superuser.save();
        refTargetNode.remove();
        try {
            this.superuser.save();
            SessionUUIDTest.fail((String)"Saving a deleted node using Session.save() that is a reference target should throw ReferentialIntegrityException");
        }
        catch (ReferentialIntegrityException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveMovedRefNode() throws RepositoryException, NotExecutableException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node newParentNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node refTargetNode = defaultRootNode.addNode(this.nodeName2, this.getProperty("nodetype2"));
        this.superuser.save();
        if (!refTargetNode.isNodeType(this.mixReferenceable)) {
            throw new NotExecutableException("Cannot test referential integrity. Node is not referenceable.");
        }
        Session testSession = helper.getReadWriteSession();
        try {
            Node refTargetNodeSession2 = (Node)testSession.getItem(refTargetNode.getPath());
            this.superuser.move(refTargetNode.getPath(), newParentNode.getPath() + "/" + this.nodeName2);
            this.superuser.save();
            try {
                refTargetNodeSession2.setProperty(this.propertyName1, "test");
                testSession.save();
            }
            catch (InvalidItemStateException e) {
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            testSession.logout();
            throw throwable;
        }
        testSession.logout();
    }
}

