/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceSameNameSibsTest;

public class WorkspaceCopySameNameSibsTest
extends AbstractWorkspaceSameNameSibsTest {
    protected String getOtherWorkspaceName() throws NotExecutableException {
        return this.workspace.getName();
    }

    protected void initNodesW2() throws RepositoryException {
    }

    public void testCopyNodesOrderingSupportedByParent() throws RepositoryException {
        String[] orderList = new String[]{this.nodeName1, this.nodeName2, this.nodeName3};
        for (int i = 0; i < orderList.length; ++i) {
            this.workspace.copy(this.node1.getPath(), this.node2.getPath() + "/" + orderList[i]);
        }
        int cnt = 0;
        NodeIterator iter = this.node2.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            WorkspaceCopySameNameSibsTest.assertTrue((boolean)n.getName().equals(orderList[cnt]));
            ++cnt;
        }
    }

    public void testCopyNodesNodeExistsAtDestPath() throws RepositoryException {
        Node snsfNode = this.testRootNode.addNode(this.nodeName3, this.sameNameSibsFalseNodeType.getName());
        this.testRootNode.save();
        String dstAbsPath = snsfNode.getPath() + "/" + this.node1.getName();
        this.workspace.copy(this.node1.getPath(), dstAbsPath);
        try {
            this.workspace.copy(this.node1.getPath(), dstAbsPath);
            WorkspaceCopySameNameSibsTest.fail((String)("Node exists below '" + dstAbsPath + "'. Test should fail."));
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }
}

