/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanSetPropertyTest
extends AbstractJCRTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testReturnFalseBecauseIsProtected() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, -1, false, true, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No protected property def found.");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value value = NodeTypeUtil.getValueOfType(this.superuser, propDef.getRequiredType());
        CanSetPropertyTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is protected.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testReturnFalseBecauseIsMultiple() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, -1, true, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No multiple, not protected property def found.");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        Value value = NodeTypeUtil.getValueOfType(this.superuser, propDef.getRequiredType());
        CanSetPropertyTest.assertFalse((String)"canSetProperty(String propertyName, Value value) must return false if the property is multiple.", (boolean)nodeType.canSetProperty(propDef.getName(), value));
    }

    public void testValueNull() throws NotExecutableException, RepositoryException {
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.session, -1, false, false, false, false);
        if (propDef == null) {
            throw new NotExecutableException("No not protected property def found.");
        }
        NodeType nodeType = propDef.getDeclaringNodeType();
        CanSetPropertyTest.assertEquals((String)"nodeType.canSetProperty(String propertyName, Value value) where value is null must return the same result as nodeType.canRemoveItem(String propertyName).", (boolean)nodeType.canRemoveItem(propDef.getName()), (boolean)nodeType.canSetProperty(propDef.getName(), (Value)null));
    }
}

