/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class GetPropertyNamesTest
extends AbstractQueryTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testGetPropertyNames() throws RepositoryException {
        String queryStatement = "/" + this.jcrRoot;
        Query query = this.superuser.getWorkspace().getQueryManager().createQuery(queryStatement, "xpath");
        QueryResult result = query.execute();
        PropertyDefinition[] pd = this.superuser.getWorkspace().getNodeTypeManager().getNodeType(this.ntBase).getDeclaredPropertyDefinitions();
        ArrayList<String> singleValPropNames = new ArrayList<String>();
        for (int i = 0; i < pd.length; ++i) {
            if (pd[i].isMultiple()) continue;
            singleValPropNames.add(pd[i].getName());
        }
        singleValPropNames.add(this.jcrPath);
        singleValPropNames.add(this.jcrScore);
        Object[] foundPropertyNames = result.getColumnNames();
        Object[] realPropertyNames = singleValPropNames.toArray();
        Arrays.sort(foundPropertyNames);
        Arrays.sort(realPropertyNames);
        GetPropertyNamesTest.assertTrue((String)"Property names don't match", (boolean)Arrays.equals(foundPropertyNames, realPropertyNames));
    }
}

