/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class PredicatesTest
extends AbstractQueryTest {
    private String nodeTypeName;
    private Session session;
    private QueryManager qm;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
        this.nodeTypeName = this.session.getRootNode().getPrimaryNodeType().getName();
        this.qm = this.session.getWorkspace().getQueryManager();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.qm = null;
        super.tearDown();
    }

    public void testEquality() throws RepositoryException {
        String stmt = "/" + this.jcrRoot + "/" + this.testPath + "/*[@" + this.jcrPrimaryType + "='" + this.nodeTypeName + "']";
        try {
            this.qm.createQuery(stmt, "xpath");
        }
        catch (InvalidQueryException e) {
            PredicatesTest.fail((String)("invalid statement syntax for '" + stmt + "'"));
        }
    }

    public void testCombinedOr() throws RepositoryException {
        String stmt = "/" + this.jcrRoot + "/" + this.testPath + "/*[@" + this.jcrPrimaryType + "='" + this.nodeTypeName + "' or @" + this.jcrPrimaryType + "='" + this.ntBase + "']";
        try {
            this.qm.createQuery(stmt, "xpath");
        }
        catch (InvalidQueryException e) {
            PredicatesTest.fail((String)("invalid statement syntax for '" + stmt + "'"));
        }
    }

    public void testOr() throws RepositoryException {
        String stmt = "/" + this.jcrRoot + "/" + this.testPath + "/*[@" + this.jcrPrimaryType + " or @" + this.jcrMixinTypes + "]";
        try {
            this.qm.createQuery(stmt, "xpath");
        }
        catch (InvalidQueryException e) {
            PredicatesTest.fail((String)("invalid statement syntax for '" + stmt + "'"));
        }
    }

    public void testAnd() throws RepositoryException {
        String stmt = "/" + this.jcrRoot + "/" + this.testPath + "/*[@" + this.jcrPrimaryType + " and @" + this.jcrMixinTypes + "]";
        try {
            this.qm.createQuery(stmt, "xpath");
        }
        catch (InvalidQueryException e) {
            PredicatesTest.fail((String)("invalid statement syntax for '" + stmt + "'"));
        }
    }

    public void testCombinedAnd() throws RepositoryException {
        String stmt = "/" + this.jcrRoot + "/" + this.testPath + "/*[@" + this.jcrPrimaryType + "='" + this.nodeTypeName + "' and @" + this.jcrPrimaryType + "='" + this.ntBase + "']";
        try {
            this.qm.createQuery(stmt, "xpath");
        }
        catch (InvalidQueryException e) {
            PredicatesTest.fail((String)("invalid statement syntax for '" + stmt + "'"));
        }
    }
}

