/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import java.util.Arrays;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class CheckinTest
extends AbstractVersionTest {
    protected void setUp() throws Exception {
        super.setUp();
        this.versionableNode.checkout();
    }

    public void testIsCheckedOut() throws RepositoryException {
        this.versionableNode.checkin();
        CheckinTest.assertTrue((String)"After calling Node.checkin() on a versionable node N, N.isCheckedOut() must return false", (!this.versionableNode.isCheckedOut() ? 1 : 0) != 0);
    }

    public void testCheckinRemovesPredecessorProperty() throws RepositoryException {
        this.versionableNode.checkin();
        Value[] predecessorsValue = this.versionableNode.getProperty(this.jcrPredecessors).getValues();
        CheckinTest.assertTrue((String)"Checkin must set the node's jcr:predecessors property to the empty array", (predecessorsValue.length == 0 ? 1 : 0) != 0);
    }

    public void testPredecessorIsCopiedToNewVersion() throws RepositoryException {
        Value[] nPredecessorsValue = this.versionableNode.getProperty(this.jcrPredecessors).getValues();
        Version v = this.versionableNode.checkin();
        Value[] vPredecessorsValue = v.getProperty(this.jcrPredecessors).getValues();
        CheckinTest.assertEquals((String)"The versionable checked-out node's jcr:predecessors property is copied to the new version on checkin.", Arrays.asList(nPredecessorsValue), Arrays.asList(vPredecessorsValue));
    }

    public void testMultipleCheckinHasNoEffect() throws RepositoryException {
        Version v = this.versionableNode.checkin();
        try {
            Version v2 = this.versionableNode.checkin();
            CheckinTest.assertTrue((String)"Calling checkin() on a node that is already checked-in must not have an effect.", (boolean)v.isSame((Item)v2));
        }
        catch (RepositoryException e) {
            CheckinTest.fail((String)"Calling checkin() on a node that is already checked-in must not throw an exception.");
        }
    }

    public void testBaseVersionAfterCheckin() throws RepositoryException {
        Version v = this.versionableNode.checkin();
        Value baseVersionRef = this.versionableNode.getProperty(this.jcrBaseVersion).getValue();
        CheckinTest.assertEquals((String)"Checked-in node's jcr:baseVersion property is set to refer to the version created on checkin.", (Object)this.superuser.getValueFactory().createValue((Node)v), (Object)baseVersionRef);
    }

    public void testCheckinWithPendingChanges() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            this.versionableNode.checkin();
            CheckinTest.fail((String)"InvalidItemStateException must be thrown on attempt to checkin a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testIsNotCheckedOut() throws RepositoryException {
        this.versionableNode.checkin();
        boolean isCheckedOut = this.versionableNode.isCheckedOut();
        CheckinTest.assertFalse((String)"Node.isCheckedOut() must return false after Node.checkin().", (boolean)isCheckedOut);
    }

    public void testCheckinCreatesNewVersion() throws RepositoryException {
        long initialNumberOfVersions = this.getNumberOfVersions(this.versionableNode.getVersionHistory());
        this.versionableNode.checkin();
        long numberOfVersions = this.getNumberOfVersions(this.versionableNode.getVersionHistory());
        CheckinTest.assertTrue((String)"Checkin must create a new Version in the VersionHistory.", (numberOfVersions == initialNumberOfVersions + 1L ? 1 : 0) != 0);
    }

    public void testCheckinNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.checkin();
            CheckinTest.fail((String)"Node.checkin() on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }
}

