/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class BinaryPropertyTest
extends AbstractPropertyTest {
    protected int getPropertyType() {
        return 2;
    }

    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSameStream() throws RepositoryException, IOException {
        Value val = PropertyUtil.getValue(this.prop);
        InputStream in = val.getStream();
        InputStream in2 = val.getStream();
        Value otherVal = PropertyUtil.getValue(this.prop);
        InputStream in3 = otherVal.getStream();
        try {
            BinaryPropertyTest.assertSame((String)"Same InputStream object expected when Value.getStream is called twice.", (Object)in, (Object)in2);
            BinaryPropertyTest.assertNotSame((String)"Value.getStream() called on a new value object should return a different Stream object.", (Object)in, (Object)in3);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
            if (in2 != in) {
                try {
                    in2.close();
                }
                catch (IOException ignore) {}
            }
            if (in3 != in) {
                try {
                    in3.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSameStreamJcr2() throws RepositoryException, IOException {
        Value val = PropertyUtil.getValue(this.prop);
        Binary bin = val.getBinary();
        try {
            InputStream in = bin.getStream();
            InputStream in2 = bin.getStream();
            try {
                int n;
                BinaryPropertyTest.assertNotSame((String)"Value.getStream() called on a new value object should return a different Stream object.", (Object)in, (Object)in2);
                while ((n = in.read()) != -1) {
                    int n2 = in2.read();
                    BinaryPropertyTest.assertEquals((String)"streams from the same binary object should have identical content", (int)n, (int)n2);
                }
                BinaryPropertyTest.assertEquals((String)"streams from the same binary object should have identical content", (int)-1, (int)in2.read());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
                if (in2 != in) {
                    try {
                        in2.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        finally {
            bin.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiValue() throws RepositoryException, IOException {
        if (this.multiple) {
            InputStream in = null;
            try {
                in = this.prop.getStream();
                BinaryPropertyTest.fail((String)"Calling getStream() on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public void testMultiValueJcr2() throws RepositoryException, IOException {
        if (this.multiple) {
            try {
                this.prop.getBinary();
                BinaryPropertyTest.fail((String)"Calling getStream() on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValue() throws IOException, RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        InputStream in = val.getStream();
        InputStream in2 = this.prop.getDefinition().isMultiple() ? this.prop.getValues()[0].getStream() : this.prop.getStream();
        try {
            int b = in.read();
            while (b != -1) {
                int b2 = in2.read();
                BinaryPropertyTest.assertEquals((String)"Value.getStream() and Property.getStream() return different values.", (int)b, (int)b2);
                b = in.read();
            }
            BinaryPropertyTest.assertEquals((String)"Value.getStream() and Property.getStream() return different values.", (int)-1, (int)in2.read());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
            try {
                in2.close();
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValueJcr2() throws IOException, RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        InputStream in = val.getStream();
        Binary bin = val.getBinary();
        try {
            InputStream in2 = bin.getStream();
            try {
                int b = in.read();
                while (b != -1) {
                    int b2 = in2.read();
                    BinaryPropertyTest.assertEquals((String)"Value.getStream() and Value.getBinary().getStream() return different values.", (int)b, (int)b2);
                    b = in.read();
                }
                BinaryPropertyTest.assertEquals((String)"Value.getStream() and Value.getBinary().getStream() return different values.", (int)-1, (int)in2.read());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
                try {
                    in2.close();
                }
                catch (IOException ignore) {}
            }
        }
        finally {
            bin.dispose();
        }
    }

    public void testGetBoolean() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        boolean bool = val.getBoolean();
        BinaryPropertyTest.assertEquals((String)"Wrong conversion from Binary to Boolean.", (Object)new Boolean(bool), (Object)Boolean.valueOf(str));
    }

    public void testGetDate() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        if (PropertyUtil.isDateFormat(val.getString())) {
            val.getDate();
        } else {
            try {
                val.getDate();
                BinaryPropertyTest.fail((String)"Conversion from a malformed String to a Date should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetDouble() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        try {
            Double.parseDouble(str);
            double d = val.getDouble();
            BinaryPropertyTest.assertEquals((String)"Wrong conversion from Binary to Double", (Object)new Double(d), (Object)Double.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            try {
                val.getDouble();
                BinaryPropertyTest.fail((String)"Conversion from malformed Binary to Double should throw ValueFormatException.");
            }
            catch (ValueFormatException vfe) {
                // empty catch block
            }
        }
    }

    public void testGetLong() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        try {
            Long.parseLong(str);
            long l = val.getLong();
            BinaryPropertyTest.assertEquals((String)"Wrong conversion from Binary to Long", (Object)new Long(l), (Object)Long.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            try {
                val.getLong();
                BinaryPropertyTest.fail((String)"Conversion from malformed Binary to Long should throw ValueFormatException.");
            }
            catch (ValueFormatException vfe) {
                // empty catch block
            }
        }
    }

    public void testGetType() throws RepositoryException {
        BinaryPropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 2));
    }

    public void testGetNode() throws RepositoryException, NotExecutableException {
        if (this.multiple) {
            try {
                this.prop.getNode();
                BinaryPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetProperty() throws RepositoryException, NotExecutableException {
        if (this.multiple) {
            try {
                this.prop.getProperty();
                BinaryPropertyTest.fail((String)"Property.getProperty() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetLength() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getLength();
                BinaryPropertyTest.fail((String)"Property.getLength() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException vfe) {}
        } else {
            long bytes;
            long length = this.prop.getLength();
            if (length > -1L && (bytes = PropertyUtil.countBytes(this.prop.getValue())) != -1L) {
                BinaryPropertyTest.assertEquals((String)"Property.getLength() returns wrong number of bytes.", (long)bytes, (long)length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLengthJcr2() throws RepositoryException {
        long length;
        Value val = PropertyUtil.getValue(this.prop);
        Binary binary = val.getBinary();
        try {
            length = binary.getSize();
        }
        finally {
            binary.dispose();
        }
        long bytes = PropertyUtil.countBytes(this.prop.getValue());
        if (bytes != -1L) {
            BinaryPropertyTest.assertEquals((String)"Binary.getSize() returns wrong number of bytes.", (long)bytes, (long)length);
        }
    }

    public void testGetLengths() throws RepositoryException {
        if (this.multiple) {
            Value[] values = this.prop.getValues();
            long[] lengths = this.prop.getLengths();
            for (int i = 0; i < lengths.length; ++i) {
                long length = PropertyUtil.countBytes(values[i]);
                BinaryPropertyTest.assertEquals((String)"Property.getLengths() returns wrong array of the lengths of a multivalue property.", (long)length, (long)lengths[i]);
            }
        } else {
            try {
                this.prop.getLengths();
                BinaryPropertyTest.fail((String)"Property.getLengths() called on a sinlge value property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRandomAccess() throws RepositoryException, IOException {
        Value val = PropertyUtil.getValue(this.prop);
        Binary bin = val.getBinary();
        try {
            int cnt;
            byte[] buf = new byte[4096];
            BinaryPropertyTest.assertEquals((String)"reading behind EOF must return -1", (int)-1, (int)bin.read(buf, bin.getSize()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int pos = 0;
            while ((cnt = bin.read(buf, (long)pos)) > 0) {
                out.write(buf, 0, cnt);
                pos += cnt;
            }
            byte[] content = out.toByteArray();
            BinaryPropertyTest.assertEquals((String)"unexpected content length", (long)bin.getSize(), (long)content.length);
            InputStream in = val.getStream();
            try {
                int b;
                int k = 0;
                while ((b = in.read()) != -1) {
                    BinaryPropertyTest.assertEquals((String)"Value.getStream().read() and Value.getBinary().read() return different values.", (byte)((byte)b), (byte)content[k]);
                    ++k;
                }
                BinaryPropertyTest.assertEquals((String)"unexpected content length", (int)k, (int)content.length);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
            buf = new byte[1];
            BinaryPropertyTest.assertTrue((String)"unexpected result of Value.getBinary.read()", (-1 != bin.read(buf, 0L) ? 1 : 0) != 0);
            BinaryPropertyTest.assertEquals((String)"unexpected result of Value.getBinary.read()", (byte)content[0], (byte)buf[0]);
            if (content.length > 0) {
                BinaryPropertyTest.assertTrue((String)"unexpected result of Value.getBinary.read()", (-1 != bin.read(buf, (long)(content.length - 1)) ? 1 : 0) != 0);
                BinaryPropertyTest.assertEquals((String)"unexpected result of Value.getBinary.read()", (byte)content[content.length - 1], (byte)buf[0]);
                BinaryPropertyTest.assertTrue((String)"unexpected result of Value.getBinary.read()", (-1 != bin.read(buf, 0L) ? 1 : 0) != 0);
                BinaryPropertyTest.assertEquals((String)"unexpected result of Value.getBinary.read()", (byte)content[0], (byte)buf[0]);
            }
        }
        finally {
            bin.dispose();
        }
    }
}

