/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class RootNodeTest
extends AbstractJCRTest {
    private Session session;
    private Node rootNode;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.rootNode = this.session.getRootNode();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.rootNode = null;
        super.tearDown();
    }

    public void testGetName() throws RepositoryException {
        RootNodeTest.assertEquals((String)"The name of the root node must be an empty string.", (String)"", (String)this.rootNode.getName());
    }

    public void testGetPath() throws RepositoryException {
        RootNodeTest.assertEquals((String)"The path of the root node must be a single slash.", (String)"/", (String)this.rootNode.getPath());
    }

    public void testGetDepth() throws RepositoryException {
        RootNodeTest.assertEquals((String)"The depth of the root node must be equal to 0.", (int)0, (int)this.rootNode.getDepth());
    }

    public void testGetParent() throws RepositoryException {
        try {
            this.rootNode.getParent();
            RootNodeTest.fail((String)"The root node may not have a parent.");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }
}

