/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.QueryObjectModel;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public abstract class AbstractQOMTest
extends AbstractQueryTest {
    protected void bindVariableValue(Query q, String var, Value value) throws RepositoryException {
        q.bindValue(var, value);
    }

    protected void checkResultOrder(QueryObjectModel qom, String[] selectorNames, Node[][] nodes) throws RepositoryException {
        this.checkResultOrder(qom.execute(), selectorNames, nodes);
        this.checkResultOrder(this.qm.createQuery(qom.getStatement(), "JCR-SQL2").execute(), selectorNames, nodes);
    }

    protected void checkResultOrder(QueryResult result, String[] selectorNames, Node[][] nodes) throws RepositoryException {
        ArrayList<String> expectedPaths = new ArrayList<String>();
        this.log.println("expected:");
        for (int i = 0; i < nodes.length; ++i) {
            StringBuffer aggregatedPaths = new StringBuffer();
            for (int j = 0; j < nodes[i].length; ++j) {
                aggregatedPaths.append(AbstractQOMTest.getPath(nodes[i][j]));
                aggregatedPaths.append("|");
            }
            expectedPaths.add(aggregatedPaths.toString());
            this.log.println(aggregatedPaths.toString());
        }
        ArrayList<String> resultPaths = new ArrayList<String>();
        this.log.println("result:");
        RowIterator it = result.getRows();
        while (it.hasNext()) {
            Row r = it.nextRow();
            StringBuffer aggregatedPaths = new StringBuffer();
            for (int i = 0; i < selectorNames.length; ++i) {
                aggregatedPaths.append(AbstractQOMTest.getPath(r.getNode(selectorNames[i])));
                aggregatedPaths.append("|");
            }
            resultPaths.add(aggregatedPaths.toString());
            this.log.println(aggregatedPaths.toString());
        }
        AbstractQOMTest.assertEquals((String)"wrong result order", expectedPaths, resultPaths);
    }

    protected void checkQOM(QueryObjectModel qom, Node[] nodes) throws RepositoryException {
        this.checkResult(qom.execute(), nodes);
        this.checkResult(this.qm.createQuery(qom.getStatement(), "JCR-SQL2").execute(), nodes);
    }

    protected void checkQOM(QueryObjectModel qom, String[] selectorNames, Node[][] nodes) throws RepositoryException {
        this.checkResult(qom.execute(), selectorNames, nodes);
        this.checkResult(this.qm.createQuery(qom.getStatement(), "JCR-SQL2").execute(), selectorNames, nodes);
    }

    protected void checkResult(QueryResult result, String[] selectorNames, Node[][] nodes) throws RepositoryException {
        HashSet<String> expectedPaths = new HashSet<String>();
        this.log.println("expected:");
        for (int i = 0; i < nodes.length; ++i) {
            StringBuffer aggregatedPaths = new StringBuffer();
            for (int j = 0; j < nodes[i].length; ++j) {
                aggregatedPaths.append(AbstractQOMTest.getPath(nodes[i][j]));
                aggregatedPaths.append("|");
            }
            expectedPaths.add(aggregatedPaths.toString());
            this.log.println(aggregatedPaths.toString());
        }
        HashSet<String> resultPaths = new HashSet<String>();
        this.log.println("result:");
        Object it = result.getRows();
        while (it.hasNext()) {
            Row r = it.nextRow();
            StringBuffer aggregatedPaths = new StringBuffer();
            for (int i = 0; i < selectorNames.length; ++i) {
                aggregatedPaths.append(AbstractQOMTest.getPath(r.getNode(selectorNames[i])));
                aggregatedPaths.append("|");
            }
            resultPaths.add(aggregatedPaths.toString());
            this.log.println(aggregatedPaths.toString());
        }
        it = expectedPaths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            AbstractQOMTest.assertTrue((String)(path + " is not part of the result set"), (boolean)resultPaths.contains(path));
        }
        it = resultPaths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            AbstractQOMTest.assertTrue((String)(path + " is not expected to be part of the result set"), (boolean)expectedPaths.contains(path));
        }
    }

    protected static String getPath(Node node) throws RepositoryException {
        if (node != null) {
            return node.getPath();
        }
        return "";
    }

    protected void forQOMandSQL2(QueryObjectModel qom, Callable callable) throws RepositoryException {
        ArrayList<Object> queries = new ArrayList<Object>();
        queries.add(qom);
        queries.add(this.qm.createQuery(qom.getStatement(), "JCR-SQL2"));
        Iterator it = queries.iterator();
        while (it.hasNext()) {
            callable.call((Query)it.next());
        }
    }

    protected static interface Callable {
        public Object call(Query var1) throws RepositoryException;
    }
}

