/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.ChildNodeJoinCondition;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.FullTextSearchScore;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.SameNodeJoinCondition;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class QueryObjectModelFactoryTest
extends AbstractQOMTest {
    private static final String SELECTOR_NAME1 = "selector1";
    private static final String SELECTOR_NAME2 = "selector2";
    private static final String COLUMN_NAME = "column";
    private static final String VARIABLE_NAME = "varName";
    private static final String FULLTEXT_SEARCH_EXPR = "foo -bar";
    private static final Set OPERATORS = new HashSet();
    private static final Set JOIN_TYPES = new HashSet();

    public void testAnd() throws RepositoryException {
        PropertyExistence c1 = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        PropertyExistence c2 = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName2);
        And and = this.qf.and((Constraint)c1, (Constraint)c2);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a PropertyExistence constraint", (boolean)(and.getConstraint1() instanceof PropertyExistence));
        QueryObjectModelFactoryTest.assertTrue((String)"Not a PropertyExistence constraint", (boolean)(and.getConstraint2() instanceof PropertyExistence));
    }

    public void testOrderingAscending() throws RepositoryException {
        PropertyValue op = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        Ordering asc = this.qf.ascending((DynamicOperand)op);
        QueryObjectModelFactoryTest.assertEquals((String)"Ordering.getOrder() must return QueryObjectModelConstants.ORDER_ASCENDING", (String)"jcr.order.ascending", (String)asc.getOrder());
        QueryObjectModelFactoryTest.assertTrue((String)"Not a PropertyValue operand", (boolean)(asc.getOperand() instanceof PropertyValue));
    }

    public void testBindVariableValue() throws RepositoryException {
        BindVariableValue bindVar = this.qf.bindVariable(this.propertyName1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong variable name", (String)this.propertyName1, (String)bindVar.getBindVariableName());
    }

    public void testChildNode() throws RepositoryException {
        ChildNode childNode = this.qf.childNode(SELECTOR_NAME1, this.testRootNode.getPath());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong path", (String)this.testRootNode.getPath(), (String)childNode.getParentPath());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)childNode.getSelectorName());
    }

    public void testChildNodeWithSelector() throws RepositoryException {
        ChildNode childNode = this.qf.childNode(SELECTOR_NAME1, this.testRootNode.getPath());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong path", (String)this.testRootNode.getPath(), (String)childNode.getParentPath());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)childNode.getSelectorName());
    }

    public void testChildNodeJoinCondition() throws RepositoryException {
        ChildNodeJoinCondition cond = this.qf.childNodeJoinCondition(SELECTOR_NAME1, SELECTOR_NAME2);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)cond.getChildSelectorName(), (String)SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)cond.getParentSelectorName(), (String)SELECTOR_NAME2);
    }

    public void testColumn() throws RepositoryException {
        Column col = this.qf.column(SELECTOR_NAME1, this.propertyName1, this.propertyName1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)col.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName1, (String)col.getPropertyName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong column name", (String)this.propertyName1, (String)col.getColumnName());
    }

    public void testColumnAllProperties() throws RepositoryException {
        Column col = this.qf.column(SELECTOR_NAME1, null, null);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)col.getSelectorName());
        QueryObjectModelFactoryTest.assertNull((String)"Property name must be null", (Object)col.getPropertyName());
        QueryObjectModelFactoryTest.assertNull((String)"Column name must be null", (Object)col.getColumnName());
    }

    public void testColumnWithColumnName() throws RepositoryException {
        Column col = this.qf.column(SELECTOR_NAME1, this.propertyName1, COLUMN_NAME);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)col.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName1, (String)col.getPropertyName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong column name", (String)COLUMN_NAME, (String)col.getColumnName());
    }

    public void testColumnWithSelector() throws RepositoryException {
        Column col = this.qf.column(SELECTOR_NAME1, this.propertyName1, COLUMN_NAME);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)col.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName1, (String)col.getPropertyName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong column name", (String)COLUMN_NAME, (String)col.getColumnName());
    }

    public void testComparison() throws RepositoryException {
        PropertyValue op1 = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        BindVariableValue op2 = this.qf.bindVariable(VARIABLE_NAME);
        Iterator it = OPERATORS.iterator();
        while (it.hasNext()) {
            String operator = (String)it.next();
            Comparison comp = this.qf.comparison((DynamicOperand)op1, operator, (StaticOperand)op2);
            QueryObjectModelFactoryTest.assertTrue((String)"Not a PropertyValue operand", (boolean)(comp.getOperand1() instanceof PropertyValue));
            QueryObjectModelFactoryTest.assertTrue((String)"Not a BindVariableValue operand", (boolean)(comp.getOperand2() instanceof BindVariableValue));
            QueryObjectModelFactoryTest.assertEquals((String)"Wrong operator", (String)operator.toString(), (String)comp.getOperator());
        }
    }

    public void testCreateQuery() throws RepositoryException {
        Selector selector = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        QueryObjectModel qom = this.qf.createQuery((Source)selector, null, null, null);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(qom.getSource() instanceof Selector));
        QueryObjectModelFactoryTest.assertNull((String)"Constraint must be null", (Object)qom.getConstraint());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of orderings", (int)0, (int)qom.getOrderings().length);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of columns", (int)0, (int)qom.getColumns().length);
    }

    public void testCreateQueryWithConstraint() throws RepositoryException {
        Selector selector = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        QueryObjectModel qom = this.qf.createQuery((Source)selector, (Constraint)propExist, null, null);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(qom.getSource() instanceof Selector));
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property existence constraint", (boolean)(qom.getConstraint() instanceof PropertyExistence));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of orderings", (int)0, (int)qom.getOrderings().length);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of columns", (int)0, (int)qom.getColumns().length);
    }

    public void testCreateQueryWithConstraintAndOrdering() throws RepositoryException {
        Selector selector = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        PropertyValue propValue = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        Ordering ordering = this.qf.ascending((DynamicOperand)propValue);
        QueryObjectModel qom = this.qf.createQuery((Source)selector, (Constraint)propExist, new Ordering[]{ordering}, null);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(qom.getSource() instanceof Selector));
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property existence constraint", (boolean)(qom.getConstraint() instanceof PropertyExistence));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of orderings", (int)1, (int)qom.getOrderings().length);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of columns", (int)0, (int)qom.getColumns().length);
    }

    public void testCreateQueryWithConstraintOrderingAndColumn() throws RepositoryException {
        Selector selector = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        PropertyValue propValue = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        Ordering ordering = this.qf.ascending((DynamicOperand)propValue);
        Column column = this.qf.column(SELECTOR_NAME1, this.propertyName1, this.propertyName1);
        QueryObjectModel qom = this.qf.createQuery((Source)selector, (Constraint)propExist, new Ordering[]{ordering}, new Column[]{column});
        QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(qom.getSource() instanceof Selector));
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property existence constraint", (boolean)(qom.getConstraint() instanceof PropertyExistence));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of orderings", (int)1, (int)qom.getOrderings().length);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of columns", (int)1, (int)qom.getColumns().length);
    }

    public void testCreateQueryFromSource() throws RepositoryException {
        Selector selector = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        QueryObjectModel qom = this.qf.createQuery((Source)selector, null, null, null);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(qom.getSource() instanceof Selector));
        QueryObjectModelFactoryTest.assertNull((String)"Constraint must be null", (Object)qom.getConstraint());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of orderings", (int)0, (int)qom.getOrderings().length);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of columns", (int)0, (int)qom.getColumns().length);
    }

    public void testCreateQueryFromSourceWithConstraint() throws RepositoryException {
        Selector selector = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        QueryObjectModel qom = this.qf.createQuery((Source)selector, (Constraint)propExist, null, null);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(qom.getSource() instanceof Selector));
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property existence constraint", (boolean)(qom.getConstraint() instanceof PropertyExistence));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of orderings", (int)0, (int)qom.getOrderings().length);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of columns", (int)0, (int)qom.getColumns().length);
    }

    public void testCreateQueryFromSourceWithConstraintAndOrdering() throws RepositoryException {
        Selector selector = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        PropertyValue propValue = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        Ordering ordering = this.qf.ascending((DynamicOperand)propValue);
        QueryObjectModel qom = this.qf.createQuery((Source)selector, (Constraint)propExist, new Ordering[]{ordering}, null);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(qom.getSource() instanceof Selector));
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property existence constraint", (boolean)(qom.getConstraint() instanceof PropertyExistence));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of orderings", (int)1, (int)qom.getOrderings().length);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of columns", (int)0, (int)qom.getColumns().length);
    }

    public void testCreateQueryFromSourceWithConstraintOrderingAndColumn() throws RepositoryException {
        Selector selector = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        PropertyValue propValue = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        Ordering ordering = this.qf.ascending((DynamicOperand)propValue);
        Column column = this.qf.column(SELECTOR_NAME1, this.propertyName1, this.propertyName1);
        QueryObjectModel qom = this.qf.createQuery((Source)selector, (Constraint)propExist, new Ordering[]{ordering}, new Column[]{column});
        QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(qom.getSource() instanceof Selector));
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property existence constraint", (boolean)(qom.getConstraint() instanceof PropertyExistence));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of orderings", (int)1, (int)qom.getOrderings().length);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong size of columns", (int)1, (int)qom.getColumns().length);
    }

    public void testDescendantNode() throws RepositoryException {
        DescendantNode descNode = this.qf.descendantNode(SELECTOR_NAME1, this.testRootNode.getPath());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector", (String)SELECTOR_NAME1, (String)descNode.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong path", (String)this.testRootNode.getPath(), (String)descNode.getAncestorPath());
    }

    public void testDescendantNodeWithSelector() throws RepositoryException {
        DescendantNode descNode = this.qf.descendantNode(SELECTOR_NAME1, this.testRootNode.getPath());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)descNode.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong path", (String)this.testRootNode.getPath(), (String)descNode.getAncestorPath());
    }

    public void testDescendantNodeJoinCondition() throws RepositoryException {
        DescendantNodeJoinCondition cond = this.qf.descendantNodeJoinCondition(SELECTOR_NAME1, SELECTOR_NAME2);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)cond.getDescendantSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME2, (String)cond.getAncestorSelectorName());
    }

    public void testOrderingDescending() throws RepositoryException {
        PropertyValue op = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        Ordering desc = this.qf.descending((DynamicOperand)op);
        QueryObjectModelFactoryTest.assertEquals((String)"Ordering.getOrder() must return QueryObjectModelConstants.ORDER_DESCENDING", (String)"jcr.order.descending", (String)desc.getOrder());
        QueryObjectModelFactoryTest.assertTrue((String)"Not a PropertyValue operand", (boolean)(desc.getOperand() instanceof PropertyValue));
    }

    public void testEquiJoinCondition() throws RepositoryException {
        EquiJoinCondition cond = this.qf.equiJoinCondition(SELECTOR_NAME1, this.propertyName1, SELECTOR_NAME2, this.propertyName2);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)cond.getSelector1Name());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName1, (String)cond.getProperty1Name());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME2, (String)cond.getSelector2Name());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName2, (String)cond.getProperty2Name());
    }

    public void testFullTextSearch() throws RepositoryException {
        FullTextSearch ftSearch = this.qf.fullTextSearch(SELECTOR_NAME1, this.propertyName1, (StaticOperand)this.qf.literal(this.vf.createValue(FULLTEXT_SEARCH_EXPR)));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)ftSearch.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong propertyName", (String)this.propertyName1, (String)ftSearch.getPropertyName());
        StaticOperand op = ftSearch.getFullTextSearchExpression();
        QueryObjectModelFactoryTest.assertNotNull((Object)op);
        QueryObjectModelFactoryTest.assertTrue((String)"not a Literal", (boolean)(op instanceof Literal));
        Literal literal = (Literal)op;
        QueryObjectModelFactoryTest.assertEquals((String)FULLTEXT_SEARCH_EXPR, (String)literal.getLiteralValue().getString());
    }

    public void testFullTextSearchAllProperties() throws RepositoryException {
        FullTextSearch ftSearch = this.qf.fullTextSearch(SELECTOR_NAME1, null, (StaticOperand)this.qf.literal(this.vf.createValue(FULLTEXT_SEARCH_EXPR)));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)ftSearch.getSelectorName());
        QueryObjectModelFactoryTest.assertNull((String)"Property name must be null", (Object)ftSearch.getPropertyName());
    }

    public void testFullTextSearchWithBindVariableValue() throws RepositoryException {
        FullTextSearch ftSearch = this.qf.fullTextSearch(SELECTOR_NAME1, this.propertyName1, (StaticOperand)this.qf.bindVariable(VARIABLE_NAME));
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)ftSearch.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong propertyName", (String)this.propertyName1, (String)ftSearch.getPropertyName());
        StaticOperand op = ftSearch.getFullTextSearchExpression();
        QueryObjectModelFactoryTest.assertNotNull((Object)op);
        QueryObjectModelFactoryTest.assertTrue((String)"not a BindVariableValue", (boolean)(op instanceof BindVariableValue));
        BindVariableValue value = (BindVariableValue)op;
        QueryObjectModelFactoryTest.assertEquals((String)VARIABLE_NAME, (String)value.getBindVariableName());
    }

    public void testFullTextSearchScore() throws RepositoryException {
        FullTextSearchScore score = this.qf.fullTextSearchScore(SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)score.getSelectorName());
    }

    public void testFullTextSearchScoreWithSelector() throws RepositoryException {
        FullTextSearchScore score = this.qf.fullTextSearchScore(SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)score.getSelectorName());
    }

    public void testJoin() throws RepositoryException {
        Selector s1 = this.qf.selector(this.ntBase, SELECTOR_NAME1);
        Selector s2 = this.qf.selector(this.testNodeType, SELECTOR_NAME1);
        EquiJoinCondition cond = this.qf.equiJoinCondition(this.ntBase, this.jcrPrimaryType, this.testNodeType, this.jcrPrimaryType);
        Iterator it = JOIN_TYPES.iterator();
        while (it.hasNext()) {
            String joinType = (String)it.next();
            Join join = this.qf.join((Source)s1, (Source)s2, joinType, (JoinCondition)cond);
            QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(join.getLeft() instanceof Selector));
            QueryObjectModelFactoryTest.assertTrue((String)"Not a selector source", (boolean)(join.getRight() instanceof Selector));
            QueryObjectModelFactoryTest.assertEquals((String)"Wrong join type", (String)joinType, (String)join.getJoinType());
            QueryObjectModelFactoryTest.assertTrue((String)"Not an EquiJoinCondition", (boolean)(join.getJoinCondition() instanceof EquiJoinCondition));
        }
    }

    public void testLength() throws RepositoryException {
        PropertyValue propValue = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        Length len = this.qf.length(propValue);
        QueryObjectModelFactoryTest.assertNotNull((String)"Property value must not be null", (Object)len.getPropertyValue());
    }

    public void testLiteral() throws RepositoryException {
        Value v = this.superuser.getValueFactory().createValue("test");
        Literal literal = this.qf.literal(v);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong literal value", (String)v.getString(), (String)literal.getLiteralValue().getString());
    }

    public void testLowerCase() throws RepositoryException {
        PropertyValue propValue = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        LowerCase lower = this.qf.lowerCase((DynamicOperand)propValue);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property value operand", (boolean)(lower.getOperand() instanceof PropertyValue));
    }

    public void testNodeLocalName() throws RepositoryException {
        NodeLocalName localName = this.qf.nodeLocalName(SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)localName.getSelectorName());
    }

    public void testNodeLocalNameWithSelector() throws RepositoryException {
        NodeLocalName localName = this.qf.nodeLocalName(SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)localName.getSelectorName());
    }

    public void testNodeName() throws RepositoryException {
        NodeName nodeName = this.qf.nodeName(SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)nodeName.getSelectorName());
    }

    public void testNodeNameWithSelector() throws RepositoryException {
        NodeName nodeName = this.qf.nodeName(SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)nodeName.getSelectorName());
    }

    public void testNot() throws RepositoryException {
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        Not not = this.qf.not((Constraint)propExist);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property existence constraint", (boolean)(not.getConstraint() instanceof PropertyExistence));
    }

    public void testOr() throws RepositoryException {
        PropertyExistence c1 = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        PropertyExistence c2 = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName2);
        Or or = this.qf.or((Constraint)c1, (Constraint)c2);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a PropertyExistence constraint", (boolean)(or.getConstraint1() instanceof PropertyExistence));
        QueryObjectModelFactoryTest.assertTrue((String)"Not a PropertyExistence constraint", (boolean)(or.getConstraint2() instanceof PropertyExistence));
    }

    public void testPropertyExistence() throws RepositoryException {
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector", (String)SELECTOR_NAME1, (String)propExist.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName1, (String)propExist.getPropertyName());
    }

    public void testPropertyExistenceWithSelector() throws RepositoryException {
        PropertyExistence propExist = this.qf.propertyExistence(SELECTOR_NAME1, this.propertyName1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)propExist.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName1, (String)propExist.getPropertyName());
    }

    public void testPropertyValue() throws RepositoryException {
        PropertyValue propVal = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)propVal.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName1, (String)propVal.getPropertyName());
    }

    public void testPropertyValueWithSelector() throws RepositoryException {
        PropertyValue propVal = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)propVal.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong property name", (String)this.propertyName1, (String)propVal.getPropertyName());
    }

    public void testSameNode() throws RepositoryException {
        SameNode sameNode = this.qf.sameNode(SELECTOR_NAME1, this.testRootNode.getPath());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)sameNode.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong path", (String)this.testRootNode.getPath(), (String)sameNode.getPath());
    }

    public void testSameNodeWithSelector() throws RepositoryException {
        SameNode sameNode = this.qf.sameNode(SELECTOR_NAME1, this.testRootNode.getPath());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)sameNode.getSelectorName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong path", (String)this.testRootNode.getPath(), (String)sameNode.getPath());
    }

    public void testSameNodeJoinCondition() throws RepositoryException {
        SameNodeJoinCondition cond = this.qf.sameNodeJoinCondition(SELECTOR_NAME1, SELECTOR_NAME2, ".");
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)cond.getSelector1Name());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME2, (String)cond.getSelector2Name());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector path", (String)".", (String)cond.getSelector2Path());
    }

    public void testSameNodeJoinConditionWithPath() throws RepositoryException {
        SameNodeJoinCondition cond = this.qf.sameNodeJoinCondition(SELECTOR_NAME1, SELECTOR_NAME2, this.nodeName1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)cond.getSelector1Name());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME2, (String)cond.getSelector2Name());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong path", (String)this.nodeName1, (String)cond.getSelector2Path());
    }

    public void testSelector() throws RepositoryException {
        Selector selector = this.qf.selector(this.ntBase, SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong node type name", (String)this.ntBase, (String)selector.getNodeTypeName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)selector.getSelectorName());
    }

    public void testSelectorWithName() throws RepositoryException {
        Selector selector = this.qf.selector(this.ntBase, SELECTOR_NAME1);
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong node type name", (String)this.ntBase, (String)selector.getNodeTypeName());
        QueryObjectModelFactoryTest.assertEquals((String)"Wrong selector name", (String)SELECTOR_NAME1, (String)selector.getSelectorName());
    }

    public void testUpperCase() throws RepositoryException {
        PropertyValue propValue = this.qf.propertyValue(SELECTOR_NAME1, this.propertyName1);
        UpperCase upper = this.qf.upperCase((DynamicOperand)propValue);
        QueryObjectModelFactoryTest.assertTrue((String)"Not a property value operand", (boolean)(upper.getOperand() instanceof PropertyValue));
    }

    static {
        OPERATORS.add("jcr.operator.equal.to");
        OPERATORS.add("jcr.operator.greater.than");
        OPERATORS.add("jcr.operator.greater.than.or.equal.to");
        OPERATORS.add("jcr.operator.less.than");
        OPERATORS.add("jcr.operator.less.than.or.equal.to");
        OPERATORS.add("jcr.operator.like");
        OPERATORS.add("jcr.operator.not.equal.to");
        JOIN_TYPES.add("jcr.join.type.inner");
        JOIN_TYPES.add("jcr.join.type.left.outer");
        JOIN_TYPES.add("jcr.join.type.right.outer");
    }
}

