/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.retention;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.retention.RetentionPolicy;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.retention.AbstractRetentionTest;

public class RetentionPolicyTest
extends AbstractRetentionTest {
    protected void setUp() throws Exception {
        super.setUp();
        RetentionPolicy p = this.retentionMgr.getRetentionPolicy(this.testNodePath);
        if (p != null) {
            this.retentionMgr.removeRetentionPolicy(this.testNodePath);
            this.superuser.save();
        }
    }

    public void testGetRetentionPolicy() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        RetentionPolicy policy = this.retentionMgr.getRetentionPolicy(this.testNodePath);
        RetentionPolicyTest.assertNotNull((String)"RetentionManager.getRetentionPolicy must return the policy set before.", (Object)policy);
    }

    public void testGetRetentionPolicyOnChild() throws RepositoryException, NotExecutableException {
        String childPath = this.testRootNode.addNode(this.nodeName2, this.testNodeType).getPath();
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        RetentionPolicyTest.assertNull((String)"RetentionManager.getRetentionPolicy called on child must not return the policy set before.", (Object)this.retentionMgr.getRetentionPolicy(childPath));
    }

    public void testRetentionPolicyGetName() throws RepositoryException, NotExecutableException {
        RetentionPolicy p = this.getApplicableRetentionPolicy();
        this.retentionMgr.setRetentionPolicy(this.testNodePath, p);
        RetentionPolicy policy = this.retentionMgr.getRetentionPolicy(this.testNodePath);
        RetentionPolicyTest.assertEquals((String)"RetentionPolicy.getName() must match the name of the policy set before.", (String)p.getName(), (String)policy.getName());
    }

    public void testSetRetentionPolicyIsTransient() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        this.superuser.refresh(false);
        RetentionPolicyTest.assertNull((String)"Reverting transient changes must remove the pending retention policy.", (Object)this.retentionMgr.getRetentionPolicy(this.testNodePath));
    }

    public void testRemovePendingRetentionPolicy() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        this.retentionMgr.removeRetentionPolicy(this.testNodePath);
        RetentionPolicyTest.assertNull((String)"Removing pending retention policy must succeed.", (Object)this.retentionMgr.getRetentionPolicy(this.testNodePath));
    }

    public void testRemoveRetentionPolicy() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        this.superuser.save();
        this.retentionMgr.removeRetentionPolicy(this.testNodePath);
        RetentionPolicyTest.assertNull((String)"Removing persisted retention policy must succeed.", (Object)this.retentionMgr.getRetentionPolicy(this.testNodePath));
        this.superuser.save();
        RetentionPolicyTest.assertNull((String)"Removing persisted retention policy must succeed.", (Object)this.retentionMgr.getRetentionPolicy(this.testNodePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveRetentionPolicyIsTransient() throws RepositoryException, NotExecutableException {
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        this.superuser.save();
        try {
            this.retentionMgr.removeRetentionPolicy(this.testNodePath);
            this.superuser.refresh(false);
            RetentionPolicyTest.assertNotNull((String)"Reverting transient removal must re-add the retention policy.", (Object)this.retentionMgr.getRetentionPolicy(this.testNodePath));
        }
        finally {
            this.retentionMgr.removeRetentionPolicy(this.testNodePath);
            this.superuser.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveRetentionPolicyFromChild() throws RepositoryException, NotExecutableException {
        String childPath = this.testRootNode.addNode(this.nodeName2, this.testNodeType).getPath();
        this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
        try {
            this.retentionMgr.removeRetentionPolicy(childPath);
            RetentionPolicyTest.fail((String)"Removing retention policy from another node must fail");
        }
        catch (RepositoryException e) {
            RetentionPolicyTest.assertNull((Object)this.retentionMgr.getRetentionPolicy(childPath));
        }
        this.superuser.save();
        try {
            this.retentionMgr.removeRetentionPolicy(childPath);
            RetentionPolicyTest.fail((String)"Removing retention policy from another node must fail");
        }
        catch (RepositoryException e) {
            RetentionPolicyTest.assertNull((Object)this.retentionMgr.getRetentionPolicy(childPath));
        }
        finally {
            this.retentionMgr.removeRetentionPolicy(this.testNodePath);
            this.superuser.save();
        }
    }

    public void testInvalidPath() throws RepositoryException, NotExecutableException {
        String invalidPath = this.testPath;
        try {
            this.retentionMgr.getRetentionPolicy(invalidPath);
            RetentionPolicyTest.fail((String)"Accessing retention policy for an invalid path must throw RepositoryException.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.setRetentionPolicy(invalidPath, this.getApplicableRetentionPolicy());
            RetentionPolicyTest.fail((String)"Setting retention policy with an invalid path must throw RepositoryException.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.removeRetentionPolicy(invalidPath);
            RetentionPolicyTest.fail((String)"Removing retention policy with an invalid path must throw RepositoryException.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testNonExistingNodePath() throws RepositoryException, NotExecutableException {
        String invalidPath = this.testNodePath + "/nonexisting";
        int cnt = 0;
        while (this.superuser.nodeExists(invalidPath)) {
            invalidPath = invalidPath + cnt++;
        }
        try {
            this.retentionMgr.getRetentionPolicy(invalidPath);
            RetentionPolicyTest.fail((String)"Accessing retention policy from non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.setRetentionPolicy(invalidPath, this.getApplicableRetentionPolicy());
            RetentionPolicyTest.fail((String)"Setting retention policy for a non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.removeRetentionPolicy(invalidPath);
            RetentionPolicyTest.fail((String)"Removing retention policy at a non-existing node must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testPropertyPath() throws RepositoryException, NotExecutableException {
        String propPath = null;
        PropertyIterator it = this.testRootNode.getProperties();
        while (it.hasNext()) {
            String path = it.nextProperty().getPath();
            if (this.superuser.nodeExists(path)) continue;
            propPath = path;
            break;
        }
        if (propPath == null) {
            throw new NotExecutableException();
        }
        try {
            this.retentionMgr.getRetentionPolicy(propPath);
            RetentionPolicyTest.fail((String)"Accessing retention policy from property must throw PathNotFoundException.");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.setRetentionPolicy(propPath, this.getApplicableRetentionPolicy());
            RetentionPolicyTest.fail((String)"Setting retention policy for property must throw PathNotFoundException.");
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        try {
            this.retentionMgr.removeRetentionPolicy(propPath);
            RetentionPolicyTest.fail((String)"Removing retention policy at property path must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testInvalidName() {
        try {
            RetentionPolicy rp = new RetentionPolicy(){

                public String getName() throws RepositoryException {
                    return "*.[y]";
                }
            };
            this.retentionMgr.setRetentionPolicy(this.testNodePath, rp);
            RetentionPolicyTest.fail((String)"Setting a policy with an invalid JCR name must fail.");
        }
        catch (RepositoryException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlySession() throws NotExecutableException, RepositoryException {
        Session s = this.getHelper().getReadOnlySession();
        try {
            RetentionManager rmgr = RetentionPolicyTest.getRetentionManager(s);
            try {
                rmgr.getRetentionPolicy(this.testNodePath);
                RetentionPolicyTest.fail((String)"Read-only session doesn't have sufficient privileges to retrieve retention policy.");
            }
            catch (AccessDeniedException e) {
                // empty catch block
            }
            try {
                rmgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
                RetentionPolicyTest.fail((String)"Read-only session doesn't have sufficient privileges to retrieve retention policy.");
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        finally {
            s.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRetentionPolicyOnLockedNode() throws NotExecutableException, RepositoryException {
        String childPath = this.getLockedChildNode().getPath();
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            RetentionManager rmgr = RetentionPolicyTest.getRetentionManager(otherS);
            rmgr.setRetentionPolicy(childPath, this.getApplicableRetentionPolicy());
            otherS.save();
            RetentionPolicyTest.fail((String)"Setting a retention policy on a locked node must throw LockException.");
        }
        catch (LockException lockException) {
        }
        finally {
            otherS.logout();
            if (this.retentionMgr.getRetentionPolicy(childPath) != null) {
                this.retentionMgr.removeRetentionPolicy(childPath);
            }
            this.superuser.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveRetentionPolicyOnLockedNode() throws NotExecutableException, RepositoryException {
        String childPath = this.getLockedChildNode().getPath();
        this.retentionMgr.setRetentionPolicy(childPath, this.getApplicableRetentionPolicy());
        this.testRootNode.save();
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            RetentionManager rmgr = RetentionPolicyTest.getRetentionManager(otherS);
            rmgr.removeRetentionPolicy(childPath);
            RetentionPolicyTest.fail((String)"Removing a retention policy on a locked node must throw LockException.");
        }
        catch (LockException e) {
        }
        finally {
            otherS.logout();
            try {
                this.retentionMgr.removeRetentionPolicy(childPath);
                this.superuser.save();
            }
            catch (RepositoryException e) {}
        }
    }

    private Node getLockedChildNode() throws NotExecutableException, RepositoryException {
        this.checkSupportedOption("option.locking.supported");
        Node child = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(child, this.mixLockable);
        this.testRootNode.save();
        child.lock(false, true);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRetentionPolicyOnCheckedInNode() throws NotExecutableException, RepositoryException {
        Node child = this.getVersionableChildNode();
        child.checkout();
        child.checkin();
        String childPath = child.getPath();
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            RetentionManager rmgr = RetentionPolicyTest.getRetentionManager(otherS);
            rmgr.setRetentionPolicy(childPath, this.getApplicableRetentionPolicy());
            otherS.save();
            RetentionPolicyTest.fail((String)"Setting a retention policy on a checked-in node must throw VersionException.");
        }
        catch (VersionException e) {
        }
        finally {
            otherS.logout();
            try {
                this.retentionMgr.removeRetentionPolicy(childPath);
                this.superuser.save();
            }
            catch (RepositoryException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveRetentionPolicyOnCheckedInNode() throws NotExecutableException, RepositoryException {
        Node child = this.getVersionableChildNode();
        child.checkout();
        this.retentionMgr.setRetentionPolicy(child.getPath(), this.getApplicableRetentionPolicy());
        this.superuser.save();
        child.checkin();
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            RetentionManager rmgr = RetentionPolicyTest.getRetentionManager(otherS);
            rmgr.removeRetentionPolicy(child.getPath());
            otherS.save();
            RetentionPolicyTest.fail((String)"Removing a retention policy on a checked-in node must throw VersionException.");
        }
        catch (VersionException e) {
        }
        finally {
            otherS.logout();
            child.checkout();
            try {
                this.retentionMgr.removeRetentionPolicy(child.getPath());
                this.superuser.save();
            }
            catch (RepositoryException e) {}
        }
    }

    private Node getVersionableChildNode() throws NotExecutableException, RepositoryException {
        this.checkSupportedOption("option.versioning.supported");
        Node child = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(child, this.mixVersionable);
        this.testRootNode.save();
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRetentionPolicyBelow() throws RepositoryException, NotExecutableException {
        Node childN = this.testRootNode.addNode(this.nodeName2);
        this.superuser.save();
        try {
            this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
            this.retentionMgr.setRetentionPolicy(childN.getPath(), this.getApplicableRetentionPolicy());
            this.superuser.save();
        }
        finally {
            this.superuser.refresh(false);
            if (this.retentionMgr.getRetentionPolicy(this.testNodePath) != null) {
                this.retentionMgr.removeRetentionPolicy(this.testNodePath);
            }
            if (this.retentionMgr.getRetentionPolicy(childN.getPath()) != null) {
                this.retentionMgr.removeRetentionPolicy(childN.getPath());
            }
            this.superuser.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOtherSessionSetsRetentionPolicyBelow() throws RepositoryException, NotExecutableException {
        Node childN = this.testRootNode.addNode(this.nodeName2);
        this.superuser.save();
        Session otherS = this.getHelper().getSuperuserSession();
        try {
            this.retentionMgr.setRetentionPolicy(this.testNodePath, this.getApplicableRetentionPolicy());
            this.superuser.save();
            RetentionPolicyTest.getRetentionManager(otherS).setRetentionPolicy(childN.getPath(), this.getApplicableRetentionPolicy());
            otherS.save();
        }
        finally {
            otherS.logout();
            this.superuser.refresh(false);
            if (this.retentionMgr.getRetentionPolicy(this.testNodePath) != null) {
                this.retentionMgr.removeRetentionPolicy(this.testNodePath);
            }
            if (this.retentionMgr.getRetentionPolicy(childN.getPath()) != null) {
                this.retentionMgr.removeRetentionPolicy(childN.getPath());
            }
            this.superuser.save();
        }
    }
}

