/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class ActivitiesTest
extends AbstractVersionTest {
    private VersionManager vm;
    private static String PREFIX = "/jcr:system/jcr:activities/";

    protected void setUp() throws Exception {
        super.setUp();
        this.checkSupportedOption("option.activities.supported");
        this.vm = this.superuser.getWorkspace().getVersionManager();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateRemoveActivity() throws Exception {
        Node an = null;
        try {
            an = this.vm.createActivity("foobar");
            ActivitiesTest.assertNotNull((Object)an);
            NodeType annt = an.getPrimaryNodeType();
            ActivitiesTest.assertTrue((String)"create node must be subtype of nt:activity", (boolean)annt.isNodeType("nt:activity"));
        }
        finally {
            if (an != null) {
                this.vm.removeActivity(an);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetGetActivity() throws Exception {
        Node an = null;
        try {
            an = this.vm.createActivity("foobar");
            ActivitiesTest.assertNotNull((Object)an);
            ActivitiesTest.assertNull((Object)this.vm.getActivity());
            Node old = this.vm.setActivity(an);
            ActivitiesTest.assertNull((Object)old);
            ActivitiesTest.assertEquals((String)an.getPath(), (String)this.vm.getActivity().getPath());
            old = this.vm.setActivity(null);
            ActivitiesTest.assertEquals((String)old.getPath(), (String)an.getPath());
            ActivitiesTest.assertNull((Object)this.vm.getActivity());
        }
        finally {
            if (an != null) {
                this.vm.removeActivity(an);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivitiesPath() throws Exception {
        Node an = null;
        try {
            an = this.vm.createActivity("foobar");
            ActivitiesTest.assertNotNull((Object)an);
            NodeType annt = an.getPrimaryNodeType();
            ActivitiesTest.assertTrue((String)"create node must be subtype of nt:activity", (boolean)annt.isNodeType("nt:activity"));
            ActivitiesTest.assertTrue((String)("path for activity must be below " + PREFIX + ", but was " + an.getPath()), (boolean)an.getPath().startsWith(PREFIX));
            Node activities = this.superuser.getNode(PREFIX);
            try {
                activities.addNode("foobar");
                ActivitiesTest.fail((String)"/jcr:system/jcr:activities must be protected.");
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        finally {
            if (an != null) {
                this.vm.removeActivity(an);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivitiesRelation() throws Exception {
        Node an = null;
        try {
            an = this.vm.createActivity("foobar");
            this.vm.setActivity(an);
            String path = this.versionableNode.getPath();
            if (this.versionableNode.isCheckedOut()) {
                this.vm.checkin(path);
            }
            this.vm.checkout(path);
            this.versionableNode = this.superuser.getNode(path);
            Property act = this.versionableNode.getProperty("{http://www.jcp.org/jcr/1.0}activity");
            ActivitiesTest.assertNotNull((Object)act);
            ActivitiesTest.assertEquals((int)9, (int)act.getType());
            ActivitiesTest.assertTrue((boolean)act.getNode().isSame((Item)an));
            this.versionableNode.remove();
            this.versionableNode.getSession().save();
        }
        finally {
            if (an != null) {
                this.vm.removeActivity(an);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testActivitiesRelationWithCheckpoint() throws Exception {
        Node an = null;
        try {
            an = this.vm.createActivity("foobar2");
            this.vm.setActivity(an);
            String path = this.versionableNode.getPath();
            this.vm.checkpoint(path);
            this.versionableNode = this.superuser.getNode(path);
            Property act = this.versionableNode.getProperty("{http://www.jcp.org/jcr/1.0}activity");
            ActivitiesTest.assertNotNull((Object)act);
            ActivitiesTest.assertEquals((int)9, (int)act.getType());
            ActivitiesTest.assertTrue((boolean)act.getNode().isSame((Item)an));
            this.versionableNode.remove();
            this.superuser.save();
        }
        finally {
            if (an != null) {
                this.vm.removeActivity(an);
            }
        }
    }
}

