/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class ConcurrentTestSuite
extends TestSuite {
    private final Executor executor;
    private volatile int finishedTestCount;

    public ConcurrentTestSuite(String name) {
        this(name, Runtime.getRuntime().availableProcessors() * 2);
    }

    public ConcurrentTestSuite() {
        this(null);
    }

    public ConcurrentTestSuite(int numThreads) {
        this(null, numThreads);
    }

    public ConcurrentTestSuite(String name, int numThreads) {
        super(name);
        this.executor = new PooledExecutor(numThreads){
            {
                this.waitWhenBlocked();
            }
        };
    }

    public void run(TestResult result) {
        this.finishedTestCount = 0;
        super.run(result);
        this.waitUntilFinished();
    }

    public void runTest(final Test test, final TestResult result) {
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConcurrentTestSuite.super.runTest(test, result);
                    }
                    finally {
                        ConcurrentTestSuite.this.runFinished();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void waitUntilFinished() {
        while (this.finishedTestCount < this.testCount()) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private synchronized void runFinished() {
        ++this.finishedTestCount;
        ((Object)((Object)this)).notifyAll();
    }
}

