/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class NameTest
extends AbstractJCRTest {
    private String getExpandedName(String jcrName) throws RepositoryException {
        if (jcrName.startsWith("{")) {
            return jcrName;
        }
        int pos = jcrName.indexOf(":");
        String prefix = pos > -1 ? jcrName.substring(0, pos) : "";
        String uri = this.superuser.getNamespaceURI(prefix);
        return "{" + uri + "}" + jcrName.substring(pos + 1);
    }

    public void testExpandedNameValue() throws RepositoryException {
        ValueFactory vf = this.superuser.getValueFactory();
        Value nameValue = vf.createValue("{http://www.jcp.org/jcr/1.0}versionStorage", 7);
        NameTest.assertEquals((int)7, (int)nameValue.getType());
        NameTest.assertEquals((String)nameValue.getString(), (String)vf.createValue("jcr:versionStorage", 7).getString());
        NameTest.assertEquals((Object)nameValue, (Object)vf.createValue("jcr:versionStorage", 7));
        NameTest.assertEquals((String)"jcr:versionStorage", (String)nameValue.getString());
    }

    public void testExpandedNameValueProperty() throws RepositoryException {
        ValueFactory vf = this.superuser.getValueFactory();
        Value nameValue = vf.createValue("{http://www.jcp.org/jcr/1.0}versionStorage", 7);
        Property p = this.testRootNode.setProperty(this.propertyName1, nameValue);
        NameTest.assertEquals((int)7, (int)p.getType());
        NameTest.assertEquals((String)nameValue.getString(), (String)p.getValue().getString());
        NameTest.assertEquals((Object)nameValue, (Object)p.getValue());
        NameTest.assertEquals((String)"jcr:versionStorage", (String)p.getString());
    }

    public void testExpandedNameItem() throws RepositoryException {
        String propName = this.getExpandedName(this.propertyName1);
        Property p = this.testRootNode.setProperty(propName, this.getJcrValue(this.superuser, "propertyvalue1", "propertytype1", "test"));
        NameTest.assertEquals((String)this.propertyName1, (String)p.getName());
    }

    public void testExpandedNameNodeUnmappedNamespace() throws RepositoryException {
        String ns = "urn:uuid:" + UUID.randomUUID().toString();
        String expandedName = "{" + ns + "}test";
        try {
            Node createdNode = this.testRootNode.addNode(expandedName);
            this.testRootNode.getSession().save();
            String qualifiedName = createdNode.getName();
            NameTest.assertEquals((String)expandedName, (String)this.getExpandedName(qualifiedName));
        }
        catch (ItemExistsException | PathNotFoundException | LockException | ConstraintViolationException | VersionException ex) {
            NameTest.fail((String)("unexpected exception: " + ex));
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testReallyNotAndExpandedName() throws RepositoryException {
        String notANamespace = UUID.randomUUID().toString();
        String name = "{" + notANamespace + "}test";
        Node createdNode = this.testRootNode.addNode(name);
        this.testRootNode.getSession().save();
        NameTest.assertEquals((String)name, (String)createdNode.getName());
    }

    public void testExpandedNodeTypeName() throws RepositoryException {
        String nodeName = this.getExpandedName(this.nodeName1);
        String ntName = this.getExpandedName(this.testNodeType);
        Node n = this.testRootNode.addNode(nodeName, ntName);
        NameTest.assertEquals((String)this.nodeName1, (String)n.getName());
        NameTest.assertEquals((String)this.testNodeType, (String)n.getPrimaryNodeType().getName());
        n.setPrimaryType(ntName);
        NameTest.assertEquals((String)this.testNodeType, (String)n.getPrimaryNodeType().getName());
    }
}

