/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SessionTest
extends AbstractJCRTest {
    public void testMoveItemExistsException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node srcParentNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node moveNode = srcParentNode.addNode(this.nodeName2, this.getProperty("nodetype3"));
        Node destParentNode = defaultRootNode.addNode(this.nodeName3, this.getProperty("nodetype2"));
        Node destNode = destParentNode.addNode(this.nodeName2, this.getProperty("nodetype3"));
        this.superuser.save();
        try {
            this.superuser.move(moveNode.getPath(), destNode.getPath());
            SessionTest.fail((String)"Moving a node using Session.move() to a location where a node with same name already exists must throw ItemExistsException");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testMovePathNotFoundExceptionDestInvalid() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node srcParentNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node moveNode = srcParentNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        try {
            this.superuser.move(moveNode.getPath(), defaultRootNode.getPath() + "/" + this.nodeName2 + "/" + this.nodeName1);
            SessionTest.fail((String)"Invalid destination path during Session.move() must throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testMovePathNotFoundExceptionSrcInvalid() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node destParentNode = defaultRootNode.addNode(this.nodeName3, this.testNodeType);
        this.superuser.save();
        try {
            this.superuser.move(defaultRootNode.getPath() + "/" + this.nodeName1, destParentNode.getPath() + "/" + this.nodeName2);
            SessionTest.fail((String)"Invalid source path during Session.move() must throw PathNotFoundException");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testMoveRepositoryException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node srcParentNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node moveNode = srcParentNode.addNode(this.nodeName2, this.testNodeType);
        Node destParentNode = defaultRootNode.addNode(this.nodeName3, this.testNodeType);
        this.superuser.save();
        try {
            this.superuser.move(moveNode.getPath(), destParentNode.getPath() + "/" + this.nodeName2 + "[1]");
            SessionTest.fail((String)"If destination path of Session.move() contains an index as postfix it must throw RepositoryException");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testMoveConstraintViolationExceptionSrc() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node srcParentNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node moveNode = srcParentNode.addNode(this.nodeName2, this.testNodeType);
        Node destParentNode = defaultRootNode.addNode(this.nodeName3, this.testNodeType);
        this.superuser.save();
        this.superuser.move(moveNode.getPath(), destParentNode.getPath() + "/" + this.nodeName2);
        try {
            srcParentNode.save();
            SessionTest.fail((String)"Saving only the source parent node after a Session.move() operation must throw ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testMoveConstraintViolationExceptionDest() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node srcParentNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node moveNode = srcParentNode.addNode(this.nodeName2, this.testNodeType);
        Node destParentNode = defaultRootNode.addNode(this.nodeName3, this.testNodeType);
        this.superuser.save();
        this.superuser.move(moveNode.getPath(), destParentNode.getPath() + "/" + this.nodeName2);
        try {
            destParentNode.save();
            SessionTest.fail((String)"Saving only moved node after a Session.move() operation should throw ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveLockException() throws NotExecutableException, RepositoryException {
        Session session = this.superuser;
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        Node lockableNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(lockableNode, this.mixLockable);
        Node srcNode = lockableNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        String pathRelToRoot = lockableNode.getPath().substring(1);
        Session session2 = this.getHelper().getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(true, true);
            try {
                String destPath = this.testRoot + "/" + this.nodeName2;
                session.move(srcNode.getPath(), destPath);
                this.testRootNode.getSession().save();
                SessionTest.fail((String)"A LockException is thrown either immediately or on save  if a lock prevents the move.");
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
        finally {
            session2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveNode() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node srcParentNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node moveNode = srcParentNode.addNode(this.nodeName2, this.testNodeType);
        Node destParentNode = defaultRootNode.addNode(this.nodeName3, this.testNodeType);
        this.superuser.save();
        this.superuser.move(moveNode.getPath(), destParentNode.getPath() + "/" + this.nodeName2);
        this.superuser.save();
        Session testSession = this.getHelper().getReadWriteSession();
        try {
            testSession.getItem(destParentNode.getPath() + "/" + this.nodeName2);
        }
        finally {
            testSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveNewNode() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node newNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        Session s = this.getHelper().getReadOnlySession();
        try {
            s.getItem(newNode.getPath());
        }
        finally {
            s.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveModifiedNode() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node newNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        newNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        Session s = this.getHelper().getReadOnlySession();
        try {
            Node newNodeSession2 = (Node)s.getItem(newNode.getPath());
            SessionTest.assertTrue((String)"Modifications on  a node are not save after Session.save()", (boolean)newNodeSession2.hasNode(this.nodeName2));
        }
        finally {
            s.logout();
        }
    }

    public void testSaveConstraintViolationException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        defaultRootNode.addNode(this.nodeName1, this.getProperty("nodetype2"));
        try {
            this.superuser.save();
            SessionTest.fail((String)"Trying to use Session.save() with a node that has a mandatory property not set, should throw ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveInvalidStateException() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node nodeSession1 = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        nodeSession1.addNode(this.nodeName2, this.testNodeType);
        Session testSession = this.getHelper().getReadWriteSession();
        try {
            Node nodeSession2 = (Node)testSession.getItem(nodeSession1.getPath());
            nodeSession2.remove();
            testSession.save();
            try {
                this.superuser.save();
                SessionTest.fail((String)"Saving a modified Node using Session.save() already deleted by an other session should throw InvalidItemStateException");
            }
            catch (InvalidItemStateException invalidItemStateException) {
                // empty catch block
            }
        }
        finally {
            testSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshBooleanFalse() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode1Session1 = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node testNode2Session1 = defaultRootNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        testNode1Session1.addNode(this.nodeName2, this.testNodeType);
        Session session2 = this.getHelper().getReadWriteSession();
        try {
            Node testNode2Session2 = (Node)session2.getItem(testNode2Session1.getPath());
            testNode2Session2.addNode(this.nodeName3, this.testNodeType);
            session2.save();
            this.superuser.refresh(false);
            SessionTest.assertFalse((String)"Session should have no pending changes recorded after Session.refresh(false)!", (boolean)this.superuser.hasPendingChanges());
            SessionTest.assertFalse((String)"Node Modifications have not been flushed after session.refresh(false)", (boolean)testNode1Session1.hasNodes());
            SessionTest.assertTrue((String)"Node modified by a different session has not been updated after Session.refresh(false)", (boolean)testNode2Session1.hasNodes());
        }
        finally {
            session2.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshBooleanTrue() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode1Session1 = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        Node testNode2Session1 = defaultRootNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        testNode1Session1.addNode(this.nodeName2, this.testNodeType);
        Session session2 = this.getHelper().getReadWriteSession();
        try {
            Node testNode2Session2 = (Node)session2.getItem(testNode2Session1.getPath());
            testNode2Session2.addNode(this.nodeName3, this.testNodeType);
            session2.save();
            this.superuser.refresh(true);
            SessionTest.assertTrue((String)"Session should still have pending changes recorded after Session.refresh(true)!", (boolean)this.superuser.hasPendingChanges());
            SessionTest.assertTrue((String)"Node Modifications are lost after session.refresh(true)", (boolean)testNode1Session1.hasNodes());
            SessionTest.assertTrue((String)"Node modified by a different session has not been updated after Session.refresh(true)", (boolean)testNode2Session1.hasNodes());
        }
        finally {
            session2.logout();
        }
    }

    public void testHasPendingChanges() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        SessionTest.assertFalse((String)"Session should have no pending changes recorded!", (boolean)this.superuser.hasPendingChanges());
        Node testNode1 = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        SessionTest.assertTrue((String)"Session should have pending changes recorded after new node was added!", (boolean)this.superuser.hasPendingChanges());
        this.superuser.save();
        SessionTest.assertFalse((String)"Session should have no pending changes recorded after new node was added and saved!", (boolean)this.superuser.hasPendingChanges());
        testNode1.setProperty(this.propertyName1, "test");
        SessionTest.assertTrue((String)"Session should have pending changes recorded after a property was added!", (boolean)this.superuser.hasPendingChanges());
        this.superuser.save();
        SessionTest.assertFalse((String)"Session should have no pending changes recorded after added property hase been saved!", (boolean)this.superuser.hasPendingChanges());
        Node testChildNode = testNode1.addNode(this.nodeName1, this.testNodeType);
        SessionTest.assertTrue((String)"Session should have pending changes recorded after child node has been added!", (boolean)this.superuser.hasPendingChanges());
        this.superuser.save();
        SessionTest.assertFalse((String)"Session should have no pending changes recorded after new child node has been added and saved!", (boolean)this.superuser.hasPendingChanges());
        testChildNode.remove();
        SessionTest.assertTrue((String)"Session should have pending changes recorded after child node has been removed", (boolean)this.superuser.hasPendingChanges());
        this.superuser.save();
        SessionTest.assertFalse((String)"Session should have no pending changes recorded after child node has been removed and saved!", (boolean)this.superuser.hasPendingChanges());
        testNode1.setProperty(this.propertyName1, (Value)null);
        SessionTest.assertTrue((String)"Session should have pending changes recorded after property has been removed", (boolean)this.superuser.hasPendingChanges());
        this.superuser.save();
        SessionTest.assertFalse((String)"Session should have no pending changes recorded after property has been removed and saved!", (boolean)this.superuser.hasPendingChanges());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHasCapability() throws RepositoryException {
        Session roSession = this.getHelper().getReadOnlySession();
        try {
            Node testRoot = roSession.getNode(this.testRootNode.getPath());
            Object[] args = new Object[]{"foo"};
            if (!roSession.hasCapability("addNode", (Object)testRoot, args)) {
                try {
                    testRoot.addNode("foo");
                    roSession.save();
                    SessionTest.fail((String)"Node.addNode() should fail according to Session.hasCapability()");
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
        finally {
            roSession.logout();
        }
    }
}

