/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class SetPropertyConstraintViolationExceptionTest
extends AbstractJCRTest {
    public void testBooleanProperty() throws NotExecutableException, RepositoryException {
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 6, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No boolean property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No boolean property def with testable value constraints has been found");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            this.testRootNode.getSession().save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied.getBoolean());
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, boolean value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied);
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, boolean value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testDateProperty() throws NotExecutableException, RepositoryException {
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 5, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No date property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No date property def with testable value constraints has been found");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            this.testRootNode.getSession().save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied.getDate());
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, Calendar value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied);
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testDoubleProperty() throws NotExecutableException, RepositoryException {
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 4, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No double property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No double property def with testable value constraints has been found");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            this.testRootNode.getSession().save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied.getDouble());
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, double value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied);
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinaryProperty() throws NotExecutableException, RepositoryException {
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 2, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No binary property def with testable value constraints has been found");
        }
        Value valueNotSatisfied1 = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        Value valueNotSatisfied2 = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied1 == null || valueNotSatisfied2 == null) {
            throw new NotExecutableException("No binary property def with testable value constraints has been found");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            this.testRootNode.getSession().save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        InputStream in = valueNotSatisfied1.getStream();
        try {
            node.setProperty(propDef.getName(), in);
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, InputStream value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied2);
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testLongProperty() throws NotExecutableException, RepositoryException {
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 3, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No long property def with testable value constraints has been found");
        }
        Value valueNotSatisfied = NodeTypeUtil.getValueAccordingToValueConstraints(this.superuser, propDef, false);
        if (valueNotSatisfied == null) {
            throw new NotExecutableException("No long property def with testable value constraints has been found");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            this.testRootNode.getSession().save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied.getLong());
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, long value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            node.setProperty(propDef.getName(), valueNotSatisfied);
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testReferenceProperty() throws NotExecutableException, RepositoryException {
        Node nodeNotSatisfied;
        Node node;
        PropertyDefinition propDef = NodeTypeUtil.locatePropertyDef(this.superuser, 9, false, false, true, false);
        if (propDef == null) {
            throw new NotExecutableException("No reference property def with testable value constraints has been found");
        }
        String[] valueConstraints = propDef.getValueConstraints();
        if (valueConstraints == null || valueConstraints.length == 0) {
            throw new NotExecutableException("No reference property def with testable value constraints has been found");
        }
        List<String> constraints = Arrays.asList(valueConstraints);
        String nodeTypeNotSatisfied = null;
        NodeTypeManager manager = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeIterator types = manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            String name = type.getName();
            if (constraints.contains(name) || this.ntFrozenNode.equals(name) || type.getChildNodeDefinitions() != null && type.getChildNodeDefinitions().length > 0) continue;
            nodeTypeNotSatisfied = name;
            break;
        }
        if (nodeTypeNotSatisfied == null) {
            throw new NotExecutableException("No reference property def with testable value constraints has been found");
        }
        try {
            String nodeType = propDef.getDeclaringNodeType().getName();
            node = this.testRootNode.addNode(this.nodeName2, nodeType);
            nodeNotSatisfied = this.testRootNode.addNode(this.nodeName4, nodeTypeNotSatisfied);
            this.ensureMixinType(nodeNotSatisfied, this.mixReferenceable);
            this.testRootNode.getSession().save();
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Not able to create required test items.");
        }
        try {
            node.setProperty(propDef.getName(), nodeNotSatisfied);
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, Node value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            node.setProperty(propDef.getName(), this.superuser.getValueFactory().createValue(nodeNotSatisfied));
            node.save();
            SetPropertyConstraintViolationExceptionTest.fail((String)"setProperty(String name, Value value) must throw a ConstraintViolationException if the change would violate a node type constraint either immediately or on save");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

