/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.api.util.InputStreamWrapper;

public class SetValueInputStreamTest
extends AbstractJCRTest {
    private byte[] data;
    private Node node;
    private Property property1;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.data = this.createRandomString(10).getBytes();
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        if (this.propertyName1.equals("jcr:data") && this.node.hasNode("jcr:content") && this.node.getNode("jcr:content").isNodeType("nt:resource") && !this.node.hasProperty("jcr:data")) {
            this.node = this.node.getNode("jcr:content");
        }
        this.property1 = this.node.setProperty(this.propertyName1, this.superuser.getValueFactory().createValue((InputStream)new ByteArrayInputStream(new byte[0])));
        this.superuser.save();
    }

    @Override
    protected void tearDown() throws Exception {
        this.node = null;
        this.property1 = null;
        super.tearDown();
    }

    public void testInputStreamClosed() throws RepositoryException, IOException {
        InputStreamWrapper in = new InputStreamWrapper(new ByteArrayInputStream(this.data));
        this.property1.setValue((InputStream)in);
        SetValueInputStreamTest.assertTrue((String)"Property.setValue(InputStream) is expected to close the passed input stream", (boolean)in.isClosed());
    }
}

