/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class PredefinedNodeTypeTest
extends AbstractJCRTest {
    private static final Map<String, String[]> SUPERTYPES = new HashMap<String, String[]>();
    private NodeTypeManager manager;
    private Session session;
    private static final Comparator<NodeDefinition> NODE_DEF_COMPARATOR;
    private static final Comparator<PropertyDefinition> PROPERTY_DEF_COMPARATOR;
    private static final Comparator<NodeType> NODE_TYPE_COMPARATOR;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.manager = this.session.getWorkspace().getNodeTypeManager();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.manager = null;
        super.tearDown();
    }

    public void testIfPrimaryNodeTypesAreSubtypesOfNTBase() throws RepositoryException {
        NodeTypeIterator types = this.manager.getPrimaryNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            PredefinedNodeTypeTest.assertTrue((String)("Primary node type " + type.getName() + " must inherit nt:base"), (boolean)type.isNodeType("nt:base"));
        }
    }

    public void testLifecycle() throws NotExecutableException {
        this.testPredefinedNodeType("mix:lifecycle", false);
    }

    public void testLockable() throws NotExecutableException {
        this.testPredefinedNodeType("mix:lockable", false);
    }

    public void testReferenceable() throws NotExecutableException {
        this.testPredefinedNodeType("mix:referenceable", false);
    }

    public void testShareable() throws NotExecutableException {
        this.testPredefinedNodeType("mix:shareable", false);
    }

    public void testVersionable() throws NotExecutableException {
        this.testPredefinedNodeType("mix:versionable", false);
    }

    public void testSimpleVersionable() throws NotExecutableException {
        this.testPredefinedNodeType("mix:simpleVersionable", false);
    }

    public void testMixCreated() throws NotExecutableException {
        this.testPredefinedNodeType("mix:created", true);
    }

    public void testMixLastModified() throws NotExecutableException {
        this.testPredefinedNodeType("mix:lastModified", true);
    }

    public void testMixETag() throws NotExecutableException {
        this.testPredefinedNodeType("mix:etag", false);
    }

    public void testMixTitle() throws NotExecutableException {
        this.testPredefinedNodeType("mix:title", true);
    }

    public void testMixLanguage() throws NotExecutableException {
        this.testPredefinedNodeType("mix:language", true);
    }

    public void testMixMimeType() throws NotExecutableException {
        this.testPredefinedNodeType("mix:mimeType", true);
    }

    public void testNtAddress() throws NotExecutableException {
        this.testPredefinedNodeType("nt:address", false);
    }

    public void testBase() throws NotExecutableException {
        this.testPredefinedNodeType("nt:base", false);
    }

    public void testUnstructured() throws NotExecutableException {
        this.testPredefinedNodeType("nt:unstructured", false);
    }

    public void testHierarchyNode() throws NotExecutableException {
        this.testPredefinedNodeType("nt:hierarchyNode", false);
    }

    public void testFile() throws NotExecutableException {
        this.testPredefinedNodeType("nt:file", false);
    }

    public void testLinkedFile() throws NotExecutableException {
        this.testPredefinedNodeType("nt:linkedFile", false);
    }

    public void testFolder() throws NotExecutableException {
        this.testPredefinedNodeType("nt:folder", false);
    }

    public void testNodeType() throws NotExecutableException {
        this.testPredefinedNodeType("nt:nodeType", false);
    }

    public void testPropertyDef() throws NotExecutableException {
        this.testPredefinedNodeType("nt:propertyDefinition", false);
    }

    public void testChildNodeDef() throws NotExecutableException {
        this.testPredefinedNodeType("nt:childNodeDefinition", false);
    }

    public void testVersionHistory() throws NotExecutableException {
        this.testPredefinedNodeType("nt:versionHistory", false);
    }

    public void testVersionLabels() throws NotExecutableException {
        this.testPredefinedNodeType("nt:versionLabels", false);
    }

    public void testVersion() throws NotExecutableException {
        this.testPredefinedNodeType("nt:version", false);
    }

    public void testActivity() throws NotExecutableException {
        this.testPredefinedNodeType("nt:activity", false);
    }

    public void testConfiguration() throws NotExecutableException {
        this.testPredefinedNodeType("nt:configuration", false);
    }

    public void testFrozenNode() throws NotExecutableException {
        this.testPredefinedNodeType("nt:frozenNode", false);
    }

    public void testVersionedChild() throws NotExecutableException {
        this.testPredefinedNodeType("nt:versionedChild", false);
    }

    public void testQuery() throws NotExecutableException {
        this.testPredefinedNodeType("nt:query", false);
    }

    public void testResource() throws NotExecutableException {
        this.testPredefinedNodeType("nt:resource", false);
    }

    private void testPredefinedNodeType(String name, boolean propsVariant) throws NotExecutableException {
        try {
            StringBuffer spec = new StringBuffer();
            String resource = "org/apache/jackrabbit/test/api/nodetype/spec/" + name.replace(':', '-') + ".txt";
            InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource));
            int ch = ((Reader)reader).read();
            while (ch != -1) {
                spec.append((char)ch);
                ch = ((Reader)reader).read();
            }
            NodeType type = this.manager.getNodeType(name);
            String current = PredefinedNodeTypeTest.getNodeTypeSpec(type, propsVariant).trim();
            if (!System.getProperty("line.separator").equals("\n")) {
                current = this.normalizeLineSeparators(current);
            }
            String expected = this.normalizeLineSeparators(spec.toString()).trim();
            PredefinedNodeTypeTest.assertEquals((String)("Predefined node type " + name), (String)expected, (String)current);
            HashSet<String> declaredSupertypes = new HashSet<String>();
            for (NodeType nodeType : Arrays.asList(type.getDeclaredSupertypes())) {
                declaredSupertypes.add(nodeType.getName());
            }
            for (String string : Arrays.asList((Object[])SUPERTYPES.get(name))) {
                PredefinedNodeTypeTest.assertTrue((String)("Predefined node type " + name + " does not declare supertype " + string), (boolean)declaredSupertypes.contains(string));
            }
        }
        catch (IOException e) {
            PredefinedNodeTypeTest.fail((String)e.getMessage());
        }
        catch (NoSuchNodeTypeException e) {
            if ("nt:base".equals(name)) {
                PredefinedNodeTypeTest.fail((String)e.getMessage());
            }
            throw new NotExecutableException("NodeType " + name + " not supported by this repository implementation.");
        }
        catch (RepositoryException e) {
            PredefinedNodeTypeTest.fail((String)e.getMessage());
        }
    }

    private static String getNodeTypeSpec(NodeType type, boolean propsVariant) throws RepositoryException {
        String typeName = type.getName();
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        writer.println("NodeTypeName");
        writer.println("  " + typeName);
        writer.println("IsMixin");
        writer.println("  " + type.isMixin());
        writer.println("HasOrderableChildNodes");
        writer.println("  " + type.hasOrderableChildNodes());
        writer.println("PrimaryItemName");
        writer.println("  " + type.getPrimaryItemName());
        NodeDefinition[] nodes = type.getDeclaredChildNodeDefinitions();
        Arrays.sort(nodes, NODE_DEF_COMPARATOR);
        for (int i = 0; i < nodes.length; ++i) {
            writer.print(PredefinedNodeTypeTest.getChildNodeDefSpec(nodes[i]));
        }
        PropertyDefinition[] properties = type.getDeclaredPropertyDefinitions();
        Arrays.sort(properties, PROPERTY_DEF_COMPARATOR);
        for (int i = 0; i < properties.length; ++i) {
            writer.print(PredefinedNodeTypeTest.getPropertyDefSpec(properties[i], propsVariant));
        }
        return buffer.toString();
    }

    private static String getChildNodeDefSpec(NodeDefinition node) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        writer.println("ChildNodeDefinition");
        if (node.getName().equals("*")) {
            writer.println("  Name \"*\"");
        } else {
            writer.println("  Name " + node.getName());
        }
        writer.print("  RequiredPrimaryTypes [");
        NodeType[] types = node.getRequiredPrimaryTypes();
        Arrays.sort(types, NODE_TYPE_COMPARATOR);
        for (int j = 0; j < types.length; ++j) {
            if (j > 0) {
                writer.print(',');
            }
            writer.print(types[j].getName());
        }
        writer.println("]");
        if (node.getDefaultPrimaryType() != null) {
            writer.println("  DefaultPrimaryType " + node.getDefaultPrimaryType().getName());
        } else {
            writer.println("  DefaultPrimaryType null");
        }
        writer.println("  AutoCreated " + node.isAutoCreated());
        writer.println("  Mandatory " + node.isMandatory());
        writer.println("  OnParentVersion " + OnParentVersionAction.nameFromValue((int)node.getOnParentVersion()));
        writer.println("  Protected " + node.isProtected());
        writer.println("  SameNameSiblings " + node.allowsSameNameSiblings());
        return buffer.toString();
    }

    private static String getPropertyDefSpec(PropertyDefinition property, boolean propsVariant) throws RepositoryException {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        writer.println("PropertyDefinition");
        if (property.getName().equals("*")) {
            writer.println("  Name \"*\"");
        } else {
            writer.println("  Name " + property.getName());
        }
        String type = PropertyType.nameFromValue((int)property.getRequiredType());
        writer.println("  RequiredType " + type.toUpperCase());
        Value[] values = property.getDefaultValues();
        if (values != null && values.length > 0) {
            writer.print("  DefaultValues [");
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    writer.print(',');
                }
                writer.print(values[j].getString());
            }
            writer.println("]");
        } else {
            writer.println("  DefaultValues null");
        }
        if (!propsVariant) {
            writer.println("  AutoCreated " + property.isAutoCreated());
        }
        writer.println("  Mandatory " + property.isMandatory());
        String action = OnParentVersionAction.nameFromValue((int)property.getOnParentVersion());
        if (!propsVariant) {
            writer.println("  OnParentVersion " + action);
        }
        writer.println("  Protected " + property.isProtected());
        writer.println("  Multiple " + property.isMultiple());
        return buffer.toString();
    }

    private String normalizeLineSeparators(String stringValue) {
        stringValue = stringValue.replaceAll("\r\n", "\n");
        stringValue = stringValue.replaceAll("\r", "\n");
        return stringValue;
    }

    static {
        SUPERTYPES.put("mix:created", new String[0]);
        SUPERTYPES.put("mix:etag", new String[0]);
        SUPERTYPES.put("mix:language", new String[0]);
        SUPERTYPES.put("mix:lastModified", new String[0]);
        SUPERTYPES.put("mix:lifecycle", new String[0]);
        SUPERTYPES.put("mix:lockable", new String[0]);
        SUPERTYPES.put("mix:mimeType", new String[0]);
        SUPERTYPES.put("mix:referenceable", new String[0]);
        SUPERTYPES.put("mix:shareable", new String[]{"mix:referenceable"});
        SUPERTYPES.put("mix:simpleVersionable", new String[0]);
        SUPERTYPES.put("mix:title", new String[0]);
        SUPERTYPES.put("mix:versionable", new String[]{"mix:referenceable", "mix:simpleVersionable"});
        SUPERTYPES.put("nt:activity", new String[]{"nt:base"});
        SUPERTYPES.put("nt:address", new String[]{"nt:base"});
        SUPERTYPES.put("nt:base", new String[0]);
        SUPERTYPES.put("nt:childNodeDefinition", new String[]{"nt:base"});
        SUPERTYPES.put("nt:configuration", new String[]{"nt:base"});
        SUPERTYPES.put("nt:file", new String[]{"nt:hierarchyNode"});
        SUPERTYPES.put("nt:folder", new String[]{"nt:hierarchyNode"});
        SUPERTYPES.put("nt:frozenNode", new String[]{"nt:base"});
        SUPERTYPES.put("nt:hierarchyNode", new String[]{"nt:base", "mix:created"});
        SUPERTYPES.put("nt:linkedFile", new String[]{"nt:hierarchyNode"});
        SUPERTYPES.put("nt:nodeType", new String[]{"nt:base"});
        SUPERTYPES.put("nt:propertyDefinition", new String[]{"nt:base"});
        SUPERTYPES.put("nt:query", new String[]{"nt:base"});
        SUPERTYPES.put("nt:resource", new String[]{"nt:base", "mix:lastModified", "mix:mimeType"});
        SUPERTYPES.put("nt:unstructured", new String[]{"nt:base"});
        SUPERTYPES.put("nt:version", new String[]{"nt:base", "mix:referenceable"});
        SUPERTYPES.put("nt:versionedChild", new String[]{"nt:base"});
        SUPERTYPES.put("nt:versionHistory", new String[]{"nt:base", "mix:referenceable"});
        SUPERTYPES.put("nt:versionLabels", new String[]{"nt:base"});
        NODE_DEF_COMPARATOR = new Comparator<NodeDefinition>(){

            @Override
            public int compare(NodeDefinition nda, NodeDefinition ndb) {
                if (nda.getName().equals("*") && !ndb.getName().equals("*")) {
                    return 1;
                }
                if (!nda.getName().equals("*") && ndb.getName().equals("*")) {
                    return -1;
                }
                return nda.getName().compareTo(ndb.getName());
            }
        };
        PROPERTY_DEF_COMPARATOR = new Comparator<PropertyDefinition>(){

            @Override
            public int compare(PropertyDefinition pda, PropertyDefinition pdb) {
                if (pda.getName().equals("*") && !pdb.getName().equals("*")) {
                    return 1;
                }
                if (!pda.getName().equals("*") && pdb.getName().equals("*")) {
                    return -1;
                }
                int result = pda.getName().compareTo(pdb.getName());
                if (result != 0) {
                    return result;
                }
                if (pda.isMultiple() && !pdb.isMultiple()) {
                    return 1;
                }
                if (!pda.isMultiple() && pdb.isMultiple()) {
                    return -1;
                }
                return 0;
            }
        };
        NODE_TYPE_COMPARATOR = new Comparator<NodeType>(){

            @Override
            public int compare(NodeType nta, NodeType ntb) {
                if (nta.isMixin() && !ntb.isMixin()) {
                    return 1;
                }
                if (!nta.isMixin() && ntb.isMixin()) {
                    return -1;
                }
                return nta.getName().compareTo(ntb.getName());
            }
        };
    }
}

