/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class GetReferencesNodeTest
extends AbstractJCRTest {
    private static final String PROP_VERSIONABLE_NODE_TYPE = "versionableNodeType";
    private String versionableNodeType;
    private Node testNode;
    private Node nodeToBeReferenced;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        super.checkSupportedOption("option.versioning.supported");
        this.versionableNodeType = this.getProperty(PROP_VERSIONABLE_NODE_TYPE);
        if (this.versionableNodeType == null) {
            GetReferencesNodeTest.fail((String)"Property 'versionableNodeType' is not defined.");
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.testRoot = null;
        this.nodeToBeReferenced = null;
        super.tearDown();
    }

    public void testGetReferencesNeverFromVersions() throws RepositoryException, NotExecutableException {
        this.initTestNodes();
        this.testNode.checkout();
        this.ensureCanSetProperty(this.testNode, this.propertyName1, 9, false);
        this.testNode.setProperty(this.propertyName1, this.nodeToBeReferenced);
        this.testRootNode.getSession().save();
        this.testNode.checkin();
        this.testNode.checkout();
        this.testNode.getProperty(this.propertyName1).remove();
        this.testRootNode.getSession().save();
        this.testNode.checkin();
        boolean nodeToBeReferencedIsReference = false;
        PropertyIterator propIter = this.nodeToBeReferenced.getReferences();
        while (propIter.hasNext()) {
            nodeToBeReferencedIsReference = true;
            GetReferencesNodeTest.fail((String)"Reference found in version.");
        }
        GetReferencesNodeTest.assertFalse((boolean)nodeToBeReferencedIsReference);
    }

    private void initTestNodes() throws RepositoryException, NotExecutableException {
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        this.ensureMixinType(this.testNode, this.mixVersionable);
        this.nodeToBeReferenced = this.testRootNode.addNode(this.nodeName2, this.versionableNodeType);
        this.testRootNode.getSession().save();
    }
}

