/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class WorkspaceRestoreTest
extends AbstractVersionTest {
    Session wSuperuser;
    Version version;
    Version version2;
    Version rootVersion;
    Node versionableNode2;
    Node wTestRoot;
    Node wVersionableNode;
    Node wVersionableNode2;
    Node wVersionableChildNode;
    Version wChildVersion;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        this.version = versionManager.checkin(path);
        versionManager.checkout(path);
        this.version2 = versionManager.checkin(path);
        versionManager.checkout(path);
        this.rootVersion = versionManager.getVersionHistory(path).getRootVersion();
        try {
            this.versionableNode2 = this.createVersionableNode(this.testRootNode, this.nodeName2, this.versionableNodeType);
        }
        catch (RepositoryException e) {
            WorkspaceRestoreTest.fail((String)("Failed to create a second versionable node: " + e.getMessage()));
        }
        try {
            this.wSuperuser = this.getHelper().getSuperuserSession(this.workspaceName);
        }
        catch (RepositoryException e) {
            WorkspaceRestoreTest.fail((String)("Failed to retrieve superuser session for second workspace '" + this.workspaceName + "': " + e.getMessage()));
        }
        try {
            this.testRootNode.getCorrespondingNodePath(this.workspaceName);
        }
        catch (ItemNotFoundException e) {
            this.wSuperuser.getWorkspace().clone(this.superuser.getWorkspace().getName(), this.testRoot, this.testRoot, true);
        }
        try {
            this.versionableNode.getCorrespondingNodePath(this.workspaceName);
        }
        catch (ItemNotFoundException e) {
            this.wSuperuser.getWorkspace().clone(this.superuser.getWorkspace().getName(), this.versionableNode.getPath(), this.versionableNode.getPath(), true);
        }
        try {
            this.versionableNode2.getCorrespondingNodePath(this.workspaceName);
        }
        catch (ItemNotFoundException e) {
            this.wSuperuser.getWorkspace().clone(this.superuser.getWorkspace().getName(), this.versionableNode2.getPath(), this.versionableNode2.getPath(), true);
        }
        try {
            this.wTestRoot = (Node)this.wSuperuser.getItem(this.testRootNode.getPath());
            this.wVersionableNode = this.wSuperuser.getNodeByIdentifier(this.versionableNode.getIdentifier());
            this.wVersionableNode.getSession().getWorkspace().getVersionManager().checkout(this.wVersionableNode.getPath());
            this.wVersionableNode2 = this.wSuperuser.getNodeByIdentifier(this.versionableNode2.getIdentifier());
            this.wVersionableNode2.getSession().getWorkspace().getVersionManager().checkout(this.wVersionableNode2.getPath());
        }
        catch (RepositoryException e) {
            WorkspaceRestoreTest.fail((String)("Failed to setup test environment in workspace: " + e.toString()));
        }
        try {
            this.wVersionableChildNode = this.createVersionableNode(this.wVersionableNode, this.nodeName4, this.versionableNodeType);
        }
        catch (RepositoryException e) {
            WorkspaceRestoreTest.fail((String)("Failed to create versionable child node in second workspace: " + e.getMessage()));
        }
        VersionManager wVersionManager = this.wVersionableChildNode.getSession().getWorkspace().getVersionManager();
        String wPath = this.wVersionableChildNode.getPath();
        wVersionManager.checkout(wPath);
        this.wChildVersion = wVersionManager.checkin(wPath);
        wVersionManager.checkout(wPath);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.versionableNode2.remove();
            this.wVersionableNode.remove();
            this.wVersionableNode2.remove();
            this.wTestRoot.save();
        }
        finally {
            if (this.wSuperuser != null) {
                this.wSuperuser.logout();
                this.wSuperuser = null;
            }
            this.version = null;
            this.version2 = null;
            this.rootVersion = null;
            this.versionableNode2 = null;
            this.wTestRoot = null;
            this.wVersionableNode = null;
            this.wVersionableNode2 = null;
            this.wVersionableChildNode = null;
            this.wChildVersion = null;
            super.tearDown();
        }
    }

    public void testWorkspaceRestoreWithPendingChanges() throws RepositoryException {
        this.versionableNode.checkout();
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            Version v = this.wVersionableNode.checkin();
            this.superuser.getWorkspace().restore(new Version[]{v}, false);
            WorkspaceRestoreTest.fail((String)"InvalidItemStateException must be thrown on attempt to call Workspace.restore(Version[], boolean) in a session having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testWorkspaceRestoreWithPendingChangesJcr2() throws RepositoryException {
        this.versionableNode.getSession().getWorkspace().getVersionManager().checkout(this.versionableNode.getPath());
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            Version v = this.wVersionableNode.getSession().getWorkspace().getVersionManager().checkin(this.wVersionableNode.getPath());
            this.superuser.getWorkspace().getVersionManager().restore(new Version[]{v}, false);
            WorkspaceRestoreTest.fail((String)"InvalidItemStateException must be thrown on attempt to call Workspace.restore(Version[], boolean) in a session having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testWorkspaceRestoreHasCorrespondingNode() throws RepositoryException {
        try {
            this.superuser.getWorkspace().restore(new Version[]{this.wChildVersion}, false);
            WorkspaceRestoreTest.fail((String)"Workspace.restore(Version[], boolean) must throw VersionException if non of the specified versions has a corresponding node in the workspace.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testWorkspaceRestoreHasCorrespondingNodeJcr2() throws RepositoryException {
        try {
            this.superuser.getWorkspace().getVersionManager().restore(new Version[]{this.wChildVersion}, false);
            WorkspaceRestoreTest.fail((String)"Workspace.restore(Version[], boolean) must throw VersionException if non of the specified versions has a corresponding node in the workspace.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testWorkspaceRestoreWithParent() throws RepositoryException {
        try {
            Version parentV = this.wVersionableNode.checkin();
            this.superuser.getWorkspace().restore(new Version[]{parentV, this.wChildVersion}, false);
        }
        catch (RepositoryException e) {
            WorkspaceRestoreTest.fail((String)"Workspace.restore(Version[], boolean) with a version that has no corresponding node must succeed if a version of a parent with correspondance is present in the version array.");
        }
    }

    public void testWorkspaceRestoreWithParentJcr2() throws RepositoryException {
        try {
            Version parentV = this.wVersionableNode.getSession().getWorkspace().getVersionManager().checkin(this.wVersionableNode.getPath());
            this.superuser.getWorkspace().getVersionManager().restore(new Version[]{parentV, this.wChildVersion}, false);
        }
        catch (RepositoryException e) {
            WorkspaceRestoreTest.fail((String)"Workspace.restore(Version[], boolean) with a version that has no corresponding node must succeed if a version of a parent with correspondance is present in the version array.");
        }
    }

    public void testWorkspaceRestoreWithRemoveExisting() throws NotExecutableException, RepositoryException {
        this.superuser.getWorkspace().clone(this.workspaceName, this.wVersionableChildNode.getPath(), this.wVersionableChildNode.getPath(), false);
        Version parentV = this.versionableNode.checkin();
        String newChildPath = this.wVersionableNode2.getPath() + "/" + this.wVersionableChildNode.getName();
        this.wSuperuser.move(this.wVersionableChildNode.getPath(), newChildPath);
        this.wSuperuser.save();
        this.wSuperuser.getWorkspace().restore(new Version[]{parentV}, true);
        if (this.wSuperuser.itemExists(newChildPath)) {
            WorkspaceRestoreTest.fail((String)"Workspace.restore(Version[], boolean) with the boolean flag set to true, must remove the existing node in case of Uuid conflict.");
        }
    }

    public void testWorkspaceRestoreWithRemoveExistingJcr2() throws NotExecutableException, RepositoryException {
        this.superuser.getWorkspace().clone(this.workspaceName, this.wVersionableChildNode.getPath(), this.wVersionableChildNode.getPath(), false);
        Version parentV = this.versionableNode.getSession().getWorkspace().getVersionManager().checkin(this.versionableNode.getPath());
        String newChildPath = this.wVersionableNode2.getPath() + "/" + this.wVersionableChildNode.getName();
        this.wSuperuser.move(this.wVersionableChildNode.getPath(), newChildPath);
        this.wSuperuser.save();
        this.wSuperuser.getWorkspace().getVersionManager().restore(new Version[]{parentV}, true);
        if (this.wSuperuser.itemExists(newChildPath)) {
            WorkspaceRestoreTest.fail((String)"Workspace.restore(Version[], boolean) with the boolean flag set to true, must remove the existing node in case of Uuid conflict.");
        }
    }

    public void testWorkspaceRestoreWithUUIDConflict() throws RepositoryException, NotExecutableException {
        try {
            NodeDefinition nd = this.wVersionableNode.getDefinition();
            if (nd.getOnParentVersion() != 1 && nd.getOnParentVersion() != 2) {
                throw new NotExecutableException("Nodes must be versionable in order to run this test.");
            }
            Version v = this.wVersionableNode.checkin();
            this.wVersionableNode.checkout();
            this.wSuperuser.move(this.wVersionableChildNode.getPath(), this.wVersionableNode2.getPath() + "/" + this.wVersionableChildNode.getName());
            this.wSuperuser.save();
            this.wSuperuser.getWorkspace().restore(new Version[]{v}, false);
            WorkspaceRestoreTest.fail((String)"Node.restore( Version, boolean ): An ItemExistsException must be thrown if the node to be restored already exsits and removeExisting was set to false.");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testWorkspaceRestoreWithUUIDConflictJcr2() throws RepositoryException, NotExecutableException {
        try {
            NodeDefinition nd = this.wVersionableNode.getDefinition();
            if (nd.getOnParentVersion() != 1 && nd.getOnParentVersion() != 2) {
                throw new NotExecutableException("Nodes must be versionable in order to run this test.");
            }
            VersionManager versionManager = this.wVersionableNode.getSession().getWorkspace().getVersionManager();
            String path = this.wVersionableNode.getPath();
            Version v = versionManager.checkin(path);
            versionManager.checkout(path);
            this.wSuperuser.move(this.wVersionableChildNode.getPath(), this.wVersionableNode2.getPath() + "/" + this.wVersionableChildNode.getName());
            this.wSuperuser.save();
            this.wSuperuser.getWorkspace().getVersionManager().restore(new Version[]{v}, false);
            WorkspaceRestoreTest.fail((String)"Node.restore( Version, boolean ): An ItemExistsException must be thrown if the node to be restored already exsits and removeExisting was set to false.");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testWorkspaceRestoreOnCheckedInNode() throws RepositoryException {
        if (this.versionableNode.isCheckedOut()) {
            this.versionableNode.checkin();
        }
        this.superuser.getWorkspace().restore(new Version[]{this.version}, true);
    }

    public void testWorkspaceRestoreOnCheckedInNodeJcr2() throws RepositoryException {
        String path;
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        if (versionManager.isCheckedOut(path = this.versionableNode.getPath())) {
            versionManager.checkin(path);
        }
        this.superuser.getWorkspace().getVersionManager().restore(new Version[]{this.version}, true);
    }

    public void testWorkspaceRestoreOnCheckedOutNode() throws RepositoryException {
        if (!this.versionableNode.isCheckedOut()) {
            this.versionableNode.checkout();
        }
        this.superuser.getWorkspace().restore(new Version[]{this.version}, true);
    }

    public void testWorkspaceRestoreOnCheckedOutNodeJcr2() throws RepositoryException {
        String path;
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        if (!versionManager.isCheckedOut(path = this.versionableNode.getPath())) {
            versionManager.checkout(path);
        }
        this.superuser.getWorkspace().getVersionManager().restore(new Version[]{this.version}, true);
    }
}

