/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.test.RepositoryHelper;
import org.apache.jackrabbit.test.RepositoryHelperPool;

public class RepositoryHelperPoolImpl
implements RepositoryHelperPool {
    private static final String PROP_FILE = "repositoryHelperPool.properties";
    private List<RepositoryHelper> helpers = new LinkedList<RepositoryHelper>();
    private static RepositoryHelperPool POOL = null;

    public static synchronized RepositoryHelperPool getInstance() {
        if (POOL == null) {
            POOL = new RepositoryHelperPoolImpl();
        }
        return POOL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryHelperPoolImpl() {
        InputStream in = RepositoryHelperPoolImpl.class.getClassLoader().getResourceAsStream(PROP_FILE);
        if (in != null) {
            try {
                Properties props = new Properties();
                props.load(in);
                int i = 0;
                while (true) {
                    String prefix = "helper." + i + ".";
                    HashMap<String, Object> helperProp = new HashMap<String, Object>();
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.startsWith(prefix)) continue;
                        helperProp.put(key.substring(prefix.length()), entry.getValue());
                    }
                    if (helperProp.isEmpty()) {
                        break;
                    }
                    this.addHelper(new RepositoryHelper(helperProp));
                    ++i;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.helpers.isEmpty()) {
            this.addHelper(new RepositoryHelper());
        }
    }

    public synchronized void addHelper(RepositoryHelper helper) {
        this.helpers.add(helper);
    }

    @Override
    public synchronized RepositoryHelper borrowHelper() throws InterruptedException {
        while (this.helpers.isEmpty()) {
            this.wait();
        }
        return this.helpers.remove(0);
    }

    @Override
    public synchronized RepositoryHelper[] borrowHelpers() throws InterruptedException {
        while (this.helpers.isEmpty()) {
            this.wait();
        }
        try {
            RepositoryHelper[] repositoryHelperArray = this.helpers.toArray(new RepositoryHelper[this.helpers.size()]);
            return repositoryHelperArray;
        }
        finally {
            this.helpers.clear();
        }
    }

    @Override
    public synchronized void returnHelper(RepositoryHelper helper) {
        this.helpers.add(helper);
        this.notifyAll();
    }
}

