/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class PathPropertyTest
extends AbstractPropertyTest {
    @Override
    protected int getPropertyType() {
        return 8;
    }

    @Override
    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    public void testGetString() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        PathPropertyTest.assertTrue((String)("Not a valid Path property: " + this.prop.getName()), (boolean)PropertyUtil.checkPathFormat(val.getString(), this.session));
    }

    public void testGetBoolean() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getBoolean();
            PathPropertyTest.fail((String)"Conversion from a Path value to a Boolean value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDate() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDate();
            PathPropertyTest.fail((String)"Conversion from a Path value to a Date value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDouble() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getDouble();
            PathPropertyTest.fail((String)"Conversion from a Path value to a Double value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLong() throws RepositoryException {
        try {
            Value val = PropertyUtil.getValue(this.prop);
            val.getLong();
            PathPropertyTest.fail((String)"Conversion from a Path value to a Long value should throw a ValueFormatException.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetType() throws RepositoryException {
        PathPropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 8));
    }

    public void testGetNode() throws RepositoryException {
        if (!this.multiple) {
            Object nodePath = this.prop.getParent().getPath();
            String propName = this.prop.getName();
            this.prop.getParent().setProperty(propName, (String)nodePath, 8);
            String value = this.prop.getString();
            Node n = this.prop.getNode();
            PathPropertyTest.assertEquals((String)"The path of the dereferenced property must be equal to the value", (String)n.getPath(), (String)value);
            PathPropertyTest.assertTrue((String)"The property value must be resolved to the correct node.", (boolean)this.prop.getParent().isSame((Item)n));
            this.prop.getParent().setProperty(propName, ".", 8);
            n = this.prop.getNode();
            PathPropertyTest.assertTrue((String)"The property value must be resolved to the correct node.", (boolean)this.prop.getParent().getNode(".").isSame((Item)n));
            while (this.session.nodeExists((String)nodePath)) {
                nodePath = (String)nodePath + "x";
            }
            this.prop.getParent().setProperty(propName, (String)nodePath, 8);
            try {
                this.prop.getNode();
                PathPropertyTest.fail((String)"Calling Property.getNode() for a PATH value that doesn't have a corresponding Node, ItemNotFoundException is expected");
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        } else {
            try {
                this.prop.getNode();
                PathPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetProperty() throws RepositoryException {
        if (!this.multiple) {
            Object propPath = this.prop.getPath();
            String propName = this.prop.getName();
            this.prop.getParent().setProperty(propName, (String)propPath, 8);
            String path = this.prop.getString();
            Property p = this.prop.getProperty();
            PathPropertyTest.assertEquals((String)"The path of the dereferenced property must be equal to the value", (String)path, (String)p.getPath());
            PathPropertyTest.assertTrue((String)"The property value must be resolved to the correct property.", (boolean)this.prop.isSame((Item)p));
            this.prop.getParent().setProperty(propName, propName, 8);
            path = this.prop.getString();
            p = this.prop.getProperty();
            PathPropertyTest.assertEquals((String)"The path of the dereferenced property must be equal to the value", (String)path, (String)p.getName());
            PathPropertyTest.assertTrue((String)"The property value must be resolved to the correct property.", (boolean)this.prop.getParent().getProperty(path).isSame((Item)p));
            while (this.session.propertyExists((String)propPath)) {
                propPath = (String)propPath + "x";
            }
            this.prop.getParent().setProperty(propName, (String)propPath, 8);
            try {
                this.prop.getProperty();
                PathPropertyTest.fail((String)"Calling Property.getProperty() for a PATH value that doesn't have a corresponding Property, ItemNotFoundException is expected");
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        } else {
            try {
                this.prop.getProperty();
                PathPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }
}

