/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import junit.framework.Assert;
import org.apache.jackrabbit.test.api.SerializationContext;

class TreeComparator
extends Assert {
    public SerializationContext sc;
    public final boolean WORKSPACE = true;
    public final boolean SESSION = false;
    public final int CHECK_EMPTY = -1;
    public final int IGNORE = 0;
    public final int CHECK_SAME = 1;
    public int check = 1;
    private Session session;
    private Workspace workspace;
    public boolean skipBinary = false;
    public boolean noRecurse = false;
    public String sourceFolder;
    public String targetFolder;
    public String root;

    public TreeComparator(SerializationContext sc, Session s) throws Exception {
        this.sc = sc;
        this.session = s;
        this.workspace = this.session.getWorkspace();
        this.init();
    }

    public void setSession(Session session) {
        this.session = session;
    }

    private void init() throws RepositoryException {
        this.root = this.sc.testroot;
        this.sourceFolder = this.root + "/" + this.sc.sourceFolderName;
        this.targetFolder = this.root + "/" + this.sc.targetFolderName;
        try {
            this.session.getItem(this.sourceFolder).remove();
            this.session.save();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            Item tgt = this.session.getItem(this.targetFolder);
            tgt.remove();
            this.session.save();
        }
        catch (PathNotFoundException tgt) {
            // empty catch block
        }
        Node rootNode = (Node)this.session.getItem(this.root);
        rootNode.addNode(this.sc.sourceFolderName);
        rootNode.addNode(this.sc.targetFolderName);
        this.session.save();
    }

    public void createExampleTree() {
        this.createExampleTree(true);
    }

    public void createExampleTree(boolean save) {
        try {
            Node src = (Node)this.session.getItem(this.sourceFolder);
            Node root = src.addNode(this.sc.rootNodeName);
            root.addNode(this.sc.nodeName1);
            root.addNode(this.sc.nodeName2, this.sc.testNodeType);
            byte[] byteArray = new byte[]{0, -1, -89, 100, 21, 6, 19, 71, -35};
            root.setProperty(this.sc.propertyName1, (InputStream)new ByteArrayInputStream(byteArray));
            root.setProperty(this.sc.nodeName3, "hello");
        }
        catch (Exception e) {
            this.sc.log("Error while creating example tree: " + e.getMessage());
        }
        if (save) {
            try {
                this.session.save();
            }
            catch (RepositoryException e) {
                TreeComparator.fail((String)("Cannot save the example tree to the repository: " + e));
            }
        }
    }

    public void createComplexTree() {
        this.createComplexTree(true);
    }

    public void createComplexTree(boolean save) {
        Node rootNode = null;
        Node nt = null;
        Node pt = null;
        Node mvp = null;
        Node referenceable = null;
        try {
            Node src = (Node)this.session.getItem(this.sourceFolder);
            rootNode = src.addNode(this.sc.rootNodeName);
            nt = rootNode.addNode(this.sc.nodeTypesTestNode);
            rootNode.addNode(this.sc.mixinTypeTestNode);
            pt = rootNode.addNode(this.sc.propertyTypesTestNode);
            rootNode.addNode(this.sc.sameNameChildrenTestNode);
            mvp = rootNode.addNode(this.sc.multiValuePropertiesTestNode);
            referenceable = rootNode.addNode(this.sc.referenceableNodeTestNode);
            rootNode.addNode(this.sc.orderChildrenTestNode);
            rootNode.addNode(this.sc.namespaceTestNode);
        }
        catch (RepositoryException e) {
            this.sc.log("Error while creating example tree: " + e.getMessage());
        }
        NodeTypeManager ntmgr = null;
        NodeTypeIterator types = null;
        try {
            ntmgr = this.workspace.getNodeTypeManager();
            types = ntmgr.getMixinNodeTypes();
        }
        catch (RepositoryException e) {
            TreeComparator.fail((String)("Cannot access NodeType iterator: " + e));
        }
        while (types.hasNext()) {
            NodeType t = (NodeType)types.next();
            Object name = t.getName();
            name = "Node_" + ((String)name).replaceAll(":", "_");
            Node n = null;
            try {
                n = nt.addNode((String)name);
                n.addMixin(t.getName());
                this.session.save();
            }
            catch (RepositoryException e) {
                this.sc.log("Cannot create node with mixin node type: " + e);
                try {
                    if (n == null) continue;
                    n.remove();
                }
                catch (RepositoryException e1) {
                    this.sc.log("Could not remove node: " + e);
                }
            }
        }
        try {
            pt.setProperty(this.sc.stringTestProperty, "This is a string.");
            byte[] byteArray = new byte[]{0, -1, -89, 100, 21, 6, 19, 71, -35};
            pt.setProperty(this.sc.binaryTestProperty, (InputStream)new ByteArrayInputStream(byteArray));
            Calendar c = Calendar.getInstance();
            c.set(2005, 6, 21, 13, 30, 5);
            pt.setProperty(this.sc.dateTestProperty, c);
            pt.setProperty(this.sc.longTestProperty, 0L);
            pt.setProperty(this.sc.doubleTestProperty, Math.PI);
            pt.setProperty(this.sc.booleanTestProperty, true);
            pt.setProperty(this.sc.nameTestProperty, this.session.getValueFactory().createValue(this.sc.jcrPrimaryType, 7));
            pt.setProperty(this.sc.pathTestProperty, this.session.getValueFactory().createValue("paths/dont/have/to/point/anywhere", 8));
            this.sc.ensureMixinType(referenceable, this.sc.mixReferenceable);
            this.session.save();
            pt.setProperty(this.sc.referenceTestProperty, referenceable);
            rootNode.setProperty(this.sc.binaryTestProperty, (InputStream)new ByteArrayInputStream(byteArray));
            this.session.save();
        }
        catch (Exception e) {
            TreeComparator.fail((String)("Could not add property: " + e));
        }
        String[] s = new String[]{"one", "two", "three"};
        try {
            mvp.setProperty(this.sc.multiValueTestProperty, s);
            this.session.save();
        }
        catch (RepositoryException e) {
            this.sc.log("Could not create multi-value property: " + e);
        }
        if (save) {
            try {
                this.session.save();
            }
            catch (RepositoryException e) {
                TreeComparator.fail((String)("Cannot save the example tree to the repository: " + e));
            }
        }
    }

    public void compare(boolean skipBinary, boolean noRecurse) {
        this.skipBinary = skipBinary;
        this.noRecurse = noRecurse;
        this.compare();
    }

    public void compare() {
        this.compare(1);
    }

    public void compare(int check) {
        this.check = check;
        this.compare(this.sourceFolder + "/" + this.sc.rootNodeName, 0);
    }

    public void compare(String sourcePath, int level) {
        Node source = null;
        Node target = null;
        try {
            source = (Node)this.session.getItem(sourcePath);
        }
        catch (RepositoryException e) {
            TreeComparator.fail((String)("Could not read source node " + sourcePath + ": " + e.getMessage()));
        }
        String targetPath = this.getTargetPath(sourcePath);
        try {
            this.session.getItem(this.targetFolder);
        }
        catch (RepositoryException e) {
            TreeComparator.fail((String)("Target folder not found: " + e));
        }
        if (this.noRecurse && level == 1) {
            this.check = -1;
        }
        if (this.check == 1) {
            try {
                target = (Node)this.session.getItem(targetPath);
            }
            catch (RepositoryException e) {
                this.showTree();
                TreeComparator.fail((String)("Could not read target node " + targetPath + ": " + e));
            }
            this.compareNodes(source, target);
        } else if (this.check == -1) {
            try {
                this.session.getItem(targetPath);
                TreeComparator.fail((String)("The item " + targetPath + " must not be available."));
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        try {
            NodeIterator ni = source.getNodes();
            while (ni.hasNext()) {
                Node n = (Node)ni.next();
                this.compare(n.getPath(), level + 1);
            }
        }
        catch (RepositoryException e) {
            TreeComparator.fail((String)("Error while iterating through child nodes: " + e));
        }
    }

    public void compareNodes(Node a, Node b) {
        try {
            this.sc.log("Comparing " + a.getPath() + " to " + b.getPath());
        }
        catch (RepositoryException e) {
            TreeComparator.fail((String)("Nodes not available: " + e.getMessage()));
        }
        String primaryTypeA = null;
        String primaryTypeB = null;
        try {
            primaryTypeA = a.getProperty(this.sc.jcrPrimaryType).getName();
            primaryTypeB = b.getProperty(this.sc.jcrPrimaryType).getName();
        }
        catch (RepositoryException e) {
            TreeComparator.fail((String)("Primary node type not available: " + e));
        }
        TreeComparator.assertEquals((String)"Primary node type has changed.", (String)primaryTypeA, primaryTypeB);
        this.compareProperties(a, b);
    }

    public void compareProperties(Node a, Node b) {
        PropertyIterator ai = null;
        try {
            ai = a.getProperties();
        }
        catch (RepositoryException e) {
            TreeComparator.fail((String)("Cannot access properties: " + e));
        }
        while (ai.hasNext()) {
            Property pa = (Property)ai.next();
            String pName = null;
            String pPath = null;
            try {
                pPath = pa.getPath();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            int pType = 0;
            try {
                pName = pa.getName();
                pType = pa.getDefinition().isMultiple() ? -9999 : pa.getValue().getType();
            }
            catch (RepositoryException e) {
                TreeComparator.fail((String)("Cannot access property information: " + e));
            }
            if (this.propertyValueMayChange(pName)) continue;
            Property pb = null;
            if (this.propertySkipped(pName)) continue;
            try {
                pb = b.getProperty(pName);
            }
            catch (RepositoryException e) {
                TreeComparator.fail((String)("Property '" + pPath + "' not available: " + e));
            }
            if (this.skipBinary && pType == 2) continue;
            this.compareProperties(pa, pb);
        }
    }

    public void compareProperties(Property a, Property b) {
        String nodeName = null;
        String propertyName = null;
        boolean isMultiple = false;
        try {
            nodeName = a.getParent().getName();
            propertyName = a.getName();
            isMultiple = a.getDefinition().isMultiple();
        }
        catch (RepositoryException e) {
            TreeComparator.fail((String)("Cannot access property information: " + e));
        }
        if (!this.propertyValueMayChange(propertyName)) {
            if (isMultiple) {
                try {
                    this.compareValues(nodeName, propertyName, a.getValues(), b.getValues());
                }
                catch (RepositoryException e) {
                    TreeComparator.fail((String)("Could not access property values: " + e));
                }
            } else {
                try {
                    this.compareValue(nodeName, propertyName, a.getValue(), b.getValue());
                }
                catch (RepositoryException e) {
                    TreeComparator.fail((String)("Could not access property value: " + e));
                }
            }
        }
    }

    public void compareValues(String n, String p, Value[] a, Value[] b) {
        TreeComparator.assertEquals((String)("Multi-value property '" + p + "' of node '" + n + "' has changed length: "), (int)a.length, (int)b.length);
        for (int t = 0; t < a.length; ++t) {
            this.compareValue(n, p, a[t], b[t]);
        }
    }

    public void compareValue(String n, String p, Value a, Value b) {
        if (!this.propertyValueMayChange(p)) {
            try {
                TreeComparator.assertEquals((String)("Properties '" + p + "' of node '" + n + "' have different values."), (String)a.getString(), (String)b.getString());
            }
            catch (RepositoryException e) {
                TreeComparator.fail((String)("Cannot access the content of the property value: " + e));
            }
        }
    }

    public boolean propertyValueMayChange(String propertyName) {
        return this.sc.propertyValueMayChange.indexOf(" " + propertyName + " ") >= 0;
    }

    public String getSourceRootPath() {
        return this.sourceFolder + "/" + this.sc.rootNodeName;
    }

    private String getTargetPath(String sourcePath) {
        String targetPath = sourcePath.replaceAll(this.sourceFolder, this.targetFolder);
        return targetPath;
    }

    public void showTree() {
        Node n = null;
        try {
            n = (Node)this.session.getItem(this.sc.testroot);
            this.showTree(n, 0);
        }
        catch (RepositoryException e) {
            this.sc.log("Cannot display tree diagnostics: " + e);
        }
    }

    public void showTree(Node n, int level) throws RepositoryException {
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < level; ++t) {
            sb.append("-");
        }
        sb.append(n.getName() + " ");
        sb.append(n.getPrimaryNodeType().getName() + " [ ");
        PropertyIterator pi = n.getProperties();
        while (pi.hasNext()) {
            Property p = (Property)pi.next();
            sb.append(p.getName() + " ");
        }
        sb.append("]");
        this.sc.log(sb.toString());
        NodeIterator ni = n.getNodes();
        while (ni.hasNext()) {
            this.showTree((Node)ni.next(), level + 1);
        }
    }

    public boolean propertySkipped(String propertyName) {
        return this.sc.propertySkipped.indexOf(" " + propertyName + " ") >= 0;
    }
}

