/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.lock;

import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class LockTest
extends AbstractJCRTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddRemoveLockToken() throws Exception {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n, this.mixLockable);
        this.testRootNode.getSession().save();
        Lock lock = n.lock(false, false);
        String lockToken = lock.getLockToken();
        try {
            LockTest.assertNotNull((String)"session must get a non-null lock token", (Object)lockToken);
            LockTest.assertTrue((String)"session must hold lock token", (boolean)this.containsLockToken(this.superuser, lockToken));
            this.superuser.removeLockToken(lockToken);
            String nlt = lock.getLockToken();
            LockTest.assertTrue((String)"freshly obtained lock token must either be null or the same as the one returned earlier", (nlt == null || nlt.equals(lockToken) ? 1 : 0) != 0);
            LockTest.assertFalse((String)"session must not hold lock token", (boolean)this.containsLockToken(this.superuser, lockToken));
            try {
                n.addNode(this.nodeName2, this.testNodeType);
                LockTest.fail((String)"session unable to modify node");
            }
            catch (LockException lockException) {
                // empty catch block
            }
            this.superuser.addLockToken(lockToken);
            LockTest.assertNotNull((String)"session must get a non-null lock token", (Object)lock.getLockToken());
            LockTest.assertTrue((String)"session must hold lock token", (boolean)this.containsLockToken(this.superuser, lock.getLockToken()));
            n.addNode(this.nodeName2, this.testNodeType);
        }
        finally {
            this.superuser.addLockToken(lockToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeLocked() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        this.testRootNode.getSession().save();
        Lock lock = n1.lock(false, true);
        LockTest.assertTrue((String)"Lock must be live", (boolean)lock.isLive());
        Session otherSuperuser = this.getHelper().getSuperuserSession();
        try {
            Node n2 = (Node)otherSuperuser.getItem(n1.getPath());
            LockTest.assertNull((String)"Lock token must be null for other session", (Object)n2.getLock().getLockToken());
            try {
                n2.addNode(this.nodeName2, this.testNodeType);
                LockTest.fail((String)"modifying same node in other session must fail");
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
        finally {
            otherSuperuser.logout();
        }
    }

    public void testGetNode() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        Node n1Sub = n1.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1Sub, this.mixLockable);
        this.testRootNode.getSession().save();
        n1.lock(true, true);
        LockTest.assertEquals((String)"getNode() must return the lock holder", (String)n1.getPath(), (String)n1.getLock().getNode().getPath());
        LockTest.assertEquals((String)"getNode() must return the lock holder", (String)n1.getPath(), (String)n1Sub.getLock().getNode().getPath());
        n1.unlock();
    }

    public void testGetLockOwnerProperty() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        this.testRootNode.getSession().save();
        Lock lock = n1.lock(false, true);
        if (n1.getSession().getUserID() == null) {
            LockTest.assertFalse((String)"jcr:lockOwner must not exist if Session.getUserId() returns null", (boolean)n1.hasProperty(this.jcrLockOwner));
        } else {
            LockTest.assertEquals((String)("getLockOwner() must return the same value as stored in property " + this.jcrLockOwner + " of the lock holding node"), (String)n1.getProperty(this.jcrLockOwner).getString(), (String)lock.getLockOwner());
        }
        n1.unlock();
    }

    public void testGetLockOwner() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        this.testRootNode.getSession().save();
        Lock lock = n1.lock(false, true);
        LockTest.assertEquals((String)"getLockOwner() must return the same value as returned by Session.getUserId at the time that the lock was placed", (String)this.testRootNode.getSession().getUserID(), (String)lock.getLockOwner());
        n1.unlock();
    }

    public void testShallowLock() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        Node n2 = n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.getSession().save();
        n1.lock(false, true);
        LockTest.assertFalse((String)"Shallow lock must not lock the child nodes of a node.", (boolean)n2.isLocked());
    }

    public void testCheckedIn() throws NotExecutableException, RepositoryException {
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException("Versioning is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(node, this.mixLockable);
        this.ensureMixinType(node, this.mixVersionable);
        this.testRootNode.getSession().save();
        node.checkin();
        try {
            node.lock(false, false);
        }
        catch (RepositoryException ex) {
            node.lock(true, false);
        }
        LockTest.assertTrue((String)"Locking of a checked-in node failed.", (boolean)node.isLocked());
        node.unlock();
        LockTest.assertFalse((String)"Unlocking of a checked-in node failed.", (boolean)node.isLocked());
    }

    public void testParentChildLock() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        Node n2 = n1.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(n2, this.mixLockable);
        this.testRootNode.getSession().save();
        n1.lock(false, true);
        n2.lock(false, true);
        n1.unlock();
        LockTest.assertTrue((String)"child node must still hold lock", (boolean)n2.holdsLock());
    }

    public void testParentChildDeepLock() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        Node n2 = n1.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(n2, this.mixLockable);
        this.testRootNode.getSession().save();
        n2.lock(false, true);
        try {
            n1.lock(true, true);
            LockTest.fail((String)"unable to deep lock parent node");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testIsDeep() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(n2, this.mixLockable);
        this.testRootNode.getSession().save();
        Lock lock1 = n1.lock(false, true);
        LockTest.assertFalse((String)"Lock.isDeep() must be false if the lock has not been set as not deep", (boolean)lock1.isDeep());
        Lock lock2 = n2.lock(true, true);
        LockTest.assertTrue((String)"Lock.isDeep() must be true if the lock has been set as deep", (boolean)lock2.isDeep());
    }

    public void testIsSessionScoped() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(n2, this.mixLockable);
        this.testRootNode.getSession().save();
        Lock lock1 = n1.lock(false, true);
        LockTest.assertTrue((String)"Lock.isSessionScoped() must be true if the lock is session-scoped", (boolean)lock1.isSessionScoped());
        Lock lock2 = n2.lock(false, false);
        LockTest.assertFalse((String)"Lock.isSessionScoped() must be false if the lock is open-scoped", (boolean)lock2.isSessionScoped());
        n2.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogout() throws Exception {
        Lock lock;
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        this.testRootNode.getSession().save();
        Session otherSuperuser = this.getHelper().getSuperuserSession();
        try {
            Node n2 = (Node)otherSuperuser.getItem(n1.getPath());
            lock = n2.lock(false, true);
            LockTest.assertTrue((String)"lock must be alive", (boolean)lock.isLive());
            n1.refresh(false);
            LockTest.assertTrue((String)"node must be locked", (boolean)n1.isLocked());
        }
        finally {
            otherSuperuser.logout();
        }
        LockTest.assertFalse((String)"lock must not be alive", (boolean)lock.isLive());
        n1.getSession().refresh(true);
        LockTest.assertFalse((String)"node must not be locked", (boolean)n1.isLocked());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockTransfer() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        this.testRootNode.getSession().save();
        Session otherSuperuser = this.getHelper().getSuperuserSession();
        try {
            Node n2 = (Node)otherSuperuser.getItem(n1.getPath());
            Lock lock = n2.lock(false, false);
            LockTest.assertNotNull((String)"user must get non-null token", (Object)lock.getLockToken());
            String lockToken = lock.getLockToken();
            otherSuperuser.removeLockToken(lockToken);
            this.superuser.addLockToken(lockToken);
            String nlt = lock.getLockToken();
            LockTest.assertTrue((String)"freshly obtained lock token must either be null or the same as the one returned earlier", (nlt == null || nlt.equals(lockToken) ? 1 : 0) != 0);
            LockTest.assertNotNull((String)"user must get non-null token", (Object)n1.getLock().getLockToken());
        }
        finally {
            otherSuperuser.logout();
            n1.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpenScopedLocks() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        this.testRootNode.getSession().save();
        Session otherSuperuser = this.getHelper().getSuperuserSession();
        try {
            Node n2 = (Node)otherSuperuser.getItem(n1.getPath());
            Lock lock = n2.lock(false, false);
            String lockToken = lock.getLockToken();
            otherSuperuser.removeLockToken(lockToken);
            this.superuser.addLockToken(lockToken);
        }
        finally {
            otherSuperuser.logout();
        }
        LockTest.assertTrue((boolean)n1.isLocked());
    }

    public void testRefresh() throws Exception {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n, this.mixLockable);
        this.testRootNode.getSession().save();
        Lock lock = n.lock(false, true);
        LockTest.assertTrue((String)"lock must be alive", (boolean)lock.isLive());
        lock.refresh();
        n.unlock();
        LockTest.assertFalse((String)"lock must not be alive", (boolean)lock.isLive());
    }

    public void testRefreshNotLive() throws Exception {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n, this.mixLockable);
        this.testRootNode.getSession().save();
        Lock lock = n.lock(false, true);
        LockTest.assertTrue((String)"lock must be alive", (boolean)lock.isLive());
        n.unlock();
        LockTest.assertFalse((String)"lock must not be alive", (boolean)lock.isLive());
        try {
            lock.refresh();
            LockTest.fail((String)"Refresh on a lock that is not alive must fail");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testGetLock() throws Exception {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(n1, this.mixLockable);
        Node n2 = n1.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(n2, this.mixLockable);
        this.testRootNode.getSession().save();
        n1.lock(true, true);
        Lock lock = n2.getLock();
        LockTest.assertTrue((String)"lock holding node must be parent", (boolean)lock.getNode().isSame((Item)n1));
    }

    public void testCheckedInUnlock() throws Exception {
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException("Repository does not support versioning.");
        }
        Node testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(testNode, this.mixLockable);
        this.ensureMixinType(testNode, this.mixVersionable);
        this.testRootNode.getSession().save();
        try {
            testNode.lock(false, false);
        }
        catch (RepositoryException ex) {
            testNode.lock(true, false);
        }
        testNode.save();
        testNode.checkin();
        testNode.unlock();
        LockTest.assertFalse((String)"Could not unlock a locked, checked-in node", (boolean)testNode.holdsLock());
    }

    public void testReorder() throws Exception {
        Node testNode = this.setUpSameNameSiblings();
        testNode.lock(false, true);
        LockTest.assertTrue((String)"Third child node locked", (boolean)this.testRootNode.getNode(this.nodeName1 + "[3]").isLocked());
        this.testRootNode.orderBefore(this.nodeName1 + "[3]", this.nodeName1 + "[1]");
        this.testRootNode.getSession().save();
        LockTest.assertTrue((String)"First child node locked", (boolean)this.testRootNode.getNode(this.nodeName1 + "[1]").isLocked());
    }

    public void testReorder2() throws Exception {
        this.setUpSameNameSiblings();
        this.testRootNode.getNode(this.nodeName1 + "[1]").lock(false, true);
        LockTest.assertTrue((String)"First child node locked", (boolean)this.testRootNode.getNode(this.nodeName1 + "[1]").isLocked());
        this.testRootNode.orderBefore(this.nodeName1 + "[1]", null);
        this.testRootNode.getSession().save();
        LockTest.assertTrue((String)"Third child node locked", (boolean)this.testRootNode.getNode(this.nodeName1 + "[3]").isLocked());
    }

    public void testMoveLocked() throws Exception {
        Session session = this.testRootNode.getSession();
        Node testNode1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(testNode1, this.mixLockable);
        Node testNode2 = testNode1.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(testNode2, this.mixLockable);
        this.testRootNode.getSession().save();
        testNode2.lock(false, true);
        LockTest.assertTrue((String)"Child node locked", (boolean)testNode2.isLocked());
        String newPath = this.testRootNode.getPath() + "/" + testNode2.getName();
        session.move(testNode2.getPath(), newPath);
        LockTest.assertTrue((String)"Child node locked before save", (boolean)testNode2.isLocked());
        session.save();
        LockTest.assertTrue((String)"Child node locked after save", (boolean)testNode2.isLocked());
    }

    public void testUnlockSameNameSibling() throws RepositoryException, NotExecutableException {
        Node n2;
        Node n1;
        Session session = this.testRootNode.getSession();
        try {
            n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            n2 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            session.save();
        }
        catch (ItemExistsException ex) {
            throw new NotExecutableException("Node does not seem to allow same name siblings");
        }
        this.ensureMixinType(n1, this.mixLockable);
        this.ensureMixinType(n2, this.mixLockable);
        session.save();
        n1.lock(true, true);
        n2.lock(true, true);
        LockTest.assertTrue((String)"First node locked: ", (boolean)n1.isLocked());
        LockTest.assertTrue((String)"Second node locked: ", (boolean)n2.isLocked());
        n1.unlock();
        LockTest.assertFalse((String)"First node unlocked: ", (boolean)n1.isLocked());
        LockTest.assertTrue((String)"Second node locked: ", (boolean)n2.isLocked());
    }

    private boolean containsLockToken(Session session, String lockToken) {
        String[] lt = session.getLockTokens();
        for (int i = 0; i < lt.length; ++i) {
            if (!lt[i].equals(lockToken)) continue;
            return true;
        }
        return false;
    }

    private Node setUpSameNameSiblings() throws RepositoryException, NotExecutableException {
        try {
            Node testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.ensureMixinType(testNode, this.mixLockable);
            testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.ensureMixinType(testNode, this.mixLockable);
            testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.ensureMixinType(testNode, this.mixLockable);
            this.testRootNode.getSession().save();
            return testNode;
        }
        catch (ItemExistsException ex) {
            throw new NotExecutableException("Node type " + this.testNodeType + " does not support same-name-siblings");
        }
    }
}

