/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public abstract class AbstractJoinTest
extends AbstractQOMTest {
    protected static final String LEFT = "left";
    protected static final String RIGHT = "right";
    protected static final String[] SELECTOR_NAMES = new String[]{"left", "right"};

    protected void checkQOM(QueryObjectModel qom, Node[][] nodes) throws RepositoryException {
        this.checkQOM(qom, SELECTOR_NAMES, nodes);
    }

    protected void checkResult(QueryResult result, Node[][] nodes) throws RepositoryException {
        this.checkResult(result, SELECTOR_NAMES, nodes);
    }

    protected QueryObjectModel createQuery(String joinType, JoinCondition condition) throws RepositoryException {
        return this.createQuery(joinType, condition, null, null);
    }

    protected QueryObjectModel createQuery(String joinType, JoinCondition condition, Constraint left, Constraint right) throws RepositoryException {
        DescendantNode constraint = "jcr.join.type.left.outer".equals(joinType) ? this.qf.descendantNode(LEFT, this.testRoot) : this.qf.descendantNode(RIGHT, this.testRoot);
        if (left != null) {
            constraint = this.qf.and((Constraint)constraint, left);
        }
        if (right != null) {
            constraint = this.qf.and((Constraint)constraint, right);
        }
        Join join = this.qf.join((Source)this.qf.selector(this.testNodeType, LEFT), (Source)this.qf.selector(this.testNodeType, RIGHT), joinType, condition);
        return this.qf.createQuery((Source)join, (Constraint)constraint, null, null);
    }
}

