/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.security;

import java.util.NoSuchElementException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlPolicyIterator;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;

public class AccessControlPolicyIteratorTest
extends AbstractAccessControlTest {
    private String path;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        this.path = n.getPath();
    }

    public void testGetSize() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        long size = it.getSize();
        AccessControlPolicyIteratorTest.assertTrue((String)"Size must be -1 or any value >= 0", (size == -1L || size >= 0L ? 1 : 0) != 0);
    }

    public void testGetInitialPosition() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        AccessControlPolicyIteratorTest.assertTrue((String)"Initial position of AccessControlPolicyIterator must be 0.", (it.getPosition() == 0L ? 1 : 0) != 0);
    }

    public void testGetPosition() throws NotExecutableException, RepositoryException {
        this.checkCanReadAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        long position = 0L;
        while (it.hasNext()) {
            AccessControlPolicyIteratorTest.assertEquals((String)"Position must be adjusted during iteration.", (long)position, (long)it.getPosition());
            it.nextAccessControlPolicy();
            AccessControlPolicyIteratorTest.assertEquals((String)"Position must be adjusted after calling next.", (long)(++position), (long)it.getPosition());
        }
    }

    public void testSkip() throws NotExecutableException, RepositoryException {
        this.checkCanReadAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        long size = it.getSize();
        if (size > -1L) {
            it.skip(size);
            AccessControlPolicyIteratorTest.assertFalse((String)"After skipping all elements 'hasNext()' must return false", (boolean)it.hasNext());
            try {
                it.nextAccessControlPolicy();
                AccessControlPolicyIteratorTest.fail((String)"After skipping all 'nextAccessControlPolicy()' must fail.");
            }
            catch (NoSuchElementException noSuchElementException) {}
        } else {
            throw new NotExecutableException();
        }
    }
}

