/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceCopyBetweenTest;

abstract class AbstractWorkspaceSameNameSibsTest
extends AbstractWorkspaceCopyBetweenTest {
    protected final String PROP_SAME_NAME_SIBS_TRUE_NODE_TYPE = "sameNameSibsTrueNodeType";
    protected final String PROP_SAME_NAME_SIBS_FALSE_NODE_TYPE = "sameNameSibsFalseNodeType";
    protected NodeType sameNameSibsTrueNodeType;
    protected NodeType sameNameSibsFalseNodeType;

    AbstractWorkspaceSameNameSibsTest() {
    }

    @Override
    protected void setUp() throws Exception {
        int i;
        boolean isSameNameSibs;
        NodeDefinition[] childNodeDefs;
        super.setUp();
        NodeTypeManager ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
        try {
            this.sameNameSibsTrueNodeType = ntMgr.getNodeType(this.getProperty("sameNameSibsTrueNodeType"));
            childNodeDefs = this.sameNameSibsTrueNodeType.getDeclaredChildNodeDefinitions();
            isSameNameSibs = false;
            for (i = 0; i < childNodeDefs.length; ++i) {
                if (!childNodeDefs[i].allowsSameNameSiblings()) continue;
                isSameNameSibs = true;
                break;
            }
            if (!isSameNameSibs) {
                throw new NotExecutableException("Property 'sameNameSibsTrueNodeType' does not define a nodetype where sameNameSibs are allowed: '" + this.sameNameSibsTrueNodeType.getName() + "'");
            }
        }
        catch (NoSuchNodeTypeException e) {
            AbstractWorkspaceSameNameSibsTest.fail((String)("Property 'sameNameSibsTrueNodeType' does not define an existing nodetype: '" + String.valueOf(this.sameNameSibsTrueNodeType) + "'"));
        }
        try {
            this.sameNameSibsFalseNodeType = ntMgr.getNodeType(this.getProperty("sameNameSibsFalseNodeType"));
            childNodeDefs = this.sameNameSibsFalseNodeType.getDeclaredChildNodeDefinitions();
            isSameNameSibs = true;
            for (i = 0; i < childNodeDefs.length; ++i) {
                if (childNodeDefs[i].allowsSameNameSiblings()) continue;
                isSameNameSibs = false;
                break;
            }
            if (isSameNameSibs) {
                AbstractWorkspaceSameNameSibsTest.fail((String)("Property 'sameNameSibsFalseNodeType' does define a nodetype where sameNameSibs are not allowed: '" + this.sameNameSibsFalseNodeType.getName() + "'"));
            }
        }
        catch (NoSuchNodeTypeException e) {
            AbstractWorkspaceSameNameSibsTest.fail((String)("Property 'sameNameSibsFalseNodeType' does not define an existing nodetype: '" + String.valueOf(this.sameNameSibsFalseNodeType) + "'"));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.sameNameSibsTrueNodeType = null;
        this.sameNameSibsFalseNodeType = null;
        super.tearDown();
    }
}

