/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.security.AccessControlException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class CheckPermissionTest
extends AbstractJCRTest {
    public void testCheckPermission() throws Exception {
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        Session readOnly = this.getHelper().getReadOnlySession();
        try {
            this.permissionCheckReadOnly(readOnly);
            this.permissionCheckReadWrite(this.superuser);
        }
        finally {
            readOnly.logout();
        }
    }

    private void permissionCheckReadOnly(Session readOnly) throws Exception {
        Object pathPrefix = this.testRoot.length() == 1 ? this.testRoot : this.testRoot + "/";
        readOnly.checkPermission(this.testRoot, "read");
        try {
            readOnly.checkPermission((String)pathPrefix + this.nodeName1, "add_node");
            CheckPermissionTest.fail((String)"add_node permission granted to read-only Session");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            readOnly.checkPermission((String)pathPrefix + this.nodeName1, "set_property");
            CheckPermissionTest.fail((String)"set_property permission granted to read-only Session");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            readOnly.checkPermission((String)pathPrefix + this.nodeName2, "remove");
            CheckPermissionTest.fail((String)"remove permission granted to read-only Session");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private void permissionCheckReadWrite(Session readWrite) throws Exception {
        Object pathPrefix = this.testRoot.length() == 1 ? this.testRoot : this.testRoot + "/";
        readWrite.checkPermission(this.testRoot, "read");
        readWrite.checkPermission((String)pathPrefix + this.nodeName1, "add_node");
        readWrite.checkPermission((String)pathPrefix + this.propertyName1, "set_property");
        readWrite.checkPermission((String)pathPrefix + this.nodeName2, "remove");
    }
}

