/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.IOException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractImportXmlTest;
import org.xml.sax.SAXException;

public class DocumentViewImportTest
extends AbstractImportXmlTest {
    private String JCR_XMLTEXT;
    private String JCR_XMLCHAR;
    private boolean withHandler;
    private boolean withWorkspace;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.JCR_XMLTEXT = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":xmltext";
        this.JCR_XMLCHAR = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":xmlcharacters";
    }

    @Override
    public void tearDown() throws Exception {
        this.file.delete();
        super.tearDown();
    }

    public void testWorkspaceImportXml() throws Exception {
        this.withHandler = false;
        this.withWorkspace = true;
        this.doTestImportXML();
    }

    public void testSessionImportXml() throws Exception {
        this.withHandler = false;
        this.withWorkspace = false;
        this.doTestImportXML();
    }

    public void testWorkspaceGetImportContentHandler() throws Exception {
        this.withHandler = true;
        this.withWorkspace = false;
        this.doTestGetImportContentHandler();
    }

    public void testSessionGetImportContentHandler() throws Exception {
        this.withHandler = true;
        this.withWorkspace = true;
        this.doTestGetImportContentHandler();
    }

    public void doTestImportXML() throws Exception {
        this.importXML(this.target, this.createSimpleDocument(), this.uuidBehaviour, this.withWorkspace);
        if (this.withWorkspace) {
            this.session.refresh(false);
        }
        this.performTests();
    }

    public void doTestGetImportContentHandler() throws Exception {
        this.importWithHandler(this.target, this.createSimpleDocument(), this.uuidBehaviour, this.withWorkspace);
        if (this.withWorkspace) {
            this.session.refresh(false);
        }
        this.performTests();
    }

    private void performTests() throws Exception {
        this.checkImportSimpleXMLTree();
        this.checkNamespaceAdded();
        if (!this.respectMixRef) {
            throw new NotExecutableException("ImportXML tests with uuidBehaviour flag not executable.");
        }
        this.checkImportDocumentView_IMPORT_UUID_CREATE_NEW();
        this.checkImportDocumentView_IMPORT_UUID_COLLISION_REMOVE_EXISTING();
        this.checkImportDocumentView_IMPORT_UUID_COLLISION_REPLACE_EXISTING();
        this.checkImportDocumentView_IMPORT_UUID_COLLISION_THROW();
    }

    public void checkImportSimpleXMLTree() throws RepositoryException, IOException {
        Node parent = (Node)this.session.getItem(this.target);
        try {
            String prefix = this.session.getNamespacePrefix(this.unusedURI);
            String rootName = prefix + ":docRoot";
            Node rootNode = parent.getNode(rootName);
            Node child = rootNode.getNode("childElem");
            Node xmlTextNode = rootNode.getNode("xmltextElem");
            Node grandChild = xmlTextNode.getNode("grandChildElem");
            this.checkXmlTextNode(xmlTextNode);
            Property prop = grandChild.getProperty("attribute");
            Property prop2 = xmlTextNode.getProperty("attribute");
            String value = prop.getString();
            String value2 = prop2.getString();
            DocumentViewImportTest.assertEquals((String)"Value attrVal of attribute attribute is imported to different property values.", (String)value, (String)value2);
            DocumentViewImportTest.assertEquals((String)"Value attrVal  of attribute attribute is not correctly imported.", (String)value, (String)"attrVal");
            try {
                child.getNode("Element<>Name");
                Property decodedProp = child.getProperty("Prop Name");
                String propVal = decodedProp.getString();
                if (!propVal.equals("Hello_x0009_&_x0009_GoodBye") && !propVal.equals("Hello\t&\tGoodBye")) {
                    DocumentViewImportTest.fail((String)"Value Hello_x0009_&_x0009_GoodBye  of attribute Prop Name is not correctly imported.");
                }
            }
            catch (PathNotFoundException pnfe) {
                try {
                    child.getNode("Element_x003C__x003E_Name");
                    Property decodedProp = child.getProperty("Prop_x0020_Name");
                    String propVal = decodedProp.getString();
                    if (!propVal.equals("Hello_x0009_&_x0009_GoodBye") && !propVal.equals("Hello\t&\tGoodBye")) {
                        DocumentViewImportTest.fail((String)"Value Hello_x0009_&_x0009_GoodBye  of attribute Prop_x0020_Name is not correctly imported.");
                    }
                }
                catch (PathNotFoundException pnfe2) {
                    DocumentViewImportTest.fail((String)("XML Element Element_x003C__x003E_Name or attribute Prop_x0020_Name not imported: " + String.valueOf((Object)pnfe2)));
                }
            }
        }
        catch (PathNotFoundException pne) {
            DocumentViewImportTest.fail((String)("Element or attribute is not imported: " + String.valueOf((Object)pne)));
        }
    }

    public void checkXmlTextNode(Node node) throws RepositoryException, IOException {
        if (node.hasNode(this.JCR_XMLTEXT)) {
            Node xmlNode = node.getNode(this.JCR_XMLTEXT);
            if (xmlNode.hasProperty(this.JCR_XMLCHAR)) {
                Property prop = xmlNode.getProperty(this.JCR_XMLCHAR);
                DocumentViewImportTest.assertTrue((String)("Property " + prop.getPath() + " is not of type String."), (prop.getType() == 1 ? 1 : 0) != 0);
                DocumentViewImportTest.assertEquals((String)"Xml text is not correctly stored.", (String)this.xmltext.trim(), (String)prop.getString().trim());
                PropertyIterator iter = xmlNode.getProperties();
                DocumentViewImportTest.assertTrue((String)(this.JCR_XMLCHAR + " is not the only property beneath " + this.jcrPrimaryType + " in a " + this.JCR_XMLTEXT + " node."), (this.getSize((RangeIterator)iter) == 2L ? 1 : 0) != 0);
            } else {
                DocumentViewImportTest.fail((String)("Xmltext not stored in property named " + this.JCR_XMLCHAR));
            }
        } else {
            DocumentViewImportTest.fail((String)("Xmltext not imported to Node named " + this.JCR_XMLTEXT));
        }
    }

    public void checkNamespaceAdded() throws RepositoryException, IOException {
        try {
            DocumentViewImportTest.assertEquals((String)"URI not correctly imported.", (String)this.nsp.getURI(this.unusedPrefix), (String)this.unusedURI);
            DocumentViewImportTest.assertEquals((String)"Prefix not correctly imported", (String)this.nsp.getPrefix(this.unusedURI), (String)this.unusedPrefix);
        }
        catch (NamespaceException nse) {
            DocumentViewImportTest.fail((String)("Namespace " + this.unusedPrefix + ":" + this.unusedURI + " not imported during document view import."));
        }
    }

    public void checkImportDocumentView_IMPORT_UUID_CREATE_NEW() throws Exception {
        String uuid = this.createReferenceableNode(this.referenced);
        this.importRefNodeDocument(this.refTarget, uuid, 0, this.withWorkspace, this.withHandler);
        Node node = this.refTargetNode.getNode("docRoot");
        String rootElemUUID = node.getUUID();
        DocumentViewImportTest.assertFalse((String)"Imported node docRoot has a UUID which is yet assigned to another node", (boolean)uuid.equals(rootElemUUID));
    }

    public void checkImportDocumentView_IMPORT_UUID_COLLISION_REMOVE_EXISTING() throws Exception {
        String uuid = this.createReferenceableNode(this.referenced);
        this.importRefNodeDocument(this.refTarget, uuid, 1, this.withWorkspace, this.withHandler);
        try {
            this.testRootNode.getNode(this.referenced);
            DocumentViewImportTest.fail((String)"UUID behavior IMPORT_UUID_COLLISION_REMOVE_EXISTING test is failed: existing node not removed");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        try {
            this.refTargetNode.getNode("docRoot");
        }
        catch (PathNotFoundException pnfe) {
            DocumentViewImportTest.fail((String)"UUID behavior IMPORT_UUID_COLLISION_REMOVE_EXISTING test is failed: imported node not in its correct place.");
        }
    }

    public void checkImportDocumentView_IMPORT_UUID_COLLISION_REPLACE_EXISTING() throws Exception {
        String uuid = this.createReferenceableNode(this.referenced);
        this.importRefNodeDocument(this.refTarget, uuid, 2, this.withWorkspace, this.withHandler);
        if (!this.withWorkspace) {
            Node node = this.testRootNode.getNode("docRoot");
            DocumentViewImportTest.assertTrue((String)("Node " + node.getPath() + " not replaced during import with IMPORT_UUID_COLLISION_REPLACE_EXISTING"), (boolean)node.hasProperty(this.propertyName1));
        }
    }

    public void checkImportDocumentView_IMPORT_UUID_COLLISION_THROW() throws Exception {
        block4: {
            String uuid = this.createReferenceableNode(this.referenced);
            try {
                this.importRefNodeDocument(this.refTarget, uuid, 3, this.withWorkspace, this.withHandler);
                DocumentViewImportTest.fail((String)"UUID behavior IMPORT_UUID_COLLISION_THROW test is failed: should throw an Exception.");
            }
            catch (ItemExistsException e) {
                if (this.withHandler) {
                    throw e;
                }
            }
            catch (SAXException e) {
                if (this.withHandler) break block4;
                throw e;
            }
        }
    }

    public void doTestSameUUIDAtAncestor(boolean withWorkspace, boolean withHandler) throws Exception {
        block4: {
            String uuid = this.createReferenceableNode(this.referenced);
            Node node = this.testRootNode.getNode(this.referenced);
            Node node2 = node.addNode("newParent");
            this.session.save();
            try {
                this.importRefNodeDocument(node2.getPath(), uuid, 1, withWorkspace, withHandler);
                DocumentViewImportTest.fail((String)"UUID collision with an ancestor of the target node hould throw a SAXException or a ConstraintViolationException in case of uuidBehavior IMPORT_UUID_COLLISION_REMOVE_EXISTING.");
            }
            catch (SAXException se) {
                if (!withHandler) {
                    throw se;
                }
            }
            catch (ConstraintViolationException cve) {
                if (!withHandler) break block4;
                throw cve;
            }
        }
    }

    public void testSameUUIDAtAncestorWorkspaceHandler() throws Exception {
        this.doTestSameUUIDAtAncestor(true, this.CONTENTHANDLER);
    }

    public void testSameUUIDAtAncestorWorkspace() throws Exception {
        this.doTestSameUUIDAtAncestor(true, this.STREAM);
    }

    public void testSameUUIDAtAncestorSessionHandler() throws Exception {
        this.doTestSameUUIDAtAncestor(false, this.CONTENTHANDLER);
    }

    public void testSameUUIDAtAncestorSession() throws Exception {
        this.doTestSameUUIDAtAncestor(false, this.STREAM);
    }
}

