/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.api.SysViewContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportSysViewTest
extends AbstractJCRTest {
    private File file;
    private final boolean SKIPBINARY = true;
    private final boolean SAVEBINARY = false;
    private final boolean NORECURSE = true;
    private final boolean RECURSE = false;
    private Session session;
    private String testPath;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        this.session = this.getHelper().getReadOnlySession();
        this.file = File.createTempFile("SysViewExportTest", ".xml");
        super.setUp();
        this.testPath = this.testRoot;
    }

    @Override
    protected void tearDown() throws Exception {
        this.file.delete();
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testExportSysView_handler_session_skipBinary_noRecurse() throws IOException, RepositoryException, SAXException, IOException {
        this.doTestWithHandler(true, true);
    }

    public void testExportSysView_handler_session_skipBinary_recurse() throws IOException, RepositoryException, SAXException, IOException {
        this.doTestWithHandler(true, false);
    }

    public void testExportSysView_handler_session_saveBinary_noRecurse() throws IOException, RepositoryException, SAXException, IOException {
        this.doTestWithHandler(false, true);
    }

    public void testExportSysView_handler_session_saveBinary_recurse() throws IOException, RepositoryException, SAXException, IOException {
        this.doTestWithHandler(false, false);
    }

    public void testExportSysView_stream_session_skipBinary_recurse() throws IOException, RepositoryException, SAXException {
        this.doTestWithStream(true, false);
    }

    public void testExportSysView_stream_session_skipBinary_noRecurse() throws IOException, RepositoryException, SAXException {
        this.doTestWithStream(true, true);
    }

    public void testExportSysView_stream_session_saveBinary_noRecurse() throws IOException, RepositoryException, SAXException {
        this.doTestWithStream(false, true);
    }

    public void testExportSysView_stream_session_saveBinary_recurse() throws IOException, RepositoryException, SAXException {
        this.doTestWithStream(false, false);
    }

    public void doTestWithHandler(boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException, IOException {
        SysViewContentHandler contentHandler = new SysViewContentHandler(this.testPath, this.session, skipBinary, noRecurse);
        this.session.exportSystemView(this.testPath, (ContentHandler)contentHandler, skipBinary, noRecurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestWithStream(boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException, IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.file));){
            this.session.exportSystemView(this.testPath, (OutputStream)os, false, false);
            SysViewParser parser = new SysViewParser(this.testPath, this.session, false, false);
            parser.parse(this.file);
        }
    }

    protected class SysViewParser {
        String filePath;
        String nodePath;
        Node node;
        SAXParser parser;
        SysViewContentHandler handler;

        public SysViewParser(String nodePath, Session session, boolean skipBinary, boolean noRecurse) throws SAXException, RepositoryException {
            this.nodePath = nodePath;
            this.handler = new SysViewContentHandler(nodePath, session, skipBinary, noRecurse);
            try {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e);
            }
        }

        public void parse(File file) throws IOException, SAXException {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                TestCase.fail((String)("Input file not opened: " + String.valueOf(e)));
            }
            InputSource source = new InputSource(in);
            this.parser.parse(source, (DefaultHandler)this.handler);
        }
    }
}

