/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.NodeMixinUtil;

public class NodeSetPrimaryTypeTest
extends AbstractJCRTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetPrimaryType() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        Session otherSession = null;
        String nonExistingMixinName = NodeMixinUtil.getNonExistingMixinName(session);
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator nts = manager.getPrimaryNodeTypes();
        while (nts.hasNext()) {
            NodeType nt = nts.nextNodeType();
            String ntName = nt.getName();
            if (nt.isAbstract() || this.ntFrozenNode.equals(ntName) || this.ntActivity.equals(ntName)) continue;
            try {
                node.setPrimaryType(ntName);
                NodeSetPrimaryTypeTest.assertEquals((String)"The value of the jcr:primaryType property must change upon setPrimaryType.", (String)ntName, (String)node.getProperty(this.jcrPrimaryType).getString());
                this.superuser.save();
                NodeSetPrimaryTypeTest.assertEquals((String)"Node.getPrimaryNodeType must reflect the changes made.", (String)ntName, (String)node.getPrimaryNodeType().getName());
                NodeSetPrimaryTypeTest.assertEquals((String)"The value of the jcr:primaryType property must change upon setPrimaryType.", (String)ntName, (String)node.getProperty(this.jcrPrimaryType).getString());
                otherSession = this.getHelper().getReadOnlySession();
                NodeSetPrimaryTypeTest.assertEquals((String)"Node.getPrimaryNodeType must reflect the changes made.", (String)ntName, (String)otherSession.getNode(node.getPath()).getPrimaryNodeType().getName());
                NodeSetPrimaryTypeTest.assertEquals((String)"The value of the jcr:primaryType property must change upon setPrimaryType.", (String)ntName, (String)otherSession.getNode(node.getPath()).getProperty(this.jcrPrimaryType).getString());
                return;
            }
            catch (ConstraintViolationException constraintViolationException) {}
            continue;
            finally {
                if (otherSession != null) {
                    otherSession.logout();
                }
                session.refresh(false);
            }
        }
    }

    public void testSetCurrentType() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        node.setPrimaryType(this.testNodeType);
        this.superuser.save();
    }

    public void testSetCurrentTypeOnNew() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        node.setPrimaryType(this.testNodeType);
        this.superuser.save();
    }

    public void testAddNonExisting() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        Object nonExistingMixinName = "abc";
        while (manager.hasNodeType((String)nonExistingMixinName)) {
            nonExistingMixinName = (String)nonExistingMixinName + "_";
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            node.setPrimaryType((String)nonExistingMixinName);
            this.superuser.save();
            NodeSetPrimaryTypeTest.fail((String)"Node.setPrimaryType(String) must throw a NoSuchNodeTypeException if no nodetype exists with the given name.");
        }
        catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetMixinAsPrimaryType() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator nts = manager.getMixinNodeTypes();
        while (nts.hasNext()) {
            try {
                Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
                node.setPrimaryType(nts.nextNodeType().getName());
                NodeSetPrimaryTypeTest.fail((String)"Node.setPrimaryType(String) must throw ConstraintViolationException if the specified node type name refers to a mixin.");
            }
            catch (ConstraintViolationException constraintViolationException) {}
            continue;
            finally {
                session.refresh(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetAbstractAsPrimaryType() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator nts = manager.getPrimaryNodeTypes();
        while (nts.hasNext()) {
            NodeType nt = nts.nextNodeType();
            if (!nt.isAbstract()) continue;
            try {
                Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
                node.setPrimaryType(nt.getName());
                NodeSetPrimaryTypeTest.fail((String)"Node.setPrimaryType(String) must throw ConstraintViolationException if the specified node type name refers to an abstract node type.");
            }
            catch (ConstraintViolationException constraintViolationException) {}
            continue;
            finally {
                session.refresh(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocked() throws NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(node, this.mixLockable);
        this.testRootNode.getSession().save();
        String primaryTypeName = NodeSetPrimaryTypeTest.getPrimaryTypeName(session, node);
        if (primaryTypeName == null) {
            throw new NotExecutableException("No testable node type found");
        }
        String pathRelToRoot = node.getPath().substring(1);
        Session session2 = this.getHelper().getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(true, true);
            try {
                node.setPrimaryType(primaryTypeName);
                node.save();
                NodeSetPrimaryTypeTest.fail((String)"Node.setPrimaryType(String) must throw a LockException if the node is locked.");
            }
            catch (LockException lockException) {
                // empty catch block
            }
            node2.unlock();
        }
        finally {
            session2.logout();
        }
    }

    public void testCheckedIn() throws NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException("Versioning is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(node, this.mixVersionable);
        this.superuser.save();
        String primaryTypeName = NodeSetPrimaryTypeTest.getPrimaryTypeName(session, node);
        if (primaryTypeName == null) {
            throw new NotExecutableException("No testable node type found");
        }
        node.checkin();
        try {
            node.setPrimaryType(primaryTypeName);
            NodeSetPrimaryTypeTest.fail((String)"Node.setPrimaryType(String) must throw a VersionException if the node is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    private static String getPrimaryTypeName(Session session, Node node) throws RepositoryException {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator nts = manager.getPrimaryNodeTypes();
        while (nts.hasNext()) {
            String name = nts.nextNodeType().getName();
            if (name.equals(node.getPrimaryNodeType().getName())) continue;
            return name;
        }
        return null;
    }
}

