/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.SerializationContext;
import org.apache.jackrabbit.test.api.TreeComparator;
import org.apache.jackrabbit.test.api.util.InputStreamWrapper;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SerializationTest
extends AbstractJCRTest {
    protected Workspace workspace;
    protected File file;
    protected TreeComparator treeComparator;
    protected final boolean CONTENTHANDLER = true;
    protected final boolean STREAM = false;
    protected final boolean WORKSPACE = true;
    protected final boolean SESSION = false;
    protected final boolean SKIPBINARY = true;
    protected final boolean SAVEBINARY = false;
    protected final boolean NORECURSE = true;
    protected final boolean RECURSE = false;
    protected Session session;

    @Override
    public void setUp() throws RepositoryException, Exception {
        super.setUp();
        try {
            this.session = this.superuser;
            this.workspace = this.session.getWorkspace();
            SerializationContext sc = new SerializationContext(this, this.session);
            this.treeComparator = new TreeComparator(sc, this.session);
            Objects.requireNonNull(this.treeComparator);
            this.treeComparator.createComplexTree(true);
            this.file = File.createTempFile("serializationTest", ".xml");
            this.log.print("Tempfile: " + this.file.getAbsolutePath());
        }
        catch (Exception ex) {
            if (this.file != null) {
                this.file.delete();
                this.file = null;
            }
            throw ex;
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
            this.session = null;
        }
        this.workspace = null;
        super.tearDown();
    }

    protected Node initVersioningException(boolean returnParent) throws RepositoryException, NotExecutableException, IOException {
        Node vNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(vNode, this.mixVersionable);
        Node vChild = vNode.addNode(this.nodeName2, this.testNodeType);
        this.session.save();
        vNode.checkin();
        this.exportRepository(true, false);
        if (returnParent) {
            return vNode;
        }
        return vChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestVersioningExceptionFileParent(boolean useWorkspace, boolean useHandler) throws Exception {
        Node n = this.initVersioningException(true);
        FileInputStream in = new FileInputStream(this.file);
        try {
            this.doImport(n.getPath(), in, useWorkspace, useHandler);
            SerializationTest.fail((String)"Importing to a checked-in node must throw a ConstraintViolationException.");
        }
        catch (VersionException versionException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestVersioningExceptionFileChild(boolean useWorkspace, boolean useHandler) throws Exception {
        Node n = this.initVersioningException(false);
        FileInputStream in = new FileInputStream(this.file);
        try {
            this.doImport(n.getPath(), in, useWorkspace, useHandler);
            SerializationTest.fail((String)"Importing to a child of a checked-in node must throw a ConstraintViolationException.");
        }
        catch (VersionException versionException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void testVersioningExceptionFileParentWorkspaceContentHandler() throws Exception {
        this.doTestVersioningExceptionFileParent(true, true);
    }

    public void testVersioningExceptionFileParentSessionContentHandler() throws Exception {
        this.doTestVersioningExceptionFileParent(false, true);
    }

    public void testVersioningExceptionFileParentWorkspace() throws Exception {
        this.doTestVersioningExceptionFileParent(true, false);
    }

    public void testVersioningExceptionFileParentSession() throws Exception {
        this.doTestVersioningExceptionFileParent(false, false);
    }

    public void testVersioningExceptionFileChildWorkspaceContentHandler() throws Exception {
        this.doTestVersioningExceptionFileChild(true, true);
    }

    public void testVersioningExceptionFileChildSessionContentHandler() throws Exception {
        this.doTestVersioningExceptionFileChild(false, true);
    }

    public void testVersioningExceptionFileChildWorkspace() throws Exception {
        this.doTestVersioningExceptionFileChild(true, false);
    }

    public void testVersioningExceptionFileChildSession() throws Exception {
        this.doTestVersioningExceptionFileChild(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestLockException(boolean useWorkspace, boolean useHandler) throws Exception {
        this.exportRepository(true, false);
        if (this.isSupported("option.locking.supported")) {
            Node lNode = this.testRootNode.addNode(this.nodeName1);
            this.ensureMixinType(lNode, this.mixLockable);
            this.testRootNode.getSession().save();
            Lock lock = lNode.lock(true, true);
            this.session.removeLockToken(lock.getLockToken());
            FileInputStream in = new FileInputStream(this.file);
            try {
                this.doImport(lNode.getPath(), in, useWorkspace, useHandler);
            }
            catch (LockException lockException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            this.log.println("Locking not supported.");
        }
    }

    public void testLockExceptionWorkspaceWithHandler() throws Exception {
        this.doTestVersioningExceptionFileChild(true, true);
    }

    public void testLockExceptionSessionWithHandler() throws Exception {
        this.doTestVersioningExceptionFileChild(false, true);
    }

    public void testLockExceptionWorkspace() throws Exception {
        this.doTestVersioningExceptionFileChild(true, false);
    }

    public void testLockExceptionSession() throws Exception {
        this.doTestVersioningExceptionFileChild(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidXmlThrowsSaxException() throws IOException, ParserConfigurationException {
        StringReader in = new StringReader("<this is not a <valid> <xml> file/>");
        ContentHandler ih = null;
        try {
            ih = this.session.getImportContentHandler(this.treeComparator.targetFolder, 0);
            this.helpTestSaxException(ih, in, "session");
        }
        catch (RepositoryException e) {
            try {
                SerializationTest.fail((String)("ImportHandler not created: " + String.valueOf((Object)e)));
            }
            catch (Throwable throwable) {
                SerializationTest.closeContentHandler(ih);
                throw throwable;
            }
            SerializationTest.closeContentHandler(ih);
        }
        SerializationTest.closeContentHandler(ih);
        in = new StringReader("<this is not a <valid> <xml> file/>");
        try {
            ih = this.workspace.getImportContentHandler(this.treeComparator.targetFolder, 0);
            this.helpTestSaxException(ih, in, "workspace");
        }
        catch (RepositoryException e) {
            SerializationTest.fail((String)("ImportHandler not created: " + String.valueOf((Object)e)));
        }
        finally {
            SerializationTest.closeContentHandler(ih);
        }
    }

    private static void closeContentHandler(ContentHandler ch) {
        if (ch != null) {
            try {
                ch.endDocument();
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    private void helpTestSaxException(ContentHandler ih, Reader in, String mode) throws IOException {
        try {
            this.createXMLReader(ih).parse(new InputSource(in));
            SerializationTest.fail((String)("Parsing an invalid XML file with via " + mode + " ContentHandler did not throw a SAXException."));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void testInvalidXmlThrowsInvalidSerializedDataException() throws RepositoryException, IOException {
        String data = "<this is not a <valid> <xml> file/>";
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes());
        try {
            this.session.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
            SerializationTest.fail((String)"Importing a invalid XML file should throw a InvalidSerializedDataException.");
        }
        catch (InvalidSerializedDataException invalidSerializedDataException) {
            // empty catch block
        }
        in = new ByteArrayInputStream(data.getBytes());
        try {
            this.workspace.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
            SerializationTest.fail((String)"Importing a invalid XML file should throw a InvalidSerializedDataException.");
        }
        catch (InvalidSerializedDataException invalidSerializedDataException) {
            // empty catch block
        }
    }

    public void testWorkspaceGetImportContentHandlerExceptions() throws RepositoryException {
        try {
            this.workspace.getImportContentHandler(this.treeComparator.targetFolder + "/thisIsNotAnExistingNode", 0);
            SerializationTest.fail((String)"Specifying a non-existing path must throw a PathNotFoudException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testSessionGetImportContentHandlerExceptions() throws RepositoryException {
        try {
            this.session.getImportContentHandler(this.treeComparator.targetFolder + "/thisIsNotAnExistingNode", 0);
            SerializationTest.fail((String)"Specifying a non-existing path must throw a PathNotFoudException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testSessionImportXmlExceptions() throws RepositoryException, IOException {
        this.exportRepository(true, false);
        FileInputStream in = new FileInputStream(this.file);
        try {
            this.session.importXML(this.treeComparator.targetFolder + "/thisNodeDoesNotExist", (InputStream)in, 0);
            SerializationTest.fail((String)"Importing to a non-existing node does not throw a PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void testWorkspaceImportXmlExceptions() throws RepositoryException, IOException {
        this.exportRepository(true, false);
        FileInputStream in = new FileInputStream(this.file);
        try {
            this.workspace.importXML(this.treeComparator.targetFolder + "/thisNodeDoesNotExist", (InputStream)in, 0);
            SerializationTest.fail((String)"Importing to a non-existing node does not throw a PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestOverwriteException(boolean useWorkspace, boolean useHandler) throws Exception {
        Node folder = this.testRootNode.addNode("myFolder", this.treeComparator.sc.sameNameSibsFalseChildNodeDefinition);
        Node subfolder = folder.addNode("subfolder");
        this.session.save();
        try (FileOutputStream out = new FileOutputStream(this.file);){
            this.session.exportSystemView(subfolder.getPath(), (OutputStream)out, true, true);
        }
        FileInputStream in = new FileInputStream(this.file);
        try {
            if (useHandler) {
                try {
                    this.doImport(folder.getPath(), in, useWorkspace, useHandler);
                    SerializationTest.fail((String)"Overwriting an existing node during import must throw a SAXException");
                }
                catch (SAXException sAXException) {}
            } else {
                try {
                    this.doImport(folder.getPath(), in, useWorkspace, useHandler);
                    SerializationTest.fail((String)"Overwriting an existing node during import must throw an ItemExistsException");
                }
                catch (ItemExistsException itemExistsException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void testOverwriteExceptionWorkspaceWithHandler() throws Exception {
        this.doTestOverwriteException(true, true);
    }

    public void testOverwriteExceptionSessionWithHandler() throws Exception {
        this.doTestOverwriteException(false, true);
    }

    public void testOverwriteExceptionWorkspace() throws Exception {
        this.doTestOverwriteException(true, false);
    }

    public void testOverwriteExceptionSession() throws Exception {
        this.doTestOverwriteException(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestNodeTypeConstraintViolation(boolean useWorkspace, boolean useHandler) throws Exception {
        this.treeComparator.createExampleTree();
        String nodetype = this.testNodeTypeNoChildren == null ? this.ntBase : this.testNodeTypeNoChildren;
        Node node = this.testRootNode.addNode("ntBase", nodetype);
        this.session.save();
        FileInputStream in = new FileInputStream(this.file);
        try {
            if (useHandler) {
                try {
                    this.doImport(node.getPath(), in, useWorkspace, useHandler);
                    SerializationTest.fail((String)"Node type constraint violation should throw a SAXException during xml import using a Contenthandler.");
                }
                catch (SAXException sAXException) {}
            } else {
                try {
                    this.doImport(node.getPath(), in, useWorkspace, useHandler);
                    SerializationTest.fail((String)"Node type constraint violation should throw a   InvalidSerializedDataException during xml import using a Contenthandler.");
                }
                catch (InvalidSerializedDataException invalidSerializedDataException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void testNodeTypeConstraintViolationWorkspaceWithHandler() throws Exception {
        this.doTestNodeTypeConstraintViolation(true, true);
    }

    public void testNodeTypeConstraintViolationSessionWithHandler() throws Exception {
        this.doTestNodeTypeConstraintViolation(false, true);
    }

    public void testNodeTypeConstraintViolationWorkspace() throws Exception {
        this.doTestNodeTypeConstraintViolation(true, false);
    }

    public void testNodeTypeConstraintViolationSession() throws Exception {
        this.doTestNodeTypeConstraintViolation(false, false);
    }

    public void testSessionImportXml() throws RepositoryException, IOException {
        FileInputStream in = new FileInputStream(this.file);
        try {
            this.exportRepository(false, false);
            this.session.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        this.session.logout();
        this.superuser = null;
        this.session = this.getHelper().getReadWriteSession();
        this.treeComparator.setSession(this.session);
        this.treeComparator.compare(this.treeComparator.CHECK_EMPTY);
    }

    public void testSessionGetContentHandler() throws Exception {
        FileInputStream in = new FileInputStream(this.file);
        try {
            this.exportRepository(false, false);
            this.doImportNoSave(this.treeComparator.targetFolder, in, true);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        this.session.logout();
        this.superuser = null;
        this.session = this.getHelper().getReadWriteSession();
        this.treeComparator.setSession(this.session);
        this.treeComparator.compare(this.treeComparator.CHECK_EMPTY);
    }

    public void testStreamHandling() throws RepositoryException, IOException {
        this.exportRepository(false, false);
        InputStreamWrapper in = new InputStreamWrapper(new FileInputStream(this.file));
        this.session.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
        SerializationTest.assertTrue((String)"Session.importXML(..., InputStream, ...) is expected to close the passed input stream", (boolean)in.isClosed());
        this.session.refresh(false);
        in = new InputStreamWrapper(new FileInputStream(this.file));
        this.workspace.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
        SerializationTest.assertTrue((String)"Workspace.importXML(..., InputStream, ...) is expected to close the passed input stream", (boolean)in.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(String absPath, FileInputStream in, boolean useWorkspace, boolean useHandler) throws Exception {
        if (useHandler) {
            if (useWorkspace) {
                ContentHandler ih = this.workspace.getImportContentHandler(absPath, 0);
                try {
                    this.createXMLReader(ih).parse(new InputSource(in));
                }
                finally {
                    ih.endDocument();
                }
            } else {
                ContentHandler ih = this.session.getImportContentHandler(absPath, 0);
                try {
                    this.createXMLReader(ih).parse(new InputSource(in));
                    this.session.save();
                }
                finally {
                    ih.endDocument();
                }
            }
        } else if (useWorkspace) {
            this.workspace.importXML(absPath, (InputStream)in, 0);
        } else {
            this.session.importXML(absPath, (InputStream)in, 0);
            this.session.save();
        }
    }

    public void doImportNoSave(String absPath, FileInputStream in, boolean useHandler) throws Exception {
        if (useHandler) {
            ContentHandler ih = this.session.getImportContentHandler(absPath, 0);
            this.createXMLReader(ih).parse(new InputSource(in));
        } else {
            this.session.importXML(absPath, (InputStream)in, 0);
        }
    }

    public void testExportSysView_stream_workspace_skipBinary_noRecurse() throws Exception {
        this.doTest(false, true, true, true);
    }

    public void testExportSysView_stream_workspace_skipBinary_recurse() throws Exception {
        this.doTest(false, true, true, false);
    }

    public void testExportSysView_stream_workspace_saveBinary_noRecurse() throws Exception {
        this.doTest(false, true, false, true);
    }

    public void testExportSysView_stream_workspace_saveBinary_recurse() throws Exception {
        this.doTest(false, true, false, false);
    }

    public void testExportSysView_stream_session_skipBinary_noRecurse() throws Exception {
        this.doTest(false, false, true, true);
    }

    public void testExportSysView_stream_session_skipBinary_recurse() throws Exception {
        this.doTest(false, false, true, false);
    }

    public void testExportSysView_stream_session_saveBinary_noRecurse() throws Exception {
        this.doTest(false, false, false, true);
    }

    public void testExportSysView_stream_session_saveBinary_recurse() throws Exception {
        this.doTest(false, false, false, false);
    }

    public void testExportSysView_handler_workspace_skipBinary_noRecurse() throws Exception {
        this.doTest(true, true, true, true);
    }

    public void testExportSysView_handler_workspace_skipBinary_recurse() throws Exception {
        this.doTest(true, true, true, false);
    }

    public void testExportSysView_handler_workspace_saveBinary_noRecurse() throws Exception {
        this.doTest(true, true, false, true);
    }

    public void testExportSysView_handler_workspace_saveBinary_recurse() throws Exception {
        this.doTest(true, true, false, false);
    }

    public void testExportSysView_handler_session_skipBinary_noRecurse() throws Exception {
        this.doTest(true, false, true, true);
    }

    public void testExportSysView_handler_session_skipBinary_recurse() throws Exception {
        this.doTest(true, false, true, false);
    }

    public void testExportSysView_handler_session_saveBinary_noRecurse() throws Exception {
        this.doTest(true, false, false, true);
    }

    public void testExportSysView_handler_session_saveBinary_recurse() throws Exception {
        this.doTest(true, false, false, false);
    }

    private void doTest(boolean handler, boolean workspace, boolean skipBinary, boolean noRecurse) throws Exception {
        this.exportRepository(skipBinary, noRecurse);
        this.importRepository(handler, workspace);
        this.treeComparator.showTree();
        this.treeComparator.compare(skipBinary, noRecurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportRepository(boolean skipBinary, boolean noRecurse) throws IOException {
        try (FileOutputStream out = new FileOutputStream(this.file);){
            this.session.refresh(false);
            this.session.exportSystemView(this.treeComparator.getSourceRootPath(), (OutputStream)out, skipBinary, noRecurse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRepository(boolean useHandler, boolean workspace) throws Exception {
        FileInputStream in = new FileInputStream(this.file);
        try {
            if (useHandler) {
                if (workspace) {
                    ContentHandler ih = this.workspace.getImportContentHandler(this.treeComparator.targetFolder, 0);
                    this.createXMLReader(ih).parse(new InputSource(in));
                } else {
                    ContentHandler ih = this.session.getImportContentHandler(this.treeComparator.targetFolder, 0);
                    this.createXMLReader(ih).parse(new InputSource(in));
                    this.session.save();
                }
            } else if (workspace) {
                this.workspace.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
            } else {
                this.session.importXML(this.treeComparator.targetFolder, (InputStream)in, 0);
                this.session.save();
            }
        }
        catch (SAXException e) {
            SerializationTest.fail((String)("Error while parsing the imported repository: " + String.valueOf(e)));
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private XMLReader createXMLReader(ContentHandler handler) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        reader.setContentHandler(handler);
        reader.setErrorHandler(new DefaultHandler());
        return reader;
    }
}

