/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractPropertyTest;
import org.apache.jackrabbit.test.api.PropertyUtil;

public class StringPropertyTest
extends AbstractPropertyTest {
    @Override
    protected int getPropertyType() {
        return 1;
    }

    @Override
    protected Boolean getPropertyIsMultivalued() {
        return null;
    }

    public void testValue() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getString();
                StringPropertyTest.fail((String)"Property.getString() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {}
        } else {
            StringPropertyTest.assertEquals((String)"Value.getString() and Property.getString() return different values.", (String)this.prop.getValue().getString(), (String)this.prop.getString());
        }
    }

    public void testGetBoolean() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        boolean bool = val.getBoolean();
        StringPropertyTest.assertEquals((String)"Wrong conversion from String to Boolean.", (Object)new Boolean(bool), (Object)Boolean.valueOf(str));
    }

    public void testGetDate() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        if (PropertyUtil.isDateFormat(val.getString())) {
            val.getDate();
        } else {
            try {
                val.getDate();
                StringPropertyTest.fail((String)"Conversion from a malformed String to a Date should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetDouble() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        try {
            Double.parseDouble(str);
            double d = val.getDouble();
            StringPropertyTest.assertEquals((String)"Wrong conversion from String to Double.", (Object)new Double(d), (Object)Double.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            try {
                val.getDouble();
                StringPropertyTest.fail((String)"Conversion from malformed String to Double should throw ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetLong() throws RepositoryException {
        Value val = PropertyUtil.getValue(this.prop);
        String str = val.getString();
        try {
            Long.parseLong(str);
            long l = val.getLong();
            StringPropertyTest.assertEquals((String)"Wrong conversion from String to Long.", (Object)new Long(l), (Object)Long.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            try {
                val.getLong();
                StringPropertyTest.fail((String)"Conversion from malformed String to Long should throw ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetStream() throws RepositoryException, IOException {
        Value val = PropertyUtil.getValue(this.prop);
        BufferedInputStream in = new BufferedInputStream(val.getStream());
        Value otherVal = PropertyUtil.getValue(this.prop);
        byte[] utf8bytes = otherVal.getString().getBytes(UTF8);
        int i = 0;
        byte[] b = new byte[1];
        while (in.read(b) != -1) {
            StringPropertyTest.assertEquals((String)"String as a Stream is not utf-8 encoded", (byte)utf8bytes[i], (byte)b[0]);
            ++i;
        }
        try {
            val.getString();
        }
        catch (IllegalStateException ise) {
            StringPropertyTest.fail((String)"Non stream method call after stream method call should not throw an IllegalStateException.");
        }
        try {
            otherVal.getStream();
        }
        catch (IllegalStateException ise) {
            StringPropertyTest.fail((String)"Stream method call after a non stream method call should not throw an IllegalStateException.");
        }
        in.close();
    }

    public void testGetNode() throws RepositoryException, NotExecutableException {
        if (this.multiple) {
            try {
                this.prop.getNode();
                StringPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetProperty() throws RepositoryException, NotExecutableException {
        if (this.multiple) {
            try {
                this.prop.getProperty();
                StringPropertyTest.fail((String)"Property.getNode() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetLength() throws RepositoryException {
        if (this.multiple) {
            try {
                this.prop.getLength();
                StringPropertyTest.fail((String)"Property.getLength() called on a multivalue property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {}
        } else {
            long length = this.prop.getLength();
            if (length > -1L) {
                StringPropertyTest.assertEquals((String)"Property.getLength() returns wrong number of bytes.", (long)length, (long)this.prop.getString().length());
            }
        }
    }

    public void testGetLengths() throws RepositoryException {
        if (this.multiple) {
            Value[] values = this.prop.getValues();
            long[] lengths = this.prop.getLengths();
            for (int i = 0; i < lengths.length; ++i) {
                if (lengths[i] <= -1L) continue;
                StringPropertyTest.assertEquals((String)"Property.getLengths() returns wrong array of the lengths of a multivalue property.", (long)values[i].getString().length(), (long)lengths[i]);
            }
        } else {
            try {
                this.prop.getLengths();
                StringPropertyTest.fail((String)"Property.getLengths() called on a sinlge value property should throw a ValueFormatException.");
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
        }
    }

    public void testGetType() throws RepositoryException {
        StringPropertyTest.assertTrue((String)"Value.getType() returns wrong type.", (boolean)PropertyUtil.checkGetType(this.prop, 1));
    }
}

