/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;

public class GetInfoTest
extends AbstractObservationTest {
    public void testNodeAdded() throws RepositoryException {
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetInfoTest.this.testRootNode.addNode(GetInfoTest.this.nodeName1, GetInfoTest.this.testNodeType);
                GetInfoTest.this.testRootNode.getSession().save();
            }
        }, 1);
        for (int i = 0; i < events.length; ++i) {
            Set<?> unexpectedKeys = GetInfoTest.getUnexpectedKeys(events[i].getInfo());
            GetInfoTest.assertEquals((String)("info map contains invalid keys: " + String.valueOf(unexpectedKeys)), (int)0, (int)unexpectedKeys.size());
        }
    }

    public void testNodeRemoved() throws RepositoryException {
        final Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                n.remove();
                GetInfoTest.this.testRootNode.getSession().save();
            }
        }, 2);
        for (int i = 0; i < events.length; ++i) {
            Set<?> unexpectedKeys = GetInfoTest.getUnexpectedKeys(events[i].getInfo());
            GetInfoTest.assertEquals((String)"info map must be empty", (int)0, (int)unexpectedKeys.size());
        }
    }

    public void testPropertyAdded() throws RepositoryException {
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetInfoTest.this.testRootNode.addNode(GetInfoTest.this.nodeName1, GetInfoTest.this.testNodeType).setProperty(GetInfoTest.this.propertyName1, "test");
                GetInfoTest.this.testRootNode.getSession().save();
            }
        }, 4);
        for (int i = 0; i < events.length; ++i) {
            Set<?> unexpectedKeys = GetInfoTest.getUnexpectedKeys(events[i].getInfo());
            GetInfoTest.assertEquals((String)"info map must be empty", (int)0, (int)unexpectedKeys.size());
        }
    }

    public void testPropertyChanged() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        final Property prop = n.setProperty(this.propertyName1, "test");
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                prop.setValue("modified");
                prop.getSession().save();
            }
        }, 16);
        for (int i = 0; i < events.length; ++i) {
            Set<?> unexpectedKeys = GetInfoTest.getUnexpectedKeys(events[i].getInfo());
            GetInfoTest.assertEquals((String)("info map must be empty: " + String.valueOf(unexpectedKeys)), (int)0, (int)unexpectedKeys.size());
        }
    }

    public void testPropertyRemoved() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        final Property prop = n.setProperty(this.propertyName1, "test");
        this.testRootNode.getSession().save();
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                Session s = prop.getSession();
                prop.remove();
                s.save();
            }
        }, 8);
        for (int i = 0; i < events.length; ++i) {
            Set<?> unexpectedKeys = GetInfoTest.getUnexpectedKeys(events[i].getInfo());
            GetInfoTest.assertEquals((String)("info map must be empty: " + String.valueOf(unexpectedKeys)), (int)0, (int)unexpectedKeys.size());
        }
    }

    private static Set<?> getUnexpectedKeys(Map<?, ?> info) {
        HashSet result = new HashSet();
        result.addAll(info.keySet());
        result.remove("jcr:primaryType");
        result.remove("jcr:mixinTypes");
        return result;
    }
}

