/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class PropertyRemovedTest
extends AbstractObservationTest {
    public void testSinglePropertyRemoved() throws RepositoryException {
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property prop1 = node.setProperty(this.propertyName1, "foo");
        node.setProperty(this.propertyName2, "bar");
        this.testRootNode.getSession().save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 8);
        prop1.remove();
        this.testRootNode.getSession().save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkPropertyRemoved(events, new String[]{this.nodeName1 + "/" + this.propertyName1});
    }

    public void testMultiPropertyRemoved() throws RepositoryException {
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property prop1 = node.setProperty(this.propertyName1, "foo");
        Property prop2 = node.setProperty(this.propertyName2, "bar");
        this.testRootNode.getSession().save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 8);
        prop1.remove();
        prop2.remove();
        this.testRootNode.getSession().save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkPropertyRemoved(events, new String[]{this.nodeName1 + "/" + this.propertyName1, this.nodeName1 + "/" + this.propertyName2});
    }
}

