/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class SQLPathTest
extends AbstractQueryTest {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        if (this.testRootNode.hasNodes()) {
            NodeIterator it = this.testRootNode.getNodes();
            while (it.hasNext()) {
                if (!it.nextNode().hasNodes()) continue;
                return;
            }
        }
        SQLPathTest.fail((String)("Default workspace at " + this.testRoot + " does not contain sufficient content."));
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testDescendantTestRoot() throws RepositoryException, NotExecutableException {
        String sql = this.getStatement(this.testRoot + "/%");
        this.executeSqlQuery(this.session, sql, this.getDescendants(this.testRootNode));
    }

    public void testDescendantLeaf() throws RepositoryException, NotExecutableException {
        Node leaf = this.testRootNode;
        while (leaf.hasNodes()) {
            leaf = leaf.getNodes().nextNode();
        }
        String sql = this.getStatement(leaf.getPath() + "/%");
        this.executeSqlQuery(this.session, sql, new Node[0]);
    }

    public void testDescendantSelfTestRoot() throws RepositoryException, NotExecutableException {
        Node n = null;
        NodeIterator it = this.testRootNode.getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            if (!child.hasNodes()) continue;
            n = child.getNodes().nextNode();
            break;
        }
        final String name = n.getName();
        Object sql = this.getStatement(this.testRoot + "/%/" + name);
        sql = (String)sql + " OR " + this.jcrPath + " = '" + this.testRoot + "/" + name + "'";
        final ArrayList nodes = new ArrayList();
        this.testRootNode.accept((ItemVisitor)new TraversingItemVisitor.Default(){

            protected void entering(Node node, int level) throws RepositoryException {
                if (node.getName().equals(name) && !SQLPathTest.this.testRootNode.isSame((Item)node)) {
                    nodes.add(node);
                }
            }
        });
        this.executeSqlQuery(this.session, (String)sql, nodes.toArray(new Node[nodes.size()]));
    }

    public void testChildAxisRoot() throws RepositoryException, NotExecutableException {
        Object sql = this.getStatement("/%");
        sql = (String)sql + " AND NOT " + this.jcrPath + " LIKE '/%/%'";
        Node[] nodes = this.toArray(this.session.getRootNode().getNodes());
        Node[] optional = new Node[]{this.session.getRootNode()};
        this.executeSqlQuery(this.session, (String)sql, nodes, optional);
    }

    public void testChildAxisTestRoot() throws RepositoryException, NotExecutableException {
        Object sql = this.getStatement(this.testRoot + "/%");
        sql = (String)sql + " AND NOT " + this.jcrPath + " LIKE '" + this.testRoot + "/%/%'";
        Node[] nodes = this.toArray(this.testRootNode.getNodes());
        this.executeSqlQuery(this.session, (String)sql, nodes);
    }

    public void testChildAxisLeaf() throws RepositoryException, NotExecutableException {
        Node leaf = this.testRootNode;
        while (leaf.hasNodes()) {
            leaf = leaf.getNodes().nextNode();
        }
        Object sql = this.getStatement(leaf.getPath() + "/%");
        sql = (String)sql + " AND NOT " + this.jcrPath + " LIKE '" + leaf.getPath() + "/%/%'";
        this.executeSqlQuery(this.session, (String)sql, new Node[0]);
    }

    private String getStatement(String path) {
        return "SELECT * FROM " + this.ntBase + " WHERE " + this.jcrPath + " LIKE '" + path + "'";
    }

    private Node[] getDescendants(final Node node) throws RepositoryException {
        final ArrayList descendants = new ArrayList();
        node.accept((ItemVisitor)new TraversingItemVisitor.Default(){

            protected void entering(Node n, int level) throws RepositoryException {
                if (!node.isSame((Item)n)) {
                    descendants.add(n);
                }
            }
        });
        return descendants.toArray(new Node[descendants.size()]);
    }
}

