/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetPropertyStringTest
extends AbstractJCRTest {
    private Node testNode;
    private String s1 = "abc";
    private String s2 = "xyz";
    private String[] sArray1 = new String[3];
    private String[] sArray2 = new String[3];
    private String[] sArrayNull = new String[3];
    private Value[] vArray1 = new Value[3];
    private Value[] vArray2 = new Value[3];

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.sArray1[0] = "a";
        this.sArray1[1] = "b";
        this.sArray1[2] = "c";
        this.sArray2[0] = "x";
        this.sArray2[1] = "y";
        this.sArray2[2] = "z";
        this.sArrayNull[0] = null;
        this.sArrayNull[1] = null;
        this.sArrayNull[2] = null;
        this.vArray1[0] = this.superuser.getValueFactory().createValue("a");
        this.vArray1[1] = this.superuser.getValueFactory().createValue("b");
        this.vArray1[2] = this.superuser.getValueFactory().createValue("c");
        this.vArray2[0] = this.superuser.getValueFactory().createValue("x");
        this.vArray2[1] = this.superuser.getValueFactory().createValue("y");
        this.vArray2[2] = this.superuser.getValueFactory().createValue("z");
    }

    @Override
    protected void tearDown() throws Exception {
        int i;
        this.testNode = null;
        for (i = 0; i < this.vArray1.length; ++i) {
            this.vArray1[i] = null;
        }
        for (i = 0; i < this.vArray2.length; ++i) {
            this.vArray2[i] = null;
        }
        super.tearDown();
    }

    public void testNewStringPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Setting property with Node.setProperty(String, String) and Session.save() not working", (String)this.s1, (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testModifyStringPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.s2);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Modifying property with Node.setProperty(String, String) and Session.save() not working", (String)this.s2, (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testNewStringPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertEquals((String)"Setting property with Node.setProperty(String, String) and parentNode.save() not working", (String)this.s1, (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testModifyStringPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName1, this.s2);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertEquals((String)"Modifying property with Node.setProperty(String, String) and parentNode.save() not working", (String)this.s2, (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testRemoveStringPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (String)null);
        this.superuser.save();
        SetPropertyStringTest.assertFalse((String)"Removing property with Node.setProperty(String, (String)null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveStringPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName1, (String)null);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertFalse((String)"Removing property with Node.setProperty(String, (String)null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testNewStringPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1, 1);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Setting property with Node.setProperty(String, String, int) and Session.save() not working", (String)this.s1, (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testModifyStringPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1, 1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.s2, 1);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Modifying property with Node.setProperty(String, String, int) and Session.save() not working", (String)this.s2, (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testNewStringPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1, 1);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertEquals((String)"Setting property with Node.setProperty(String, String, int) and parentNode.save() not working", (String)this.s1, (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testModifyStringPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1, 1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName1, this.s2, 1);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertEquals((String)"Modifying property with Node.setProperty(String, String, int) and parentNode.save() not working", (String)this.s2, (String)this.testNode.getProperty(this.propertyName1).getString());
    }

    public void testRemoveStringPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1, 1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (String)null, 1);
        this.superuser.save();
        SetPropertyStringTest.assertFalse((String)"Removing property with Node.setProperty(String, (String)null, int) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveStringPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.s1, 1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName1, (String)null, 1);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertFalse((String)"Removing property with Node.setProperty(String, (String)null, int) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testNewStringArrayPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Setting properties with Node.setProperty(String, String[]) and Session.save() not working", Arrays.asList(this.vArray1), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testModifyStringArrayPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName2, this.sArray2);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Modifying properties with Node.setProperty(String, String[]) and Session.save() not working", Arrays.asList(this.vArray2), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testNewStringArrayPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertEquals((String)"Setting properties with Node.setProperty(String, String[]) and parentNode.save() not working", Arrays.asList(this.vArray1), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testModifyStringArrayPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName2, this.sArray2);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertEquals((String)"Modifying properties with Node.setProperty(String, String[]) and parentNode.save() not working", Arrays.asList(this.vArray2), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testSetSingleStringArrayValueFormatException() throws Exception {
        if (!this.testNode.hasProperty(this.propertyName1)) {
            this.testNode.setProperty(this.propertyName1, this.s1);
            this.testNode.getParent().save();
        }
        try {
            this.testNode.setProperty(this.propertyName1, this.sArray1);
            SetPropertyStringTest.fail((String)"setProperty(singleValueProperty, String[]) not throwing a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testRemoveStringArrayPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName2, (String[])null);
        this.superuser.save();
        SetPropertyStringTest.assertFalse((String)"Removing property with Node.setProperty(String, (String[])null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName2));
    }

    public void testRemoveStringArrayPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName2, (String[])null);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertFalse((String)"Removing property with Node.setProperty(String, (String[])null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName2));
    }

    public void testSetNullStringArray() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArrayNull);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Node.setProperty(String, nullStringArray[]) did not set the property to an empty String[]", Arrays.asList(new Value[0]), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testNewStringArrayPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1, 1);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Setting properties with Node.setProperty(String, String[], int) and Session.save() not working", Arrays.asList(this.vArray1), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testModifyStringArrayPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1, 1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName2, this.sArray2, 1);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Modifying properties with Node.setProperty(String, String[], int) and Session.save() not working", Arrays.asList(this.vArray2), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testNewStringArrayPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1, 1);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertEquals((String)"Setting properties with Node.setProperty(String, String[], int) and parentNode.save() not working", Arrays.asList(this.vArray1), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testModifyStringArrayPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1, 1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName2, this.sArray2, 1);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertEquals((String)"Modifying properties with Node.setProperty(String, String[], int) and parentNode.save() not working", Arrays.asList(this.vArray2), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testSetSingleStringArrayValueFormatExceptionWithPropertyType() throws Exception {
        if (!this.testNode.hasProperty(this.propertyName1)) {
            this.testNode.setProperty(this.propertyName1, this.s1);
            this.testNode.getParent().save();
        }
        try {
            this.testNode.setProperty(this.propertyName1, this.sArray1, 1);
            SetPropertyStringTest.fail((String)"setProperty(singleValueProperty, String[], int) not throwing a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testRemoveStringArrayPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1, 1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName2, (String[])null, 1);
        this.superuser.save();
        SetPropertyStringTest.assertFalse((String)"Removing property with Node.setProperty(String, (String[])null, int) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName2));
    }

    public void testRemoveStringArrayPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArray1, 1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName2, (String[])null, 1);
        this.testRootNode.getSession().save();
        SetPropertyStringTest.assertFalse((String)"Removing property with Node.setProperty(String, (String[])null, int) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName2));
    }

    public void testSetNullStringArrayWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.sArrayNull, 1);
        this.superuser.save();
        SetPropertyStringTest.assertEquals((String)"Node.setProperty(String, nullStringArray[], int) did not set the property to an empty Value[]", Arrays.asList(new Value[0]), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }
}

