/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.lock;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SetValueLockExceptionTest
extends AbstractJCRTest {
    private Node testNode;
    private static final String binaryProp = "binaryProp";
    private static final String booleanProp = "booleanProp";
    private static final String dateProp = "dateProp";
    private static final String doubleProp = "doubleProp";
    private static final String longProp = "longProp";
    private static final String referenceProp = "referenceProp";
    private static final String stringProp = "stringProp";
    private static final String multiStringProp = "multiStringProp";
    private static final boolean booleanValue = false;
    private Calendar dateValue = null;
    private static final double doubleValue = 3.1414926;
    private static final long longValue = Long.MAX_VALUE;
    private Node referenceNode = null;
    private static final String stringValue = "a string";
    private byte[] binaryValue = null;
    private String[] multiString = new String[]{"one", "two", "three"};
    private static final int TYPE_VALUE = 20;
    private static final int TYPE_MULTIVAL = 21;
    private static final int TYPE_MULTSTRING = 22;
    private static int[] types = new int[]{5, 4, 3, 9, 1, 2, 6, 20, 21, 22};

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("SetValueLockExceptionTest not executable: Locking not supported");
        }
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(this.testNode, this.mixLockable);
        this.dateValue = Calendar.getInstance();
        this.referenceNode = this.createReferenceableNode(this.nodeName2);
        this.binaryValue = this.createRandomString(10).getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(this.binaryValue);
        this.ensureCanSetProperty(this.testNode, binaryProp, 2, false);
        this.testNode.setProperty(binaryProp, (InputStream)in);
        this.ensureCanSetProperty(this.testNode, booleanProp, 6, false);
        this.testNode.setProperty(booleanProp, false);
        this.ensureCanSetProperty(this.testNode, dateProp, 5, false);
        this.testNode.setProperty(dateProp, this.dateValue);
        this.ensureCanSetProperty(this.testNode, doubleProp, 4, false);
        this.testNode.setProperty(doubleProp, 3.1414926);
        this.ensureCanSetProperty(this.testNode, longProp, 3, false);
        this.testNode.setProperty(longProp, Long.MAX_VALUE);
        if (this.referenceNode != null) {
            this.ensureCanSetProperty(this.testNode, referenceProp, 9, false);
            this.testNode.setProperty(referenceProp, this.referenceNode);
        }
        this.ensureCanSetProperty(this.testNode, stringProp, 1, false);
        this.testNode.setProperty(stringProp, stringValue);
        this.ensureCanSetProperty(this.testNode, multiStringProp, 1, true);
        this.testNode.setProperty(multiStringProp, this.multiString);
        this.testRootNode.getSession().save();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.testNode.holdsLock()) {
            this.testNode.unlock();
        }
        this.testNode = null;
        this.referenceNode = null;
        this.superuser.save();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestSetValueLockException(int type) throws RepositoryException {
        if (!this.testNode.holdsLock()) {
            this.testNode.lock(false, false);
            this.superuser.save();
        }
        Session session = this.getHelper().getReadWriteSession();
        try {
            Node node = (Node)session.getItem(this.testNode.getPath());
            Property prop = null;
            switch (type) {
                case 2: {
                    ByteArrayInputStream in = new ByteArrayInputStream(this.binaryValue);
                    prop = node.getProperty(binaryProp);
                    prop.setValue((InputStream)in);
                    break;
                }
                case 6: {
                    prop = node.getProperty(booleanProp);
                    prop.setValue(false);
                    break;
                }
                case 5: {
                    prop = node.getProperty(dateProp);
                    prop.setValue(this.dateValue);
                    break;
                }
                case 4: {
                    prop = node.getProperty(doubleProp);
                    prop.setValue(3.1414926);
                    break;
                }
                case 3: {
                    prop = node.getProperty(longProp);
                    prop.setValue(Long.MAX_VALUE);
                    break;
                }
                case 9: {
                    prop = node.getProperty(referenceProp);
                    if (this.referenceNode == null) break;
                    prop.setValue(this.referenceNode);
                    break;
                }
                case 1: {
                    prop = node.getProperty(stringProp);
                    prop.setValue(stringValue);
                    break;
                }
                case 20: {
                    prop = node.getProperty(stringProp);
                    Value value = session.getValueFactory().createValue(stringValue);
                    prop.setValue(value);
                    break;
                }
                case 21: {
                    prop = node.getProperty(multiStringProp);
                    Value[] values = new Value[]{session.getValueFactory().createValue(stringValue), session.getValueFactory().createValue(stringValue), session.getValueFactory().createValue(stringValue)};
                    prop.setValue(values);
                    break;
                }
                case 22: {
                    prop = node.getProperty(multiStringProp);
                    String[] strVals = new String[]{stringValue, stringValue, stringValue};
                    prop.setValue(strVals);
                }
            }
            session.save();
            SetValueLockExceptionTest.fail((String)"Property.setValue should throw a LockException if the parent node holds a Lock.");
        }
        catch (LockException lockException) {
        }
        finally {
            session.logout();
        }
    }

    public void testSetValueLockException() throws RepositoryException {
        for (int i = 0; i < types.length; ++i) {
            this.doTestSetValueLockException(types[i]);
        }
    }

    public Node createReferenceableNode(String name) throws RepositoryException {
        try {
            Node node = this.testRootNode.getNode(name);
            node.remove();
            this.superuser.save();
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Node n1 = this.testRootNode.addNode(name, this.testNodeType);
        if (n1.canAddMixin(this.mixReferenceable)) {
            n1.addMixin(this.mixReferenceable);
            this.superuser.save();
            return n1;
        }
        return null;
    }
}

