/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanAddChildNodeCallWithNodeTypeTest
extends AbstractJCRTest {
    private Session session;
    private NodeTypeManager manager;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.manager = this.session.getWorkspace().getNodeTypeManager();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.manager = null;
        super.tearDown();
    }

    public void testDefinedAndLegalType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No child node def with defaultPrimaryType found");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String childNodeName = nodeDef.getName();
        String nodeTypeName = nodeDef.getRequiredPrimaryTypes()[0].getName();
        if (nodeTypeName.equals(this.ntBase)) {
            nodeTypeName = this.ntUnstructured;
        }
        CanAddChildNodeCallWithNodeTypeTest.assertTrue((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return true if childNodeName and nodeTypeName match the child node def of NodeType.", (boolean)nodeType.canAddChildNode(childNodeName, nodeTypeName));
    }

    public void testDefinedAndIllegalType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable node type found.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String childNodeName = nodeDef.getName();
        String legalType = nodeDef.getRequiredPrimaryTypes()[0].getName();
        String illegalType = NodeTypeUtil.getIllegalChildNodeType(this.manager, legalType);
        if (illegalType == null) {
            throw new NotExecutableException("No illegal node type name found");
        }
        CanAddChildNodeCallWithNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return false if childNodeName does and nodeTypeName does not match the child node def of NodeType.", (boolean)nodeType.canAddChildNode(childNodeName, illegalType));
    }

    public void testCanAddMixinType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable node type found.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String childNodeName = nodeDef.getName();
        NodeTypeIterator it = this.manager.getMixinNodeTypes();
        if (!it.hasNext()) {
            throw new NotExecutableException("No mixin type found.");
        }
        String mixinName = it.nextNodeType().getName();
        CanAddChildNodeCallWithNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return false if nodeTypeName represents a mixin type.", (boolean)nodeType.canAddChildNode(childNodeName, mixinName));
    }

    public void testCanAddAbstractType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable node type found.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String childNodeName = nodeDef.getName();
        String abstractName = null;
        NodeTypeIterator it = this.manager.getPrimaryNodeTypes();
        while (it.hasNext() && abstractName == null) {
            NodeType nt = it.nextNodeType();
            if (!nt.isAbstract()) continue;
            abstractName = nt.getName();
        }
        if (abstractName == null) {
            throw new NotExecutableException("No abstract type found.");
        }
        CanAddChildNodeCallWithNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return false if nodeTypeName represents an abstract node type.", (boolean)nodeType.canAddChildNode(childNodeName, abstractName));
    }

    public void testUndefined() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, true, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable node type found.");
        }
        String type = nodeDef.getRequiredPrimaryTypes()[0].getName();
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        CanAddChildNodeCallWithNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return false if childNodeName does not match the child node def of NodeType.", (boolean)nodeType.canAddChildNode(undefinedName, type));
    }

    public void testResidualAndLegalType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, true);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable residual child node def.");
        }
        String type = nodeDef.getRequiredPrimaryTypes()[0].getName();
        if (type.equals(this.ntBase)) {
            type = this.ntUnstructured;
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        CanAddChildNodeCallWithNodeTypeTest.assertTrue((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return true for a not defined childNodeName if nodeTypeName matches the type of a residual child node def", (boolean)nodeType.canAddChildNode(undefinedName, type));
    }

    public void testResidualAndIllegalType() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, false, true);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable residual child node def.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        String legalType = nodeDef.getRequiredPrimaryTypes()[0].getName();
        String illegalType = NodeTypeUtil.getIllegalChildNodeType(this.manager, legalType);
        if (illegalType == null) {
            throw new NotExecutableException("No illegal node type name found");
        }
        CanAddChildNodeCallWithNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName, String nodeTypeName) must return false for a not defined childNodeName if nodeTypeName does not matches the type of a residual child node def", (boolean)nodeType.canAddChildNode(undefinedName, illegalType));
    }
}

